/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.resources.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.gcube.informationsystem.model.embedded.Header;
import org.gcube.informationsystem.model.entity.Entity;
import org.gcube.informationsystem.model.entity.Facet;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.model.relation.ConsistsOf;
import org.gcube.informationsystem.model.relation.IsRelatedTo;
import org.gcube.informationsystem.model.relation.Relation;
import org.gcube.informationsystem.resourceregistry.api.EntityManagement;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.FacetNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.context.SecurityContextMapper;
import org.gcube.informationsystem.resourceregistry.resources.impl.EntityManagementImpl;
import org.gcube.informationsystem.resourceregistry.resources.impl.SchemaManagementImpl;
import org.gcube.informationsystem.resourceregistry.resources.utils.ContextUtility;
import org.gcube.informationsystem.resourceregistry.resources.utils.HeaderUtility;
import org.gcube.informationsystem.resourceregistry.resources.utils.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class EntityManagementImpl
implements EntityManagement {
    private static Logger logger = LoggerFactory.getLogger(EntityManagementImpl.class);

    public Vertex getEntity(OrientGraph orientGraph, UUID uuid, String entityType, Class<? extends Entity> entityClass) throws FacetNotFoundException, ResourceNotFoundException, ResourceRegistryException {
        try {
            if (entityType == null || entityType.compareTo("") == 0) {
                if (Facet.class.isAssignableFrom(entityClass)) {
                    entityType = "Facet";
                }
                if (Resource.class.isAssignableFrom(entityClass)) {
                    entityType = "Resource";
                }
            }
            return Utility.getEntityByUUID((OrientGraph)orientGraph, (String)entityType, (UUID)uuid);
        }
        catch (ResourceRegistryException e) {
            if (Facet.class.isAssignableFrom(entityClass)) {
                throw new FacetNotFoundException(e.getMessage());
            }
            if (Resource.class.isAssignableFrom(entityClass)) {
                throw new ResourceNotFoundException(e.getMessage());
            }
            throw e;
        }
    }

    public Edge getRelation(OrientGraph orientGraph, UUID uuid, String relationType, Class<? extends Relation> relationClass) throws ResourceRegistryException {
        try {
            if (relationType == null || relationType.compareTo("") == 0) {
                if (IsRelatedTo.class.isAssignableFrom(relationClass)) {
                    relationType = "IsRelatedTo";
                }
                if (ConsistsOf.class.isAssignableFrom(relationClass)) {
                    relationType = "ConsistsOf";
                }
            }
            return Utility.getRelationByUUID((OrientGraph)orientGraph, (String)relationType, (UUID)uuid);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    private static String lowerCaseFirstCharacter(String string) {
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    private static String getClassProperty(JsonNode jsonNode) {
        if (jsonNode.has("@class")) {
            return jsonNode.get("@class").asText();
        }
        return null;
    }

    private static ODocument getEmbeddedType(JsonNode jsonNode) throws ResourceRegistryException {
        if (jsonNode.has("@class")) {
            String type = EntityManagementImpl.getClassProperty((JsonNode)jsonNode);
            SchemaManagementImpl schemaManagement = new SchemaManagementImpl();
            schemaManagement.getTypeSchema(type, "Embedded");
            Header header = null;
            try {
                header = HeaderUtility.getHeader((JsonNode)jsonNode, (boolean)false);
            }
            catch (Exception e) {
                logger.warn("An invalid Header has been provided. An embedded object cannot have an Header.  It will be ignored.");
                throw new ResourceRegistryException("An embedded object cannot have an Header");
            }
            if (header != null) {
                logger.warn("An embedded object cannot have an Header. It will be ignored.");
                throw new ResourceRegistryException("An embedded object cannot have an Header");
            }
            ODocument oDocument = new ODocument(type);
            return oDocument.fromJSON(jsonNode.toString());
        }
        return null;
    }

    public static Object getObjectFromElement(JsonNode value) throws ResourceRegistryException {
        JsonNodeType jsonNodeType = value.getNodeType();
        switch (1.$SwitchMap$com$fasterxml$jackson$databind$node$JsonNodeType[jsonNodeType.ordinal()]) {
            case 1: {
                return EntityManagementImpl.getEmbeddedType((JsonNode)value);
            }
            case 2: {
                ArrayList<Object> array = new ArrayList<Object>();
                Iterator arrayElement = value.elements();
                while (arrayElement.hasNext()) {
                    JsonNode arrayNode = (JsonNode)arrayElement.next();
                    Object objectNode = EntityManagementImpl.getObjectFromElement((JsonNode)arrayNode);
                    if (objectNode == null) continue;
                    array.add(objectNode);
                }
                return array;
            }
            case 3: {
                break;
            }
            case 4: {
                return value.asBoolean();
            }
            case 5: {
                break;
            }
            case 6: {
                if (value.isDouble() || value.isFloat()) {
                    return value.asDouble();
                }
                if (value.isBigInteger() || value.isShort() || value.isInt()) {
                    return value.asInt();
                }
                if (!value.isLong()) break;
                return value.asLong();
            }
            case 7: {
                return value.asText();
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
        }
        return null;
    }

    public static Map<String, Object> getPropertyMap(JsonNode jsonNode, Set<String> ignoreKeys) throws JsonProcessingException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (ignoreKeys == null) {
            ignoreKeys = new HashSet<String>();
        }
        Iterator fields = jsonNode.fields();
        while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            String key = (String)entry.getKey();
            if (key.compareTo("header") == 0 || key.startsWith("@") || key.startsWith("_") || ignoreKeys.contains(key)) continue;
            JsonNode value = (JsonNode)entry.getValue();
            Object object = null;
            try {
                object = EntityManagementImpl.getObjectFromElement((JsonNode)value);
                if (object == null) continue;
                map.put(key, object);
            }
            catch (ResourceRegistryException e) {
                logger.warn("An invalidy property has been provided. It will be ignored.");
            }
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createRelations(OrientGraph orientGraph, Vertex resource, JsonNode relationArray, Class<? extends Relation> relation) throws FacetNotFoundException, ResourceNotFoundException, ResourceRegistryException {
        Iterator iterator = relationArray.elements();
        while (iterator.hasNext()) {
            JsonNode node = (JsonNode)iterator.next();
            JsonNode target = node.get("target");
            Header targetHeader = null;
            try {
                targetHeader = HeaderUtility.getHeader((JsonNode)target, (boolean)false);
            }
            catch (IOException e) {
                throw new ResourceRegistryException((Throwable)e);
            }
            Vertex targetVertex = null;
            if (targetHeader == null) {
                if (!ConsistsOf.class.isAssignableFrom(relation)) {
                    String error = String.format("%s %s must already exist. The UUID must be provided in the %s of %s json respresentation", "target", "Resource", "Header", "IsRelatedTo");
                    logger.error(error);
                    throw new ResourceRegistryException(error);
                }
                targetVertex = this.createVertexEntity(orientGraph, EntityManagementImpl.getClassProperty((JsonNode)target), Facet.class, target.toString(), true);
                targetHeader = (Header)targetVertex.getProperty("header");
            } else {
                Class<Facet> targetClass = null;
                if (ConsistsOf.class.isAssignableFrom(relation)) {
                    targetClass = Facet.class;
                } else {
                    if (!IsRelatedTo.class.isAssignableFrom(relation)) {
                        String error = String.format("%s Unsupported %s creation", relation.toString(), "Relation");
                        logger.error(error);
                        throw new ResourceRegistryException(error);
                    }
                    targetClass = Resource.class;
                }
                UUID targetUUID = targetHeader.getUUID();
                String entityType = EntityManagementImpl.getClassProperty((JsonNode)target);
                targetVertex = this.getEntity(orientGraph, targetUUID, entityType, targetClass);
            }
            String relationType = EntityManagementImpl.getClassProperty((JsonNode)node);
            HashSet<String> ignoreKeys = new HashSet<String>();
            ignoreKeys.add("target");
            ignoreKeys.add("source");
            ignoreKeys.add("header");
            Map edgeProperties = null;
            try {
                edgeProperties = EntityManagementImpl.getPropertyMap((JsonNode)node, ignoreKeys);
            }
            catch (Exception e) {
                String error = "Error while parsing json to get Relation properties";
                logger.error(error, (Throwable)e);
                throw new ResourceRegistryException(error, (Throwable)e);
            }
            this.createEdgeRelation(orientGraph, resource, targetVertex, relationType, relation, edgeProperties, true);
        }
        return;
    }

    public Vertex createVertexEntity(String entityType, Class<? extends Entity> entity, String jsonRepresentation, boolean deferredCommit) throws ResourceRegistryException {
        OrientGraph orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
        return this.createVertexEntity(orientGraph, entityType, entity, jsonRepresentation, deferredCommit);
    }

    public Vertex createVertexEntity(OrientGraph orientGraph, String entityType, Class<? extends Entity> entity, String jsonRepresentation, boolean deferredCommit) throws ResourceRegistryException {
        logger.trace("Going to create {} for {} ({}) using {}", new Object[]{Vertex.class.getSimpleName(), entity.getClass().getSimpleName(), entityType, jsonRepresentation});
        try {
            SchemaManagementImpl schemaManagement = new SchemaManagementImpl();
            schemaManagement.getTypeSchema(entityType, entity.getSimpleName());
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNode = mapper.readTree(jsonRepresentation);
            String type = EntityManagementImpl.getClassProperty((JsonNode)jsonNode);
            if (type != null && type.compareTo(entityType) != 0) {
                String error = String.format("Declared resourceType does not match with json representation %s!=%s", entityType, type);
                logger.trace(error);
                throw new ResourceRegistryException(error);
            }
            OrientVertex vertex = orientGraph.addVertex((Object)("class:" + entityType));
            Header entityHeader = HeaderUtility.getHeader((JsonNode)jsonNode, (boolean)true);
            if (entityHeader != null) {
                vertex.setProperty("header", (Object)entityHeader);
            } else {
                entityHeader = HeaderUtility.addHeader((Vertex)vertex, null);
            }
            if (!Resource.class.isAssignableFrom(entity)) {
                HashSet ignoreKeys = new HashSet();
                Map properties = null;
                try {
                    properties = EntityManagementImpl.getPropertyMap((JsonNode)jsonNode, ignoreKeys);
                }
                catch (Exception e) {
                    String error = "Error while parsing json to get Relation properties";
                    logger.error(error, (Throwable)e);
                    throw new ResourceRegistryException(error, (Throwable)e);
                }
                for (String key : properties.keySet()) {
                    try {
                        vertex.setProperty(key, properties.get(key));
                    }
                    catch (Exception e) {
                        String error = String.format("Error while setting property %s : %s", key, properties.get(key).toString());
                        logger.error(error);
                        throw new ResourceRegistryException(error, (Throwable)e);
                    }
                }
            }
            ContextUtility.addToActualContext((OrientGraph)orientGraph, (Vertex)vertex);
            vertex.save();
            if (!deferredCommit) {
                orientGraph.commit();
            }
            logger.info("Created {} is {}", (Object)Vertex.class.getSimpleName(), (Object)Utility.toJsonString((OrientElement)vertex, (boolean)true));
            OrientVertex orientVertex = vertex;
            return orientVertex;
        }
        catch (Exception e) {
            logger.trace("Error while creating {} for {} ({}) using {}", new Object[]{Vertex.class.getSimpleName(), entity.getClass().getSimpleName(), entityType, jsonRepresentation, e});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceRegistryException("Error Creating " + entityType + " with " + jsonRepresentation, e.getCause());
        }
        finally {
            if (orientGraph != null && !deferredCommit) {
                orientGraph.shutdown();
            }
        }
    }

    public Edge createEdgeRelation(UUID sourceUUID, Class<? extends Entity> sourceClass, UUID targetUUID, Class<? extends Entity> targetClass, String relationType, Class<? extends Relation> relationBaseClass, String jsonProperties) throws FacetNotFoundException, ResourceNotFoundException, ResourceRegistryException {
        logger.trace("Trying to create {} with {}", (Object)relationType, (Object)jsonProperties);
        OrientGraph orientGraph = null;
        if (relationType == null || relationType.compareTo("") == 0) {
            throw new ResourceRegistryException(Relation.class.getSimpleName() + "type cannot be empty or null");
        }
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            Vertex source = this.getEntity(orientGraph, sourceUUID, null, sourceClass);
            Vertex target = this.getEntity(orientGraph, targetUUID, null, targetClass);
            Map edgeProperties = new HashMap();
            if (jsonProperties != null && jsonProperties.compareTo("") != 0) {
                try {
                    HashSet<String> ignoreKeys = new HashSet<String>();
                    ignoreKeys.add("source");
                    ignoreKeys.add("target");
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode jsonNode = mapper.readTree(jsonProperties);
                    edgeProperties = EntityManagementImpl.getPropertyMap((JsonNode)jsonNode, ignoreKeys);
                }
                catch (Exception e) {
                    throw new ResourceRegistryException("Error while setting Relation Properties", (Throwable)e);
                }
            }
            return this.createEdgeRelation(orientGraph, source, target, relationType, relationBaseClass, edgeProperties, false);
        }
        catch (ResourceNotFoundException rnfe) {
            logger.trace("Error Creating {} with {}", new Object[]{relationType, jsonProperties, rnfe});
            throw rnfe;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public Edge createEdgeRelation(OrientGraph orientGraph, Vertex source, Vertex target, String relationType, Class<? extends Relation> relationBaseClass, Map<String, Object> edgeProperties, boolean deferredCommit) throws ResourceRegistryException {
        logger.debug("Trying to create {} with properties {}", (Object)relationType, edgeProperties);
        try {
            SchemaManagementImpl schemaManagement = new SchemaManagementImpl();
            schemaManagement.getTypeSchema(relationType, relationBaseClass.getSimpleName());
            if (relationType == null || relationType.compareTo("") == 0) {
                throw new ResourceRegistryException(Relation.class.getSimpleName() + " Type cannot be empty or null");
            }
            logger.trace("Creating {} ({}) beetween {} -> {}", new Object[]{Relation.class.getSimpleName(), relationType, Utility.toJsonString((Element)source, (boolean)true), Utility.toJsonString((Element)target, (boolean)true)});
            OrientEdge edge = orientGraph.addEdge(null, source, target, relationType);
            for (String key : edgeProperties.keySet()) {
                try {
                    edge.setProperty(key, edgeProperties.get(key));
                }
                catch (Exception e) {
                    String error = String.format("Error while setting property %s : %s", key, edgeProperties.get(key).toString());
                    logger.error(error);
                    throw new ResourceRegistryException(error, (Throwable)e);
                }
            }
            HeaderUtility.addHeader((Edge)edge, null);
            ContextUtility.addToActualContext((OrientGraph)orientGraph, (Edge)edge);
            edge.save();
            if (!deferredCommit) {
                orientGraph.commit();
            }
            logger.info("{} with properties {} successfully created", (Object)relationType, edgeProperties);
            OrientEdge orientEdge = edge;
            return orientEdge;
        }
        catch (ResourceRegistryException rre) {
            logger.error("Error Creating {} with  properties {}", new Object[]{relationType, edgeProperties, rre});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw rre;
        }
        catch (Exception e) {
            logger.error("Error Creating {} with  properties {}", new Object[]{relationType, edgeProperties, e});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (orientGraph != null && !deferredCommit) {
                orientGraph.shutdown();
            }
        }
    }

    public String createFacet(String facetType, String jsonRepresentation) throws ResourceRegistryException {
        Vertex vertex = this.createVertexEntity(facetType, Facet.class, jsonRepresentation, false);
        return Utility.toJsonString((OrientElement)((OrientVertex)vertex), (boolean)false);
    }

    public String readFacet(UUID uuid) throws FacetNotFoundException, ResourceRegistryException {
        return this.readFacet(uuid, "Facet");
    }

    public String readFacet(UUID uuid, String facetType) throws FacetNotFoundException, ResourceRegistryException {
        logger.debug("Going to read {} ({}) with UUID {}", new Object[]{"Facet", facetType, uuid});
        OrientGraph orientGraph = null;
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER);
            Vertex facet = this.getEntity(orientGraph, uuid, facetType, Facet.class);
            logger.info("{} of type {} with UUID {} is {}", new Object[]{"Facet", facetType, uuid, Utility.toJsonString((OrientElement)((OrientVertex)facet), (boolean)true)});
            String string = Utility.toJsonString((OrientElement)((OrientVertex)facet), (boolean)true);
            return string;
        }
        catch (FacetNotFoundException fnfe) {
            logger.error("Unable to read {} ({}) with UUID {}", new Object[]{"Facet", facetType, uuid, fnfe});
            throw fnfe;
        }
        catch (Exception e) {
            logger.error("Unable to read {} ({}) with UUID {}", new Object[]{"Facet", facetType, uuid, e});
            throw new ResourceRegistryException(e.getMessage());
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    public String updateFacet(UUID uuid, String jsonRepresentation) throws ResourceRegistryException {
        logger.debug("Trying to update {} with UUID {} usign {}", new Object[]{"Facet", uuid, jsonRepresentation});
        OrientGraph orientGraph = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNode = mapper.readTree(jsonRepresentation);
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            String entityType = EntityManagementImpl.getClassProperty((JsonNode)jsonNode);
            Vertex facet = this.getEntity(orientGraph, uuid, entityType, Facet.class);
            Set oldKeys = facet.getPropertyKeys();
            HashSet ignoreKeys = new HashSet();
            Map properties = null;
            try {
                properties = EntityManagementImpl.getPropertyMap((JsonNode)jsonNode, ignoreKeys);
            }
            catch (Exception e) {
                String error = "Error while parsing json to get Relation properties";
                logger.error(error, (Throwable)e);
                throw new ResourceRegistryException(error, (Throwable)e);
            }
            oldKeys.removeAll(properties.keySet());
            for (String key : properties.keySet()) {
                try {
                    facet.setProperty(key, properties.get(key));
                }
                catch (Exception e) {
                    String error = String.format("Error while setting property %s : %s", key, properties.get(key).toString());
                    logger.error(error);
                    throw new ResourceRegistryException(error, (Throwable)e);
                }
            }
            for (String key : oldKeys) {
                if (key.startsWith("_") || key.compareTo("header") == 0) continue;
                facet.removeProperty(key);
            }
            ((OrientVertex)facet).save();
            orientGraph.commit();
            logger.info("{} with UUID {} has been updated {}", new Object[]{"Facet", uuid, Utility.toJsonString((OrientElement)((OrientVertex)facet), (boolean)true)});
            String string = Utility.toJsonString((OrientElement)((OrientVertex)facet), (boolean)false);
            return string;
        }
        catch (FacetNotFoundException fnfe) {
            logger.debug("Unable to update {} with UUID {} usign {}", new Object[]{"Facet", uuid, jsonRepresentation, fnfe});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw fnfe;
        }
        catch (Exception e) {
            logger.debug("Unable to update {} with UUID {} usign {}", new Object[]{"Facet", uuid, jsonRepresentation, e});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceRegistryException("Error Updating Facet", e.getCause());
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    public boolean deleteFacet(UUID uuid) throws FacetNotFoundException, ResourceRegistryException {
        logger.debug("Going to delete {} with UUID {}", (Object)"Facet", (Object)uuid);
        OrientGraph orientGraph = null;
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            Vertex facet = this.getEntity(orientGraph, uuid, "Facet", Facet.class);
            facet.remove();
            orientGraph.commit();
            logger.info("{} with UUID {} was successfully deleted.", (Object)"Facet", (Object)uuid);
        }
        catch (FacetNotFoundException fnfe) {
            logger.error("Unable to delete {} with UUID {}", new Object[]{"Facet", uuid, fnfe});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw fnfe;
        }
        catch (Exception e) {
            logger.error("Unable to delete {} with UUID {}", new Object[]{"Facet", uuid, e});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
        return true;
    }

    public String attachFacet(UUID resourceUUID, UUID facetUUID, String consistOfType, String jsonProperties) throws FacetNotFoundException, ResourceNotFoundException, ResourceRegistryException {
        Edge edge = this.createEdgeRelation(resourceUUID, Resource.class, facetUUID, Facet.class, consistOfType, ConsistsOf.class, jsonProperties);
        return Utility.toJsonString((OrientElement)((OrientEdge)edge), (boolean)false);
    }

    public boolean detachFacet(UUID consistsOfUUID) throws ResourceRegistryException {
        OrientGraph orientGraph = null;
        logger.debug("Going to remove {} {} with UUID {}. {} will be detached from its {}.", new Object[]{"ConsistsOf", "Relation", consistsOfUUID, "Facet", "Resource"});
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            Edge edge = this.getRelation(orientGraph, consistsOfUUID, "ConsistsOf", ConsistsOf.class);
            edge.remove();
            orientGraph.commit();
            logger.info("{} {} with UUID {} successfully removed. {} has been detached from its {}.", new Object[]{"ConsistsOf", "Relation", consistsOfUUID, "Facet", "Resource"});
        }
        catch (FacetNotFoundException fnfe) {
            logger.error("Unable to remove {} {} with UUID {}. {} has not been detached from its {}.", new Object[]{"ConsistsOf", "Relation", consistsOfUUID, "Facet", "Resource"});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw fnfe;
        }
        catch (Exception e) {
            logger.error("Unable to remove {} {} with UUID {}. {} has not been detached from its {}.", new Object[]{"ConsistsOf", "Relation", consistsOfUUID, "Facet", "Resource"});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
        return true;
    }

    public String attachResource(UUID sourceResourceUuid, UUID targetResourceUuid, String relatedToType, String jsonProperties) throws ResourceNotFoundException, ResourceRegistryException {
        Edge edge = this.createEdgeRelation(sourceResourceUuid, Resource.class, targetResourceUuid, Resource.class, relatedToType, IsRelatedTo.class, jsonProperties);
        return Utility.toJsonString((OrientElement)((OrientEdge)edge), (boolean)false);
    }

    public boolean detachResource(UUID isRelatedToUUID) throws ResourceRegistryException {
        logger.debug("Going to remove {} {} with UUID {}. Related {}s will be detached.", new Object[]{"IsRelatedTo", "Relation", isRelatedToUUID, "Resource"});
        OrientGraph orientGraph = null;
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            Edge edge = this.getRelation(orientGraph, isRelatedToUUID, "IsRelatedTo", IsRelatedTo.class);
            edge.remove();
            orientGraph.commit();
            logger.info("{} {} with UUID {} successfully removed. Related {}s were detached.", new Object[]{"IsRelatedTo", "Relation", isRelatedToUUID, "Resource"});
        }
        catch (ResourceRegistryException rre) {
            logger.error("Unable to remove {} {} with UUID. Related {}s will not be detached.", new Object[]{"IsRelatedTo", "Relation", isRelatedToUUID, "Resource"});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw rre;
        }
        catch (Exception e) {
            logger.error("Unable to remove {} {} with UUID {}. Related {}s will not be detached.", new Object[]{"IsRelatedTo", "Relation", isRelatedToUUID, "Resource"});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
        return true;
    }

    private static String marshallResource(Vertex vertex) throws JSONException {
        JSONObject jsonObject = Utility.toJsonObject((OrientElement)((OrientVertex)vertex), (boolean)true);
        JSONArray consistsOfArray = new JSONArray();
        Iterable edges = vertex.getEdges(Direction.OUT, new String[0]);
        for (Edge edge : edges) {
            String edgeType = edge.getLabel();
            try {
                SchemaManagementImpl schemaManagement = new SchemaManagementImpl();
                schemaManagement.getTypeSchema(edgeType, "ConsistsOf");
                JSONObject jsonObjectEdge = Utility.toJsonObject((OrientElement)((OrientEdge)edge), (boolean)true);
                Vertex facetVertex = edge.getVertex(Direction.IN);
                jsonObjectEdge.put("target", (Object)Utility.toJsonObject((OrientElement)((OrientVertex)facetVertex), (boolean)true));
                consistsOfArray.put((Object)jsonObjectEdge);
            }
            catch (SchemaNotFoundException schemaNotFoundException) {}
        }
        jsonObject.put(EntityManagementImpl.lowerCaseFirstCharacter((String)"ConsistsOf"), (Object)consistsOfArray);
        return jsonObject.toString();
    }

    public String createResource(String resourceType, String jsonRepresentation) throws ResourceRegistryException {
        logger.debug("Trying to create {} using {}", (Object)resourceType, (Object)jsonRepresentation);
        OrientGraph orientGraph = null;
        try {
            JsonNode jsonNodeArray;
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            Vertex resource = this.createVertexEntity(orientGraph, resourceType, Resource.class, jsonRepresentation, true);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNode = mapper.readTree(jsonRepresentation);
            String property = EntityManagementImpl.lowerCaseFirstCharacter((String)"ConsistsOf");
            if (jsonNode.has(property)) {
                jsonNodeArray = jsonNode.get(property);
                this.createRelations(orientGraph, resource, jsonNodeArray, ConsistsOf.class);
            }
            if (jsonNode.has(property = EntityManagementImpl.lowerCaseFirstCharacter((String)"IsRelatedTo"))) {
                jsonNodeArray = jsonNode.get(property);
                this.createRelations(orientGraph, resource, jsonNodeArray, IsRelatedTo.class);
            }
            orientGraph.commit();
            String resourceString = EntityManagementImpl.marshallResource((Vertex)resource);
            logger.info("{} ({}) successfully created {}", new Object[]{"Resource", resourceType, resourceString});
            String string = resourceString;
            return string;
        }
        catch (ResourceRegistryException rre) {
            logger.error("Unable to create {} ({}) using {}", new Object[]{"Resource", resourceType, jsonRepresentation, rre});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw rre;
        }
        catch (Exception e) {
            logger.error("Unable to create {} ({}) using {}", new Object[]{"Resource", resourceType, jsonRepresentation, e});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    public String readResource(UUID uuid) throws ResourceNotFoundException {
        return this.readResource(uuid, "Resource");
    }

    public String readResource(UUID uuid, String resourceType) throws ResourceNotFoundException {
        logger.debug("Going to read {} ({}) with UUID {}", new Object[]{"Resource", resourceType, uuid});
        OrientGraph orientGraph = null;
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER);
            Vertex resource = this.getEntity(orientGraph, uuid, resourceType, Resource.class);
            logger.info("{} of type {} with UUID {} is {}", new Object[]{"Resource", resourceType, uuid, Utility.toJsonString((OrientElement)((OrientVertex)resource), (boolean)true)});
            String string = EntityManagementImpl.marshallResource((Vertex)resource);
            return string;
        }
        catch (ResourceNotFoundException rnfe) {
            logger.error("Unable to read {} ({}) with UUID {}", new Object[]{"Resource", resourceType, uuid, rnfe});
            throw rnfe;
        }
        catch (Exception e) {
            logger.error("Unable to read {} ({}) with UUID {}", new Object[]{"Resource", resourceType, uuid, e});
            throw new ResourceNotFoundException(e.getMessage());
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    public boolean deleteResource(UUID uuid) throws ResourceNotFoundException, ResourceRegistryException {
        logger.debug("Going to delete {} with UUID {}", (Object)"Resource", (Object)uuid);
        OrientGraph orientGraph = null;
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            Vertex resource = this.getEntity(orientGraph, uuid, null, Resource.class);
            resource.remove();
            orientGraph.commit();
            logger.info("{} with UUID {} was successfully deleted.", (Object)"Resource", (Object)uuid);
            boolean bl = true;
            return bl;
        }
        catch (ResourceNotFoundException rnfe) {
            logger.error("Unable to delete {} with UUID {}", new Object[]{"Resource", uuid, rnfe});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw rnfe;
        }
        catch (Exception e) {
            logger.error("Unable to delete {} with UUID {}", new Object[]{"Resource", uuid, e});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceNotFoundException(e.getMessage());
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    protected <E extends Entity> boolean addEntityToContext(Class<E> clz, UUID uuid) throws FacetNotFoundException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        logger.debug("Going to add {} with UUID {} to actual Context", (Object)clz.getSimpleName(), (Object)uuid);
        OrientGraph orientGraph = null;
        try {
            orientGraph = SecurityContextMapper.getSecurityContextFactory((UUID)SecurityContextMapper.ADMIN_SECURITY_CONTEXT_UUID, (SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER).getTx();
            Vertex vertex = this.getEntity(orientGraph, uuid, null, clz);
            UUID contextUUID = ContextUtility.addToActualContext((OrientGraph)orientGraph, (Vertex)vertex);
            if (Resource.class.isAssignableFrom(clz)) {
                Iterable facets = vertex.getVertices(Direction.OUT, new String[]{"ConsistsOf"});
                for (Vertex facet : facets) {
                    ContextUtility.addToActualContext((OrientGraph)orientGraph, (Vertex)facet);
                }
            }
            orientGraph.commit();
            logger.info("{} with UUID {} successfully added to actual Context with UUID {}", new Object[]{clz.getSimpleName(), uuid, contextUUID});
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error("Unable to add {} with UUID {} successfully added to actual Context", new Object[]{clz.getSimpleName(), uuid, e});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ContextException(e.getMessage());
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    public boolean addResourceToContext(UUID uuid) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addEntityToContext(Resource.class, uuid);
    }

    public boolean addFacetToContext(UUID uuid) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addEntityToContext(Facet.class, uuid);
    }
}

