/**
 * 
 */
package org.gcube.informationsystem.resourceregistry.resources;

import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

import org.gcube.informationsystem.resourceregistry.api.ContextManagement;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.resources.impl.ContextManagementImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 * @author Lucio Lelii (lucio.lelii@isti.cnr.it)	
 */
@Path("context")
public class ContextManager {
	
	/**
	 * Logger
	 */
	private static Logger logger = LoggerFactory.getLogger(ContextManager.class);

	protected ContextManagement contextManager = new ContextManagementImpl();	
	
	@PUT
	@Path("create/{parentContextId}")
	public String create(@PathParam("parentContextId") String parentContextId, @QueryParam("name") String name) throws Exception {
		logger.trace("requested create context with json : {} ", name);
		return contextManager.create(parentContextId, name);
	}

	@PUT
	@Path("rename/{contextId}")
	public String rename(@PathParam("contextId") String uuid, @QueryParam("name") String name)
			throws ContextNotFoundException, ContextException{
		logger.trace("requested rename context id {} with {} ", uuid, name);
		return contextManager.rename(uuid, name);
	}

	@PUT
	@Path("move/{contextId}")
	public String move(@PathParam("contextId") String uuid, @QueryParam("newParentId") String newParentId)
			throws ContextNotFoundException , ContextException{
		logger.trace("requested move context id {} with new parend id {} ", uuid, newParentId);
		return contextManager.move(newParentId, uuid);
	}
	
	@DELETE
	@Path("delete/{id}")
	public String delete(@PathParam("id") String uuid) throws ContextNotFoundException {
		logger.trace("requested delete context with id {} ",uuid);
		return uuid;
	}
	
}
