package org.gcube.informationsystem.resourceregistry.resources;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

import org.gcube.informationsystem.resourceregistry.AccessRESTPath;
import org.gcube.informationsystem.resourceregistry.api.EntityManagement;
import org.gcube.informationsystem.resourceregistry.api.Query;
import org.gcube.informationsystem.resourceregistry.api.SchemaManagement;
import org.gcube.informationsystem.resourceregistry.api.exceptions.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.FacetNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.resources.impl.EntityManagementImpl;
import org.gcube.informationsystem.resourceregistry.resources.impl.QueryImpl;
import org.gcube.informationsystem.resourceregistry.resources.impl.SchemaManagementImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 * @author Lucio Lelii (lucio.lelii@isti.cnr.it)
 */
@Path(AccessRESTPath.ACCESS_PATH_PART)
public class Access {

	private static Logger logger = LoggerFactory.getLogger(Access.class);

	protected Query queryManager = new QueryImpl();
	protected EntityManagement entityManager = new EntityManagementImpl();
	protected SchemaManagement schemaManager = new SchemaManagementImpl();

	@GET
	public String query(@QueryParam(AccessRESTPath.QUERY_PARAM) String query,
			@QueryParam(AccessRESTPath.FETCH_PLAN_PARAM) String fetchPlan)
			throws InvalidQueryException {
		logger.info("Requested query (fetch plan {}):\n{}", fetchPlan, query);
		return queryManager.execute(query, fetchPlan);
	}

	@GET @Path(AccessRESTPath.FACET_INSTANCE_PATH_PART + "/{" + AccessRESTPath.FACET_ID_PATH_PART + "}")
	public String getFacet(@PathParam(AccessRESTPath.FACET_ID_PATH_PART) String facetId)
			throws FacetNotFoundException, ResourceRegistryException {
		logger.info("Requested Facet with id {}", facetId);
		return entityManager.readFacet(facetId);
	}

	@GET @Path(AccessRESTPath.FACET_SCHEMA_PATH_PART + "/{" + AccessRESTPath.FACET_TYPE_PATH_PART + "}")
	public String getFacetSchema(@PathParam(AccessRESTPath.FACET_TYPE_PATH_PART) String facetType)
			throws SchemaNotFoundException {
		logger.info("Requested Facet Schema for type {}", facetType);
		return schemaManager.getFacetSchema(facetType);
	}

	@GET @Path(AccessRESTPath.RESOURCE_INSTANCE_PATH_PART + "/{" + AccessRESTPath.RESOURCE_ID_PATH_PART + "}")
	public String getResource(@PathParam(AccessRESTPath.RESOURCE_ID_PATH_PART) String resourceId)
			throws ResourceNotFoundException, ResourceRegistryException {
		logger.info("Requested Resource with id {}", resourceId);
		return entityManager.readResource(resourceId);
	}

	@GET @Path(AccessRESTPath.RESOURCE_SCHEMA_PATH_PART + "/{" + AccessRESTPath.RESOURCE_TYPE_PATH_PART + "}")
	public String getResourceSchema(@PathParam(AccessRESTPath.RESOURCE_TYPE_PATH_PART) String resourceType)
			throws SchemaNotFoundException {
		logger.info("Requested Resource Schema for type {}", resourceType);
		return schemaManager.getResourceSchema(resourceType);
	}
	
}