/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.schema;

import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.List;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPUtility;
import org.gcube.informationsystem.resourceregistry.api.utils.Utility;
import org.gcube.informationsystem.resourceregistry.schema.ResourceRegistrySchemaClient;
import org.gcube.informationsystem.types.TypeMapper;
import org.gcube.informationsystem.types.reference.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistrySchemaClientImpl
implements ResourceRegistrySchemaClient {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistrySchemaClientImpl.class);
    protected final String address;

    public ResourceRegistrySchemaClientImpl(String address) {
        this.address = address;
    }

    @Override
    public <E extends Element> Type create(Class<E> clz) throws SchemaException, ResourceRegistryException {
        try {
            String typeDefinition = TypeMapper.serializeType(clz);
            String res = this.create(typeDefinition);
            return TypeMapper.deserializeTypeDefinition((String)res);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String create(String typeDefinitition) throws ContextAlreadyPresentException, ResourceRegistryException {
        try {
            logger.trace("Going to create: {}", (Object)typeDefinitition);
            Type typeDefinitionObj = TypeMapper.deserializeTypeDefinition((String)typeDefinitition);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistrySchemaClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.header("Content-type", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("types");
            gxHTTPStringRequest.path(typeDefinitionObj.getName());
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.put(typeDefinitition);
            String c = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.trace("{} successfully created", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <E extends Element> boolean exist(Class<E> clz) throws ResourceRegistryException {
        try {
            String typeName = Utility.getTypeName(clz);
            return this.exist(typeName);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean exist(String typeName) throws ResourceRegistryException {
        try {
            logger.info("Going to get {} schema", (Object)typeName);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistrySchemaClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("types");
            gxHTTPStringRequest.path(typeName);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("polymorphic", Boolean.FALSE.toString());
            gxHTTPStringRequest.queryParams(parameters);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.head();
            HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <E extends Element> List<Type> read(Class<E> clz, Boolean polymorphic) throws SchemaNotFoundException, ResourceRegistryException {
        try {
            String typeName = Utility.getTypeName(clz);
            String res = this.read(typeName, polymorphic);
            return TypeMapper.deserializeTypeDefinitions((String)res);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String read(String typeName, Boolean polymorphic) throws ContextNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to get {} schema", (Object)typeName);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistrySchemaClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("types");
            gxHTTPStringRequest.path(typeName);
            HashMap<String, String> parameters = new HashMap<String, String>();
            if (polymorphic != null) {
                parameters.put("polymorphic", polymorphic.toString());
            }
            gxHTTPStringRequest.queryParams(parameters);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String json = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got schema for {} is {}", (Object)typeName, (Object)json);
            return json;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

