/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.resourceregistry.schema.ResourceRegistrySchemaClient;
import org.gcube.informationsystem.resourceregistry.schema.ResourceRegistrySchemaClientImpl;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistrySchemaClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistrySchemaClientFactory.class);
    protected static List<String> addresses = new ArrayList<String>();
    private static String FORCED_URL = null;
    private static String classFormat = "$resource/Profile/ServiceClass/text() eq '%1s'";
    private static String nameFormat = "$resource/Profile/ServiceName/text() eq '%1s'";
    private static String statusFormat = "$resource/Profile/DeploymentData/Status/text() eq 'ready'";
    private static String containsFormat = "$entry/@EntryName eq '%1s'";
    private static String serviceEndpointCategoryFormat = "$resource/Profile/Category/text() eq '%1s'";
    private static String serviceEndpointNameFormat = "$resource/Profile/Name/text() eq '%1s'";
    private static String serviceEndpointstatusFormat = "$resource/Profile/RunTime/Status/text() eq 'READY'";

    protected static void forceToURL(String url) {
        FORCED_URL = url;
    }

    public static String getCurrentContextFullName() {
        String token = SecurityTokenProvider.instance.get();
        AuthorizationEntry authorizationEntry = null;
        try {
            authorizationEntry = Constants.authorizationService().get(token);
        }
        catch (Exception e) {
            return ScopeProvider.instance.get();
        }
        return authorizationEntry.getContext();
    }

    private static SimpleQuery queryForService() {
        return ICFactory.queryFor(GCoreEndpoint.class).addCondition(String.format(classFormat, "InformationSystem")).addCondition(String.format(nameFormat, "resource-registry")).addCondition(String.format(statusFormat, new Object[0])).addVariable("$entry", "$resource/Profile/AccessPoint/RunningInstanceInterfaces/Endpoint").addCondition(String.format(containsFormat, "org.gcube.informationsystem.resourceregistry.ResourceInitializer")).setResult("$entry/text()");
    }

    private static SimpleQuery queryForProxy() {
        return ICFactory.queryFor(ServiceEndpoint.class).addCondition(String.format(serviceEndpointCategoryFormat, "InformationSystem")).addCondition(String.format(serviceEndpointNameFormat, "resource-registry")).addCondition(String.format(serviceEndpointstatusFormat, new Object[0])).addVariable("$entry", "$resource/Profile/AccessPoint/Interface/Endpoint").addCondition(String.format(containsFormat, "org.gcube.informationsystem.resourceregistry.ResourceInitializer")).setResult("$entry/text()");
    }

    protected static List<String> getAddresses() {
        List<String> addresses = new ArrayList();
        try {
            SimpleQuery proxyQuery = ResourceRegistrySchemaClientFactory.queryForProxy();
            addresses = ICFactory.client().submit((Query)proxyQuery);
            if (addresses == null || addresses.isEmpty()) {
                throw new Exception("No ResourceRegistry Proxy Found");
            }
        }
        catch (Exception e) {
            logger.debug("{}. Looking for RunningInstance.", (Object)e.getMessage());
            SimpleQuery serviceQuery = ResourceRegistrySchemaClientFactory.queryForService();
            addresses = ICFactory.client().submit((Query)serviceQuery);
        }
        return addresses;
    }

    public static ResourceRegistrySchemaClient create() {
        String address = null;
        if (FORCED_URL != null) {
            address = FORCED_URL;
        } else {
            if (addresses == null || addresses.isEmpty()) {
                addresses = ResourceRegistrySchemaClientFactory.getAddresses();
            }
            if (addresses == null || addresses.isEmpty()) {
                String error = String.format("No %s:%s found in the current context %s", "InformationSystem", "resource-registry", ResourceRegistrySchemaClientFactory.getCurrentContextFullName());
                throw new RuntimeException(error);
            }
            Random random = new Random();
            int index = random.nextInt(addresses.size());
            address = addresses.get(index);
        }
        return new ResourceRegistrySchemaClientImpl(address);
    }
}

