/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.contexts;

import org.gcube.informationsystem.resourceregistry.api.rest.ServiceInstance;
import org.gcube.informationsystem.resourceregistry.contexts.ResourceRegistryContextClient;
import org.gcube.informationsystem.resourceregistry.contexts.ResourceRegistryContextClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryContextClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryContextClientFactory.class);

    public static String getResourceRegistryURL() {
        String address = String.format("%s/%s", ServiceInstance.getServiceURL(), "resource-registry");
        return address;
    }

    public static String getResourceRegistryURL(String context) {
        String address = String.format("%s/%s", ServiceInstance.getServiceURL((String)context), "resource-registry");
        return address;
    }

    public static ResourceRegistryContextClient create() {
        String address = ResourceRegistryContextClientFactory.getResourceRegistryURL();
        logger.trace("The {} will be contacted at {}", (Object)"resource-registry", (Object)address);
        return new ResourceRegistryContextClientImpl(address);
    }

    public static ResourceRegistryContextClient create(String context) {
        String address = ResourceRegistryContextClientFactory.getResourceRegistryURL(context);
        logger.trace("The {} will be contacted at {}", (Object)"resource-registry", (Object)address);
        return new ResourceRegistryContextClientImpl(address);
    }
}

