/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.context;

import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.List;
import java.util.UUID;
import org.gcube.informationsystem.model.impl.embedded.HeaderImpl;
import org.gcube.informationsystem.model.impl.utils.ISMapper;
import org.gcube.informationsystem.model.reference.ISManageable;
import org.gcube.informationsystem.model.reference.embedded.Header;
import org.gcube.informationsystem.model.reference.entity.Context;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPCall;
import org.gcube.informationsystem.resourceregistry.context.ResourceRegistryContextClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryContextClientImpl
implements ResourceRegistryContextClient {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryContextClientImpl.class);
    public static final String PATH_SEPARATOR = "/";
    protected final String address;
    protected HTTPCall httpCall;

    public ResourceRegistryContextClientImpl(String address) {
        this.address = address;
    }

    private HTTPCall getHTTPCall() throws MalformedURLException {
        if (this.httpCall == null) {
            this.httpCall = new HTTPCall(this.address, ResourceRegistryContextClient.class.getSimpleName());
        }
        return this.httpCall;
    }

    protected String internalCreate(Context context) throws ContextAlreadyPresentException, ResourceRegistryException {
        try {
            Header header = context.getHeader();
            if (header == null) {
                header = new HeaderImpl(UUID.randomUUID());
                context.setHeader(header);
            }
            UUID uuid = context.getHeader().getUUID();
            String contextString = ISMapper.marshal((ISManageable)context);
            logger.trace("Going to create {}", (Object)contextString);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("contexts");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = this.getHTTPCall();
            String c = (String)httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.PUT, contextString);
            logger.trace("{} successfully created", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Context create(Context context) throws ContextAlreadyPresentException, ResourceRegistryException {
        try {
            String res = this.internalCreate(context);
            return (Context)ISMapper.unmarshal(Context.class, (String)res);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String create(String context) throws ContextAlreadyPresentException, ResourceRegistryException {
        try {
            Context c = (Context)ISMapper.unmarshal(Context.class, (String)context);
            return this.internalCreate(c);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Context read(Context context) throws ContextNotFoundException, ResourceRegistryException {
        return this.read(context.getHeader().getUUID());
    }

    @Override
    public Context read(UUID uuid) throws ContextNotFoundException, ResourceRegistryException {
        try {
            String res = this.read(uuid.toString());
            return (Context)ISMapper.unmarshal(Context.class, (String)res);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String read(String uuid) throws ContextNotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to read {} with UUID {}", (Object)"Context", (Object)uuid);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("contexts");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid);
            HTTPCall httpCall = this.getHTTPCall();
            String c = (String)httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.GET);
            logger.debug("Got {} is {}", (Object)"Context", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String internalUpdate(Context context) throws ResourceRegistryException {
        try {
            String contextString = ISMapper.marshal((ISManageable)context);
            logger.trace("Going to update {}", (Object)contextString);
            UUID uuid = context.getHeader().getUUID();
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("contexts");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = this.getHTTPCall();
            String c = (String)httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.PUT, contextString);
            logger.trace("{} successfully updated", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Context update(Context context) throws ResourceRegistryException {
        try {
            String res = this.internalUpdate(context);
            return (Context)ISMapper.unmarshal(Context.class, (String)res);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String update(String context) throws ResourceRegistryException {
        try {
            Context c = (Context)ISMapper.unmarshal(Context.class, (String)context);
            return this.internalUpdate(c);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean delete(Context context) throws ContextNotFoundException, ResourceRegistryException {
        return this.delete(context.getHeader().getUUID());
    }

    @Override
    public boolean delete(UUID uuid) throws ContextNotFoundException, ResourceRegistryException {
        return this.delete(uuid.toString());
    }

    @Override
    public boolean delete(String uuid) throws ContextNotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to delete {} with UUID {}", (Object)"Context", (Object)uuid);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("contexts");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid);
            HTTPCall httpCall = this.getHTTPCall();
            boolean deleted = (Boolean)httpCall.call(Boolean.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.DELETE);
            logger.info("{} with UUID {} {}", new Object[]{"Context", uuid, deleted ? " successfully deleted" : "was NOT deleted"});
            return deleted;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Context> all() throws ResourceRegistryException {
        try {
            logger.trace("Going to read {} with UUID {}", (Object)"Context");
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("contexts");
            HTTPCall httpCall = this.getHTTPCall();
            String all = (String)httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.GET);
            logger.debug("Got contexts are {}", (Object)"Context", (Object)all);
            return ISMapper.unmarshalList(Context.class, (String)all);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

