/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.client;

import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.databind.JavaType;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.type.CollectionType;
import org.gcube.common.context.ContextUtility;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.common.http.GXHTTPUtility;
import org.gcube.informationsystem.base.reference.Direction;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.contexts.reference.entities.Context;
import org.gcube.informationsystem.model.knowledge.ModelKnowledge;
import org.gcube.informationsystem.model.knowledge.TypesDiscoverer;
import org.gcube.informationsystem.model.reference.ERElement;
import org.gcube.informationsystem.model.reference.ModelElement;
import org.gcube.informationsystem.model.reference.entities.Entity;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.model.reference.relations.IsRelatedTo;
import org.gcube.informationsystem.model.reference.relations.Relation;
import org.gcube.informationsystem.queries.templates.reference.entities.QueryTemplate;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCache;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCacheRenewal;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.queries.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.queries.templates.QueryTemplateNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.request.BaseRequestInfo;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPUtility;
import org.gcube.informationsystem.resourceregistry.client.RRCTypesDiscoverer;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.serialization.ElementMapper;
import org.gcube.informationsystem.tree.Node;
import org.gcube.informationsystem.types.TypeMapper;
import org.gcube.informationsystem.types.knowledge.TypeInformation;
import org.gcube.informationsystem.types.knowledge.TypesKnowledge;
import org.gcube.informationsystem.types.reference.Type;
import org.gcube.informationsystem.utils.TypeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryClientImpl
extends BaseRequestInfo
implements ResourceRegistryClient {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryClientImpl.class);
    private static final String ACCEPT_HTTP_HEADER_KEY = "Accept";
    private static final String CONTENT_TYPE_HTTP_HEADER_KEY = "Content-Type";
    protected final String address;
    protected Map<String, String> headers;
    protected ContextCache contextCache;
    protected TypesKnowledge typesKnowledge;
    protected ContextCacheRenewal contextCacheRenewal = new ContextCacheRenewal(){

        public List<Context> renew() throws ResourceRegistryException {
            return ResourceRegistryClientImpl.this.getAllContextFromServer(true, 0, BaseRequestInfo.UNBOUNDED_LIMIT);
        }
    };

    @Override
    @Deprecated
    public boolean isIncludeContextsInHeader() {
        return this.includeContexts();
    }

    @Override
    @Deprecated
    public void setIncludeContextsInHeader(boolean includeContexts) {
        this.setIncludeContexts(includeContexts);
    }

    private void addOptionalQueryParameters(Map<String, String> queryParams) throws UnsupportedEncodingException {
        this.addHierarchicalMode(queryParams);
        this.addIncludeContexts(queryParams);
        this.addIncludeMeta(queryParams);
        this.addIncludeAllMeta(queryParams);
    }

    private GXHTTPStringRequest includeAdditionalQueryParameters(GXHTTPStringRequest gxHTTPStringRequest) throws UnsupportedEncodingException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        return this.includeAdditionalQueryParameters(gxHTTPStringRequest, queryParams);
    }

    private GXHTTPStringRequest includeAdditionalQueryParameters(GXHTTPStringRequest gxHTTPStringRequest, Map<String, String> queryParams) throws UnsupportedEncodingException {
        if (queryParams == null) {
            queryParams = new HashMap<String, String>();
        }
        this.addOptionalQueryParameters(queryParams);
        return gxHTTPStringRequest.queryParams(queryParams);
    }

    private void addHierarchicalMode(Map<String, String> queryParams) throws UnsupportedEncodingException {
        if (this.hierarchicalMode) {
            queryParams.put("hierarchical", Boolean.toString(this.hierarchicalMode));
        }
    }

    private void addIncludeContexts(Map<String, String> queryParams) throws UnsupportedEncodingException {
        if (this.includeContexts) {
            queryParams.put("includeContexts", Boolean.toString(this.includeContexts));
        }
    }

    private void addIncludeMeta(Map<String, String> queryParams) throws UnsupportedEncodingException {
        this.addIncludeMeta(queryParams, this.includeMeta);
    }

    private void addIncludeMeta(Map<String, String> queryParams, boolean includeMeta) throws UnsupportedEncodingException {
        if (includeMeta) {
            queryParams.put("includeMeta", Boolean.toString(includeMeta));
        }
    }

    private void addIncludeAllMeta(Map<String, String> queryParams) throws UnsupportedEncodingException {
        if (this.allMeta) {
            queryParams.put("allMeta", Boolean.toString(this.allMeta));
        }
    }

    private void addOffset(Map<String, String> queryParams) throws UnsupportedEncodingException {
        this.addOffset(queryParams, this.offset);
    }

    private void addOffset(Map<String, String> queryParams, Integer offset) throws UnsupportedEncodingException {
        if (offset != null) {
            queryParams.put("offset", offset.toString());
        }
    }

    private void addLimit(Map<String, String> queryParams) throws UnsupportedEncodingException {
        this.addLimit(queryParams, this.limit);
    }

    private void addLimit(Map<String, String> queryParams, Integer limit) throws UnsupportedEncodingException {
        if (limit != null) {
            queryParams.put("limit", limit.toString());
        }
    }

    @Override
    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    protected GXHTTPStringRequest getGXHTTPStringRequest() {
        GXHTTPStringRequest gxHTTPStringRequest = GXHTTPUtility.getGXHTTPStringRequest((String)this.address);
        gxHTTPStringRequest.from(this.getClass().getSimpleName());
        for (String name : this.headers.keySet()) {
            gxHTTPStringRequest.header(name, this.headers.get(name));
        }
        return gxHTTPStringRequest;
    }

    public ResourceRegistryClientImpl(String address) {
        this(address, true, true);
    }

    public ResourceRegistryClientImpl(String address, boolean sharedContextCache, boolean sharedModelKnowledge) {
        this.address = address;
        this.headers = new HashMap<String, String>();
        this.contextCache = sharedContextCache ? ContextCache.getInstance() : new ContextCache();
        this.contextCache.setContextCacheRenewal(this.contextCacheRenewal);
        this.typesKnowledge = sharedModelKnowledge ? TypesKnowledge.getInstance() : new TypesKnowledge();
        this.typesKnowledge.setTypesDiscoverer((TypesDiscoverer)new RRCTypesDiscoverer(this));
    }

    public List<Context> getAllContextFromServer() throws ResourceRegistryException {
        return this.getAllContextFromServer(this.includeMeta, this.offset, this.limit);
    }

    protected List<Context> getAllContextFromServer(boolean includeMeta, Integer offset, Integer limit) throws ResourceRegistryException {
        try {
            logger.info("Going to read all {}s", (Object)"Context");
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("contexts");
            HashMap<String, String> parameters = new HashMap<String, String>();
            this.addIncludeMeta(parameters, includeMeta);
            this.addOffset(parameters, offset);
            this.addLimit(parameters, limit);
            gxHTTPStringRequest.queryParams(parameters);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String ret = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got Contexts are {}", (Object)ret);
            return ElementMapper.unmarshalList(Context.class, (String)ret);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Context> getAllContext() throws ResourceRegistryException {
        return this.contextCache.getContexts();
    }

    @Override
    public ContextCache getContextCache() {
        return this.contextCache;
    }

    @Override
    public ModelKnowledge<Type, TypeInformation> getModelKnowledge() {
        return this.typesKnowledge.getModelKnowledge();
    }

    @Override
    public void renewModelKnowledge() {
        this.typesKnowledge.renew();
    }

    public Context getContextFromServer(UUID uuid) throws ContextNotFoundException, ResourceRegistryException {
        return this.getContextFromServer(uuid.toString());
    }

    protected Context getContextFromServer(String uuid) throws ContextNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to get current {} ", (Object)"Context");
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("contexts");
            gxHTTPStringRequest.path(uuid);
            HashMap<String, String> parameters = new HashMap<String, String>();
            this.addIncludeMeta(parameters);
            gxHTTPStringRequest.queryParams(parameters);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            Context context = (Context)HTTPUtility.getResponse(Context.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got Context is {}", (Object)ElementMapper.marshal((Element)context));
            return context;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean existContext(String uuid) throws ResourceRegistryException {
        return this.existContext(UUID.fromString(uuid));
    }

    @Override
    public boolean existContext(UUID uuid) throws ResourceRegistryException {
        try {
            this.getContext(uuid);
            return true;
        }
        catch (ContextNotFoundException e) {
            return false;
        }
    }

    @Override
    public Context getContext(String uuid) throws ContextNotFoundException, ResourceRegistryException {
        return this.getContext(UUID.fromString(uuid));
    }

    @Override
    public Context getContext(UUID uuid) throws ContextNotFoundException, ResourceRegistryException {
        Context context = this.contextCache.getContextByUUID(uuid);
        if (context == null) {
            context = this.getContextFromServer("CURRENT_CONTEXT");
            this.contextCache.cleanCache();
            this.contextCache.refreshContextsIfNeeded();
            Context c = this.contextCache.getContextByUUID(context.getID());
            if (c != null) {
                context = c;
            } else {
                logger.error("Context with UUID {} is {}. It is possibile to get it from the server but not from the cache. This is very strange and should not occur.", (Object)uuid, (Object)context);
            }
        }
        return context;
    }

    @Override
    public Context getCurrentContext() throws ContextNotFoundException, ResourceRegistryException {
        String contextFullName = ContextUtility.getCurrentContextFullName();
        UUID uuid = this.contextCache.getUUIDByFullName(contextFullName);
        Context context = null;
        if (uuid == null) {
            context = this.getContextFromServer("CURRENT_CONTEXT");
            this.contextCache.cleanCache();
            this.contextCache.refreshContextsIfNeeded();
            Context c = this.contextCache.getContextByUUID(context.getID());
            if (c != null) {
                context = c;
            } else {
                logger.error("Current Context is {}. It is possibile to get it from the server but not from the cache. This is very strange and should not occur.", (Object)contextFullName);
            }
        } else {
            context = this.contextCache.getContextByUUID(uuid);
        }
        return context;
    }

    @Override
    public <ME extends ModelElement> boolean existType(Class<ME> clazz) throws ResourceRegistryException {
        return this.existType(TypeUtility.getTypeName(clazz));
    }

    @Override
    public boolean existType(String typeName) throws ResourceRegistryException {
        try {
            return this.typesKnowledge.getModelKnowledge().getTypeByName(typeName) != null;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public boolean existTypeFromServer(String typeName) throws ResourceRegistryException {
        try {
            logger.info("Going to get {} schema", (Object)typeName);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("types");
            gxHTTPStringRequest.path(typeName);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("polymorphic", Boolean.FALSE.toString());
            gxHTTPStringRequest.queryParams(parameters);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.head();
            HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public <ERElem extends ERElement> List<Type> getTypeFromTypesKnowledge(String typeName, Boolean polymorphic) throws SchemaNotFoundException, ResourceRegistryException {
        return this.getTypeFromTypesKnowledge(typeName, polymorphic, -1);
    }

    public <ERElem extends ERElement> List<Type> getTypeFromTypesKnowledge(String typeName, int level) throws SchemaNotFoundException, ResourceRegistryException {
        return this.getTypeFromTypesKnowledge(typeName, true, level);
    }

    protected List<Type> addChildren(Node<Type> node, List<Type> types, int currentLevel, int maxLevel) {
        if (maxLevel >= 0 && maxLevel <= currentLevel) {
            return types;
        }
        Set children = node.getChildrenNodes();
        if (children != null && children.size() > 0) {
            for (Node child : children) {
                types.add((Type)child.getNodeElement());
                types = this.addChildren((Node<Type>)child, types, ++currentLevel, maxLevel);
            }
        }
        return types;
    }

    public <ERElem extends ERElement> List<Type> getTypeFromTypesKnowledge(String typeName, Boolean polymorphic, int level) throws SchemaNotFoundException, ResourceRegistryException {
        Node<Type> node = this.getTypeTreeNode(typeName);
        ArrayList<Type> types = new ArrayList<Type>();
        types.add((Type)node.getNodeElement());
        if (polymorphic.booleanValue()) {
            this.addChildren(node, types, 0, level);
        }
        return types;
    }

    @Override
    public String getType(String typeName, Boolean polymorphic) throws SchemaNotFoundException, ResourceRegistryException {
        try {
            List<Type> types = this.getTypeFromTypesKnowledge(typeName, polymorphic);
            return TypeMapper.serializeTypeDefinitions(types);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    @Override
    public String getType(String typeName, int level) throws SchemaNotFoundException, ResourceRegistryException {
        try {
            List<Type> types = this.getTypeFromTypesKnowledge(typeName, level);
            return TypeMapper.serializeTypeDefinitions(types);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    @Override
    public <ME extends ModelElement> List<Type> getType(Class<ME> clazz, Boolean polymorphic) throws SchemaNotFoundException, ResourceRegistryException {
        try {
            String typeName = TypeUtility.getTypeName(clazz);
            return this.getTypeFromTypesKnowledge(typeName, polymorphic);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    @Override
    public <ME extends ModelElement> List<Type> getType(Class<ME> clazz, int level) throws SchemaNotFoundException, ResourceRegistryException {
        try {
            String typeName = TypeUtility.getTypeName(clazz);
            return this.getTypeFromTypesKnowledge(typeName, level);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    @Override
    public Node<Type> getTypeTreeNode(String typeName) throws SchemaNotFoundException, ResourceRegistryException {
        try {
            Node node = null;
            try {
                node = this.typesKnowledge.getModelKnowledge().getNodeByName(typeName);
            }
            catch (RuntimeException e) {
                throw new SchemaNotFoundException((Throwable)e);
            }
            return node;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    @Override
    public <ME extends ModelElement> Node<Type> getTypeTreeNode(Class<ME> clazz) throws SchemaNotFoundException, ResourceRegistryException {
        try {
            String typeName = TypeUtility.getTypeName(clazz);
            return this.getTypeTreeNode(typeName);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public <ME extends ModelElement> List<Type> getTypeFromServer(Class<ME> clazz, Boolean polymorphic) throws SchemaNotFoundException, ResourceRegistryException {
        try {
            String json = this.getTypeFromServer(TypeUtility.getTypeName(clazz), polymorphic);
            return TypeMapper.deserializeTypeDefinitions((String)json);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public String getTypeFromServer(String typeName, Boolean polymorphic) throws SchemaNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to get {} schema", (Object)typeName);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("types");
            gxHTTPStringRequest.path(typeName);
            HashMap<String, String> parameters = new HashMap<String, String>();
            this.addIncludeMeta(parameters);
            parameters.put("polymorphic", polymorphic.toString());
            gxHTTPStringRequest.queryParams(parameters);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String json = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got schema for {} is {}", (Object)typeName, (Object)json);
            return json;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <ERElem extends ERElement> List<ERElem> getInstances(Class<ERElem> clazz, Boolean polymorphic) throws ResourceRegistryException {
        String type = TypeUtility.getTypeName(clazz);
        String ret = this.getInstances(type, polymorphic);
        try {
            return ElementMapper.unmarshalList(ERElement.class, (String)ret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getInstances(String type, Boolean polymorphic) throws ResourceRegistryException {
        try {
            logger.info("Going to get all instances of {} ", (Object)type);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("instances");
            gxHTTPStringRequest.path(type);
            HashMap<String, String> parameters = new HashMap<String, String>();
            this.addOffset(parameters);
            this.addLimit(parameters);
            parameters.put("polymorphic", polymorphic.toString());
            this.includeAdditionalQueryParameters(gxHTTPStringRequest, parameters);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String ret = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got instances of {} are {}", (Object)type, (Object)ret);
            return ret;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <ERElem extends ERElement> boolean existInstance(Class<ERElem> clazz, UUID uuid) throws AvailableInAnotherContextException, ResourceRegistryException {
        String type = TypeUtility.getTypeName(clazz);
        return this.existInstance(type, uuid);
    }

    @Override
    public boolean existInstance(String type, UUID uuid) throws AvailableInAnotherContextException, ResourceRegistryException {
        try {
            logger.info("Going to check if {} with UUID {} exists", (Object)type, (Object)uuid);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("instances");
            gxHTTPStringRequest.path(type);
            gxHTTPStringRequest.path(uuid.toString());
            HashMap<String, String> queryParams = new HashMap<String, String>();
            this.addHierarchicalMode(queryParams);
            gxHTTPStringRequest.queryParams(queryParams);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.head();
            HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("{} with UUID {} exists", (Object)type, (Object)uuid);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <ERElem extends ERElement> ERElem getInstance(Class<ERElem> clazz, UUID uuid) throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        String type = TypeUtility.getTypeName(clazz);
        String ret = this.getInstance(type, uuid);
        try {
            return (ERElem)((ERElement)ElementMapper.unmarshal(clazz, (String)ret));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getInstance(String type, UUID uuid) throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        try {
            logger.info("Going to get {} with UUID {}", (Object)type, (Object)uuid);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("instances");
            gxHTTPStringRequest.path(type);
            gxHTTPStringRequest.path(uuid.toString());
            this.includeAdditionalQueryParameters(gxHTTPStringRequest);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String ret = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got {} with UUID {} is {}", new Object[]{type, uuid, ret});
            return ret;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String rawQuery(String query) throws InvalidQueryException, ResourceRegistryException {
        return this.rawQuery(query, false);
    }

    @Override
    public String rawQuery(String query, boolean raw) throws InvalidQueryException, ResourceRegistryException {
        try {
            logger.info("Going to query. {}", (Object)query);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("query");
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("q", query);
            parameters.put("raw", Boolean.toString(raw));
            if (raw) {
                this.addHierarchicalMode(parameters);
                gxHTTPStringRequest.queryParams(parameters);
            } else {
                this.includeAdditionalQueryParameters(gxHTTPStringRequest, parameters);
            }
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String ret = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.trace("Query result is {}", (Object)ret);
            return ret;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getRelated(String entityType, String relationType, String referenceEntityType, UUID referenceEntity, Direction direction, Boolean polymorphic, Map<String, String> facetConstraints) throws ResourceRegistryException {
        try {
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("query");
            gxHTTPStringRequest.path(entityType);
            gxHTTPStringRequest.path(relationType);
            gxHTTPStringRequest.path(referenceEntityType);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("_direction", direction.name());
            parameters.put("_polymorphic", polymorphic.toString());
            if (referenceEntity == null) {
                if (facetConstraints != null && facetConstraints.size() > 0) {
                    logger.info("Going to get {} linked by a {} Relation to a {} having {}", new Object[]{entityType, relationType, referenceEntityType, facetConstraints});
                    parameters.putAll(facetConstraints);
                } else {
                    logger.info("Going to get {} linked by a {} Relation to a {}", new Object[]{entityType, relationType, referenceEntityType});
                }
            } else {
                logger.info("Going to get {} linked by {} to {} with UUID {}", new Object[]{entityType, relationType, referenceEntityType, referenceEntity});
                parameters.put("_reference", referenceEntity.toString());
            }
            this.includeAdditionalQueryParameters(gxHTTPStringRequest, parameters);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String json = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            if (referenceEntity == null) {
                logger.info("{} linked by {} to/from {} having {} are {}", new Object[]{entityType, relationType, referenceEntityType, facetConstraints, json});
            } else {
                logger.info("{} linked by {} to/from {} with UUID {} are", new Object[]{entityType, relationType, referenceEntityType, referenceEntity, json});
            }
            return json;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <R extends Resource, C extends ConsistsOf<?, ?>, F extends Facet> List<R> getResourcesFromReferenceFacet(Class<R> resourceClass, Class<C> consistsOfClass, F referenceFacet, boolean polymorphic) throws ResourceRegistryException {
        UUID referenceFacetUUID = referenceFacet.getID();
        Class<?> facetClass = referenceFacet.getClass();
        return this.getResourcesFromReferenceFacet(resourceClass, consistsOfClass, facetClass, referenceFacetUUID, polymorphic);
    }

    @Override
    public <R extends Resource, C extends ConsistsOf<?, ?>, F extends Facet> List<R> getResourcesFromReferenceFacet(Class<R> resourceClass, Class<C> consistsOfClass, Class<F> facetClass, UUID referenceFacetUUID, boolean polymorphic) throws ResourceRegistryException {
        String resourceType = TypeUtility.getTypeName(resourceClass);
        String consistsOfType = TypeUtility.getTypeName(consistsOfClass);
        String facetType = TypeUtility.getTypeName(facetClass);
        String ret = this.getResourcesFromReferenceFacet(resourceType, consistsOfType, facetType, referenceFacetUUID, polymorphic);
        try {
            return ElementMapper.unmarshalList(Resource.class, (String)ret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getResourcesFromReferenceFacet(String resourceType, String consistsOfType, String facetType, UUID facetUUID, boolean polymorphic) throws ResourceRegistryException {
        return this.getRelated(resourceType, consistsOfType, facetType, facetUUID, Direction.OUT, polymorphic);
    }

    @Override
    public <R extends Resource, C extends ConsistsOf<?, ?>, F extends Facet> List<R> getFilteredResources(Class<R> resourceClass, Class<C> consistsOfClass, Class<F> facetClass, boolean polymorphic, Map<String, String> facetConstraints) throws ResourceRegistryException {
        String resourceType = TypeUtility.getTypeName(resourceClass);
        String consistsOfType = TypeUtility.getTypeName(consistsOfClass);
        String facetType = TypeUtility.getTypeName(facetClass);
        String ret = this.getFilteredResources(resourceType, consistsOfType, facetType, polymorphic, facetConstraints);
        try {
            return ElementMapper.unmarshalList(Resource.class, (String)ret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getFilteredResources(String resourceType, String consistsOfType, String facetType, boolean polymorphic, Map<String, String> facetConstraints) throws ResourceRegistryException {
        return this.getRelated(resourceType, consistsOfType, facetType, Direction.OUT, polymorphic, facetConstraints);
    }

    @Override
    public <R extends Resource, I extends IsRelatedTo<?, ?>, RR extends Resource> List<R> getRelatedResourcesFromReferenceResource(Class<R> resourceClass, Class<I> isRelatedToClass, RR referenceResource, Direction direction, boolean polymorphic) throws ResourceRegistryException {
        UUID referenceResourceUUID = referenceResource.getID();
        Class<?> referenceResourceClass = referenceResource.getClass();
        return this.getRelatedResourcesFromReferenceResource(resourceClass, isRelatedToClass, referenceResourceClass, referenceResourceUUID, direction, polymorphic);
    }

    @Override
    public <R extends Resource, I extends IsRelatedTo<?, ?>, RR extends Resource> List<R> getRelatedResourcesFromReferenceResource(Class<R> resourceClass, Class<I> isRelatedToClass, Class<RR> referenceResourceClass, UUID referenceResourceUUID, Direction direction, boolean polymorphic) throws ResourceRegistryException {
        String resourceType = TypeUtility.getTypeName(resourceClass);
        String isRelatedToType = TypeUtility.getTypeName(isRelatedToClass);
        String referenceResourceType = TypeUtility.getTypeName(referenceResourceClass);
        String ret = this.getRelatedResourcesFromReferenceResource(resourceType, isRelatedToType, referenceResourceType, referenceResourceUUID, direction, polymorphic);
        try {
            return ElementMapper.unmarshalList(Resource.class, (String)ret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getRelatedResourcesFromReferenceResource(String resourceType, String isRelatedToType, String referenceResourceType, UUID referenceResourceUUID, Direction direction, boolean polymorphic) throws ResourceRegistryException {
        return this.getRelated(resourceType, isRelatedToType, referenceResourceType, referenceResourceUUID, direction, polymorphic);
    }

    @Override
    public <R extends Resource, I extends IsRelatedTo<?, ?>, RR extends Resource> List<R> getRelatedResources(Class<R> resourceClass, Class<I> isRelatedToClass, Class<RR> referenceResourceClass, Direction direction, boolean polymorphic) throws ResourceRegistryException {
        String resourceType = TypeUtility.getTypeName(resourceClass);
        String isRelatedToType = TypeUtility.getTypeName(isRelatedToClass);
        String referenceResourceType = TypeUtility.getTypeName(referenceResourceClass);
        String ret = this.getRelatedResources(resourceType, isRelatedToType, referenceResourceType, direction, polymorphic);
        try {
            return ElementMapper.unmarshalList(Resource.class, (String)ret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getRelatedResources(String resourceType, String isRelatedToType, String referenceResourceType, Direction direction, boolean polymorphic) throws ResourceRegistryException {
        return this.getRelated(resourceType, isRelatedToType, referenceResourceType, direction, polymorphic, null);
    }

    protected <E extends Entity, R extends Relation<?, ?>, RE extends Entity> List<E> getRelated(Class<E> entityClass, Class<R> relationClass, Class<RE> referenceEntityClass, Direction direction, boolean polymorphic, Map<String, String> map) throws ResourceRegistryException {
        String entityType = TypeUtility.getTypeName(entityClass);
        String relationType = TypeUtility.getTypeName(relationClass);
        String referenceEntityType = TypeUtility.getTypeName(referenceEntityClass);
        String ret = this.getRelated(entityType, relationType, referenceEntityType, direction, polymorphic, map);
        try {
            return ElementMapper.unmarshalList(Resource.class, (String)ret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getRelated(String entityType, String relationType, String referenceEntityType, Direction direction, boolean polymorphic, Map<String, String> facetConstraints) throws ResourceRegistryException {
        return this.getRelated(entityType, relationType, referenceEntityType, null, direction, polymorphic, facetConstraints);
    }

    protected <E extends Entity, R extends Relation<?, ?>, RE extends Entity> List<E> getRelated(Class<E> entityClass, Class<R> relationClass, Class<RE> referenceEntityClass, RE referenceEntity, Direction direction, boolean polymorphic) throws ResourceRegistryException {
        UUID referenceEntityUUID = referenceEntity.getID();
        return this.getRelated(entityClass, relationClass, referenceEntityClass, referenceEntityUUID, direction, polymorphic);
    }

    protected <E extends Entity, R extends Relation<?, ?>, RE extends Entity> List<E> getRelated(Class<E> entityClass, Class<R> relationClass, Class<RE> referenceEntityClass, UUID referenceEntityUUID, Direction direction, boolean polymorphic) throws ResourceRegistryException {
        String entityType = TypeUtility.getTypeName(entityClass);
        String relationType = TypeUtility.getTypeName(relationClass);
        String referenceEntityType = TypeUtility.getTypeName(referenceEntityClass);
        String ret = this.getRelated(entityType, relationType, referenceEntityType, referenceEntityUUID, direction, polymorphic);
        try {
            return ElementMapper.unmarshalList(Resource.class, (String)ret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getRelated(String entityType, String relationType, String referenceEntityType, UUID referenceEntity, Direction direction, boolean polymorphic) throws ResourceRegistryException {
        return this.getRelated(entityType, relationType, referenceEntityType, referenceEntity, direction, polymorphic, null);
    }

    @Override
    public <ERElem extends ERElement> Map<UUID, String> getInstanceContexts(Class<ERElem> clazz, UUID uuid) throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        String typeName = TypeUtility.getTypeName(clazz);
        return this.getInstanceContexts(typeName, uuid);
    }

    @Override
    public Map<UUID, String> getInstanceContexts(String type, UUID uuid) throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        try {
            logger.trace("Going to get contexts of {} with UUID {}", (Object)type, (Object)uuid);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("instances");
            gxHTTPStringRequest.path(type);
            gxHTTPStringRequest.path(uuid.toString());
            gxHTTPStringRequest.path("contexts");
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String objectNode = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.info("Contexts of {} with UUID {} are {}", new Object[]{type, uuid, objectNode});
            Map contexts = org.gcube.informationsystem.resourceregistry.api.contexts.ContextUtility.getContextMap((String)objectNode);
            return contexts;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<QueryTemplate> getAllQueryTemplates() throws ResourceRegistryException {
        try {
            logger.trace("Going to list {}s", (Object)"QueryTemplate");
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("query-templates");
            HashMap<String, String> parameters = new HashMap<String, String>();
            this.addIncludeMeta(parameters);
            gxHTTPStringRequest.queryParams(parameters);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String all = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got {}s are {}", (Object)"QueryTemplate", (Object)all);
            CollectionType type = ElementMapper.getObjectMapper().getTypeFactory().constructCollectionType(ArrayList.class, QueryTemplate.class);
            return (List)ElementMapper.getObjectMapper().readValue(all, (JavaType)type);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean existQueryTemplate(QueryTemplate queryTemplate) throws QueryTemplateNotFoundException, ResourceRegistryException {
        return this.existQueryTemplate(queryTemplate.getName());
    }

    @Override
    public boolean existQueryTemplate(String queryTemplateName) throws QueryTemplateNotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to read {} with name {}", (Object)"QueryTemplate", (Object)queryTemplateName);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("query-templates");
            gxHTTPStringRequest.path(queryTemplateName);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.head();
            HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public QueryTemplate readQueryTemplate(QueryTemplate queryTemplate) throws QueryTemplateNotFoundException, ResourceRegistryException {
        return this.readQueryTemplate(queryTemplate.getName());
    }

    @Override
    public QueryTemplate readQueryTemplate(String queryTemplateName) throws QueryTemplateNotFoundException, ResourceRegistryException {
        try {
            String queryTemplate = this.readQueryTemplateAsString(queryTemplateName);
            return (QueryTemplate)ElementMapper.unmarshal(QueryTemplate.class, (String)queryTemplate);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String readQueryTemplateAsString(String queryTemplateName) throws QueryTemplateNotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to read {} with name {}", (Object)"QueryTemplate", (Object)queryTemplateName);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("query-templates");
            gxHTTPStringRequest.path(queryTemplateName);
            HashMap<String, String> parameters = new HashMap<String, String>();
            this.addIncludeMeta(parameters);
            gxHTTPStringRequest.queryParams(parameters);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String c = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got {} is {}", (Object)"QueryTemplate", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String runQueryTemplateGetString(String name) throws QueryTemplateNotFoundException, ResourceRegistryException {
        return this.runQueryTemplate(name, "");
    }

    @Override
    public String runQueryTemplate(String name) throws QueryTemplateNotFoundException, ResourceRegistryException {
        try {
            String ret = this.runQueryTemplateGetString(name);
            return ret;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String runQueryTemplate(QueryTemplate queryTemplate) throws QueryTemplateNotFoundException, ResourceRegistryException {
        return this.runQueryTemplate(queryTemplate.getName());
    }

    @Override
    public String runQueryTemplate(String name, String params) throws QueryTemplateNotFoundException, ResourceRegistryException {
        try {
            if (params == null || params.compareTo("") == 0) {
                logger.trace("Going to run {} using default parameters", (Object)"QueryTemplate");
                params = null;
            } else {
                logger.trace("Going to run {} with the following parameters {}", (Object)"QueryTemplate", (Object)params);
            }
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.header(CONTENT_TYPE_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("query-templates");
            gxHTTPStringRequest.path(name);
            this.includeAdditionalQueryParameters(gxHTTPStringRequest);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.post(params);
            String c = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.trace("The result of the query is {}", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String runQueryTemplate(String name, JsonNode jsonNode) throws QueryTemplateNotFoundException, ResourceRegistryException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String ret = this.runQueryTemplate(name, objectMapper.writeValueAsString((Object)jsonNode));
            return ret;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String runQueryTemplate(QueryTemplate queryTemplate, JsonNode jsonNode) throws QueryTemplateNotFoundException, ResourceRegistryException {
        return this.runQueryTemplate(queryTemplate.getName(), jsonNode);
    }

    @Override
    public String jsonQuery(String query) throws InvalidQueryException, ResourceRegistryException {
        try {
            logger.trace("Going to run the following JSON Query {}", (Object)query);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.header(CONTENT_TYPE_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("query");
            this.includeAdditionalQueryParameters(gxHTTPStringRequest);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.post(query);
            String c = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.trace("The result of the query is {}", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <E extends Entity> List<E> jsonQuery(JsonNode jsonNode) throws InvalidQueryException, ResourceRegistryException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String ret = this.jsonQuery(objectMapper.writeValueAsString((Object)jsonNode));
            CollectionType type = ElementMapper.getObjectMapper().getTypeFactory().constructCollectionType(ArrayList.class, Entity.class);
            return (List)ElementMapper.getObjectMapper().readValue(ret, (JavaType)type);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

