/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.client;

import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.informationsystem.impl.utils.ISMapper;
import org.gcube.informationsystem.model.ER;
import org.gcube.informationsystem.model.ISManageable;
import org.gcube.informationsystem.model.entity.Entity;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.er.ERAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.er.ERNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.query.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPCall;
import org.gcube.informationsystem.resourceregistry.client.Direction;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.types.TypeBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryClientImpl
implements ResourceRegistryClient {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryClientImpl.class);
    public static final String PATH_SEPARATOR = "/";
    protected final String address;
    protected HTTPCall httpCall;

    public ResourceRegistryClientImpl(String address) {
        this.address = address;
    }

    private HTTPCall getHTTPCall() throws MalformedURLException {
        if (this.httpCall == null) {
            this.httpCall = new HTTPCall(this.address, ResourceRegistryClient.class.getSimpleName());
        }
        return this.httpCall;
    }

    @Override
    public <ERType extends ER> void exists(Class<ERType> clazz, UUID uuid) throws ERNotFoundException, ERAvailableInAnotherContextException, ResourceRegistryException {
        String type = clazz.getSimpleName();
        try {
            logger.info("Going to check if {} with UUID {} exists", (Object)type, (Object)uuid);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("access");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("instance");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(type);
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = this.getHTTPCall();
            httpCall.call(clazz, stringWriter.toString(), HTTPCall.HTTPMETHOD.HEAD);
            logger.debug("{} with UUID {} exists", (Object)type, (Object)uuid);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <ERType extends ER> ERType getInstance(Class<ERType> clazz, UUID uuid) throws ERNotFoundException, ERAvailableInAnotherContextException, ResourceRegistryException {
        String type = clazz.getSimpleName();
        try {
            logger.info("Going to get {} with UUID {}", (Object)type, (Object)uuid);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("access");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("instance");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(type);
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = this.getHTTPCall();
            ER erType = (ER)httpCall.call(clazz, stringWriter.toString(), HTTPCall.HTTPMETHOD.GET);
            logger.debug("Got {} with UUID {} is {}", new Object[]{type, uuid, erType});
            return (ERType)erType;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<? extends Entity> getInstances(String type, Boolean polymorphic) throws ResourceRegistryException {
        try {
            logger.info("Going to get all instances of {} ", (Object)type);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("access");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("instances");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(type);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("polymorphic", polymorphic.toString());
            HTTPCall httpCall = this.getHTTPCall();
            String ret = (String)httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.GET, parameters);
            logger.debug("Got instances of {} are {}", (Object)type, (Object)ret);
            return ISMapper.unmarshalList(Entity.class, (String)ret);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Resource> getInstancesFromEntity(String relationType, Boolean polymorphic, UUID reference, Direction direction) throws ResourceRegistryException {
        try {
            logger.info("Going to get all instances of {} from/to {}", (Object)relationType, (Object)reference.toString());
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("access");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("instances");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(relationType);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("polymorphic", polymorphic.toString());
            parameters.put("reference", reference.toString());
            parameters.put("direction", direction.toString());
            HTTPCall httpCall = this.getHTTPCall();
            String ret = (String)httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.GET, parameters);
            logger.debug("Got instances of {} from/to {} are {}", new Object[]{relationType, reference.toString(), ret});
            return ISMapper.unmarshalList(Resource.class, (String)ret);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <ISM extends ISManageable> List<TypeBinder.TypeDefinition> getSchema(Class<ISM> clazz, Boolean polymorphic) throws SchemaNotFoundException, ResourceRegistryException {
        String type = clazz.getSimpleName();
        try {
            logger.info("Going to get {} schema", (Object)type);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("access");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("schema");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(type);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("polymorphic", polymorphic.toString());
            HTTPCall httpCall = this.getHTTPCall();
            String schema = (String)httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.GET, parameters);
            logger.debug("Got schema for {} is {}", (Object)type, (Object)schema);
            return TypeBinder.deserializeTypeDefinitions((String)schema);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String query(String query, int limit, String fetchPlan) throws InvalidQueryException, ResourceRegistryException {
        try {
            logger.info("Going to query. {}", (Object)query);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("access");
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("query", query);
            if (limit <= 0) {
                limit = -1;
            }
            parameters.put("limit", Integer.toString(limit));
            if (fetchPlan != null) {
                parameters.put("fetchPlan", fetchPlan);
            }
            HTTPCall httpCall = this.getHTTPCall();
            String ret = (String)httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.GET, parameters);
            logger.debug("Query result is {}", (Object)ret);
            return ret;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

