/**
 * 
 */
package org.gcube.informationsystem.resourceregistry.client.plugin;

import org.gcube.common.clients.GCubeEndpoint;
import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.client.proxy.ResourceRegistryClient;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 *
 */
public class ResourceRegistryClientPlugin extends AbstractPlugin<GCubeEndpoint, ResourceRegistryClient>{

	public ResourceRegistryClientPlugin(){
		super(ResourceRegistryClientPlugin.class.getSimpleName());
	}
	
	@Override
	public String namespace() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
		// The Jersey client wraps the exception. So we need to get the wrapped 
		// exception thrown by ResourceRegistry Service.
		
		Throwable throwable = fault.getCause();
		if(throwable != null && throwable instanceof ResourceRegistryException){
			return (Exception) throwable;
		}
		
		return fault;
	}

	@Override
	public GCubeEndpoint resolve(GCubeEndpoint address, ProxyConfig<?, ?> config)
			throws Exception {
		return null;
	}

	@Override
	public ResourceRegistryClient newProxy(
			ProxyDelegate<GCubeEndpoint> delegate) {
		return new ResourceRegistryClient(delegate);
	}

}
