package org.gcube.informationsystem.resourceregistry.api.rest;

import org.gcube.common.security.providers.SecretManagerProvider;

/**
 * The Class ServiceInstance.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public abstract class ServiceInstance {

	/** The Constant PROD_ROOT_SCOPE. */
	private static final String PROD_ROOT_SCOPE = "/d4science.research-infrastructures.eu";
	
	/** The Constant BASE_URL. */
	public static final String BASE_URL = "https://url.d4science.org";
	
	/**
	 * Gets the service URL.
	 *
	 * @return the service URL
	 */
	public static String getServiceURL() {
		String context = SecretManagerProvider.get().getContext();
		return getServiceURL(context);
	}
	
	/**
	 * Gets the service URL.
	 *
	 * @param context the context
	 * @return the service URL
	 */
	public static String getServiceURL(String context) {
		if(context.startsWith(PROD_ROOT_SCOPE)) {
			return BASE_URL;
		}
		String root = context.split("/")[1];
		return BASE_URL.replace("url", "url." + root.replaceAll("\\.", "-"));
	}
	
}
