package org.gcube.informationsystem.resourceregistry.api.exceptions.relations.isrelatedto;

import java.io.Serial;


import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.RelationNotFoundException;

/**
 * The Class IsRelatedToNotFoundException.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class IsRelatedToNotFoundException extends RelationNotFoundException {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = -6461249423856424696L;

	/**
	 * Instantiates a new checks if is related to not found exception.
	 *
	 * @param message the message
	 */
	public IsRelatedToNotFoundException(String message) {
		super(message);
	}

	/**
	 * Instantiates a new checks if is related to not found exception.
	 *
	 * @param cause the cause
	 */
	public IsRelatedToNotFoundException(Throwable cause) {
		super(cause);
	}

	/**
	 * Instantiates a new checks if is related to not found exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public IsRelatedToNotFoundException(String message, Throwable cause) {
		super(message, cause);
	}

}
