/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.api.exceptions;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.gcube.informationsystem.impl.utils.discovery.ReflectionUtility;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExceptionMapper {
    private static Logger logger = LoggerFactory.getLogger(ExceptionMapper.class);
    protected static final ObjectMapper mapper = new ObjectMapper();

    public static ObjectMapper getObjectMapper() {
        return mapper;
    }

    public static <T extends OutputStream, RRE extends ResourceRegistryException> T marshal(RRE object, T stream) throws JsonGenerationException, JsonMappingException, IOException {
        mapper.writeValue(stream, object);
        return stream;
    }

    public static <T extends Writer, RRE extends ResourceRegistryException> T marshal(RRE object, T writer) throws JsonGenerationException, JsonMappingException, IOException {
        mapper.writeValue(writer, object);
        return writer;
    }

    public static <RRE extends ResourceRegistryException> String marshal(RRE object) throws JsonProcessingException {
        return mapper.writeValueAsString(object);
    }

    public static <RRE extends ResourceRegistryException> RRE unmarshal(Class<RRE> clz, Reader reader) throws JsonParseException, JsonMappingException, IOException {
        return (RRE)((ResourceRegistryException)mapper.readValue(reader, clz));
    }

    public static <RRE extends ResourceRegistryException> RRE unmarshal(Class<RRE> clz, InputStream stream) throws JsonParseException, JsonMappingException, IOException {
        return (RRE)((ResourceRegistryException)mapper.readValue(stream, clz));
    }

    public static <RRE extends ResourceRegistryException> RRE unmarshal(Class<RRE> clz, String string) throws JsonParseException, JsonMappingException, IOException {
        return (RRE)((ResourceRegistryException)mapper.readValue(string, clz));
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Package p = ResourceRegistryException.class.getPackage();
        try {
            List classes = ReflectionUtility.getClassesForPackage((Package)p);
            for (Class clz : classes) {
                logger.trace("Analyzing {}", (Object)clz);
                if (!ResourceRegistryException.class.isAssignableFrom(clz)) continue;
                mapper.registerSubtypes(new Class[]{clz});
            }
        }
        catch (ClassNotFoundException e) {
            logger.error("Error discovering classes inside package {}", (Object)p.getName(), (Object)e);
            throw new RuntimeException(e);
        }
    }
}

