/**
 * 
 */
package org.gcube.informationsystem.resourceregistry.api;

import java.util.UUID;

import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.EntityException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.FacetNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.ResourceNotFoundException;

/**
 * @author Luca Frosini (ISTI - CNR)
 * 
 */
public interface EntityManagement {

	/* Facets Methods */

	public String createFacet(String facetType, String jsonRepresentation)
			throws EntityException, ResourceRegistryException;

	public String readFacet(UUID uuid) throws FacetNotFoundException,
			ResourceRegistryException;

	public String readFacet(UUID uuid, String facetType)
			throws FacetNotFoundException, ResourceRegistryException;

	public String updateFacet(UUID uuid, String jsonRepresentation)
			throws FacetNotFoundException, ResourceRegistryException;

	public boolean deleteFacet(UUID uuid) throws FacetNotFoundException,
			ResourceRegistryException;

	/* Resources Methods */

	public String createResource(String resourceType, String jsonRepresentation)
			throws ResourceRegistryException;

	public String readResource(UUID uuid) throws ResourceNotFoundException,
			ResourceRegistryException;

	public String readResource(UUID uuid, String resourceType)
			throws ResourceNotFoundException, ResourceRegistryException;

	public boolean deleteResource(UUID uuid)
			throws ResourceNotFoundException, ResourceRegistryException,
			ResourceRegistryException;

	/* Relations Methods */

	public String attachFacet(UUID resourceUUID, UUID facetUUID,
			String consistOfType, String jsonRepresentation)
			throws FacetNotFoundException, ResourceNotFoundException,
			ResourceRegistryException;

	public boolean detachFacet(UUID consistOfUUID)
			throws ResourceRegistryException;

	public String attachResource(UUID sourceResourceUUID,
			UUID targetResourceUUID, String relatedToType,
			String jsonRepresentation) throws ResourceNotFoundException,
			ResourceRegistryException;

	public boolean detachResource(UUID relatedToUUID)
			throws ResourceRegistryException;

}
