/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resource_checker;

import java.io.File;
import java.io.FileWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.Software;
import org.gcube.common.resources.gcore.utils.XPathHelper;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.resource_checker.ResourceCheckerPluginDeclaration;
import org.gcube.informationsystem.resource_checker.utils.BasicFunctionalitiesMandatoryReader;
import org.gcube.informationsystem.resource_checker.utils.BasicFunctionalityBean;
import org.gcube.informationsystem.resource_checker.utils.RetrieveContextsList;
import org.gcube.informationsystem.resource_checker.utils.SendNotification;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ResourceCheckerPlugin
extends Plugin<ResourceCheckerPluginDeclaration> {
    private static final int SECONDS2WAIT = 2;
    private static final String INITIAL_ERRORS_STATEMENT = "Other errors: ";
    public static final String ROLE_TO_NOTIFY = "role";
    private static final String NAGIOS_PROPERTY_FILE = "/META-INF/plugin_resources/nagios-report-location.properties";
    private static final Logger logger = LoggerFactory.getLogger(ResourceCheckerPlugin.class);

    public ResourceCheckerPlugin(ResourceCheckerPluginDeclaration pluginDeclaration) {
        super((PluginDeclaration)pluginDeclaration);
        logger.info("Constructor invoked");
    }

    public void launch(Map<String, Object> inputs) throws Exception {
        logger.info("Starting plugin with inputs: " + inputs);
        List<BasicFunctionalityBean> mandatoryFunctionalities = new BasicFunctionalitiesMandatoryReader().getMandatoryFunctionalities();
        List<String> contexts = RetrieveContextsList.getContexts();
        logger.info("Contexts are " + contexts);
        logger.info("Mandatory functionalities are " + mandatoryFunctionalities);
        HashMap<String, List<BasicFunctionalityBean>> missingResourcesPerContext = new HashMap<String, List<BasicFunctionalityBean>>(contexts.size());
        String otherFailures = INITIAL_ERRORS_STATEMENT;
        DiscoveryClient client = ICFactory.client();
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        HashMap<String, String> resourceToIdentifierMap = new HashMap<String, String>(mandatoryFunctionalities.size());
        HashSet<String> missingResourcesKey = new HashSet<String>(mandatoryFunctionalities.size());
        for (String context : contexts) {
            ScopeProvider.instance.set(context);
            for (BasicFunctionalityBean service : mandatoryFunctionalities) {
                try {
                    String resourceId = null;
                    String resourceKey = service.getName() + ":" + service.getCategory();
                    resourceId = this.isServicePresent(service, client, docBuilder);
                    if (resourceId == null) {
                        List missingServices = null;
                        missingServices = missingResourcesPerContext.containsKey(context) ? (List)missingResourcesPerContext.get(context) : new ArrayList();
                        missingResourcesKey.add(resourceKey);
                        missingServices.add(service);
                        missingResourcesPerContext.put(context, missingServices);
                    } else {
                        resourceToIdentifierMap.put(resourceKey, resourceId);
                    }
                    Thread.sleep(2000L);
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) continue;
                    logger.warn("An error arose when checking for resource " + service + " into context " + context);
                    otherFailures = otherFailures + "\nAn error arose while checking for resource with name/category " + service.getName() + "/" + service.getCategory() + " into context " + context + "(stack trace is : " + e.getMessage() + ")";
                }
            }
        }
        otherFailures = otherFailures.equals(INITIAL_ERRORS_STATEMENT) ? otherFailures + "none.\n" : otherFailures + "\n";
        ArrayList<String> identifiers = new ArrayList<String>(mandatoryFunctionalities.size());
        for (String key : missingResourcesKey) {
            identifiers.add((String)resourceToIdentifierMap.get(key));
        }
        this.writeReport4Nagios(identifiers);
        if (!missingResourcesPerContext.isEmpty() || !otherFailures.equals("Other errors: none.\n")) {
            SendNotification.sendMessage(missingResourcesPerContext, otherFailures, (String)inputs.get(ROLE_TO_NOTIFY));
        }
        logger.info("Plugin's execution ended. Map of not available services per scope is the following: \n" + missingResourcesPerContext);
    }

    private String isServicePresent(BasicFunctionalityBean service, DiscoveryClient client, DocumentBuilder docBuilder) throws Exception {
        Class classFor = service.getType() == null ? ServiceEndpoint.class : service.getType();
        XQuery q = ICFactory.queryFor((Class)classFor);
        List result = null;
        if (!classFor.equals(ServiceEndpoint.class)) {
            if (classFor.equals(GCoreEndpoint.class)) {
                logger.error("There is no implementation yet to check for GCoreEndpoint");
                throw new Exception("There is no implementation yet to check for GCoreEndpoint");
            }
            if (classFor.equals(GenericResource.class)) {
                logger.error("There is no implementation yet to check for GenericResource");
                throw new Exception("There is no implementation yet to check for GenericResource");
            }
            if (classFor.equals(HostingNode.class)) {
                logger.error("There is no implementation yet to check for HostingNode");
                throw new Exception("There is no implementation yet to check for HostingNode");
            }
            if (classFor.equals(Software.class)) {
                logger.error("There is no implementation yet to check for Software");
                throw new Exception("There is no implementation yet to check for Software");
            }
            throw new Exception("Unable to check resource because its type is missing " + service);
        }
        q.addCondition("$resource/Profile/Name/text() eq '" + service.getName() + "'");
        q.addCondition("$resource/Profile/Category/text() eq '" + service.getCategory() + "'");
        result = client.submit((Query)q);
        if (result == null || result.isEmpty()) {
            return null;
        }
        String elem = (String)result.get(0);
        Element node = docBuilder.parse(new InputSource(new StringReader(elem))).getDocumentElement();
        XPathHelper helper = new XPathHelper((Node)node);
        List currValue = null;
        currValue = helper.evaluate("/Resource/ID/text()");
        if (currValue != null && currValue.size() > 0) {
            logger.debug("Id is " + (String)currValue.get(0));
            return (String)currValue.get(0);
        }
        throw new Exception("ID property is missing!");
    }

    protected void onStop() throws Exception {
        logger.debug("onStop() invoked");
        Thread.currentThread().interrupt();
    }

    private void writeReport4Nagios(List<String> idsMissingResources) throws Exception {
        Properties prop = new Properties();
        prop.load(((Object)((Object)this)).getClass().getResourceAsStream(NAGIOS_PROPERTY_FILE));
        String location = prop.getProperty("location");
        logger.trace("File location for nagios is " + location);
        File f = new File(location);
        f.getParentFile().mkdirs();
        f.delete();
        f.createNewFile();
        FileWriter writer = new FileWriter(f, false);
        if (idsMissingResources == null || idsMissingResources.isEmpty()) {
            writer.write("none");
        } else {
            for (String idMissing : idsMissingResources) {
                writer.write(idMissing + "\n");
            }
        }
        writer.close();
    }
}

