/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resource_checker.utils;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.resource_checker.utils.BasicFunctionalityBean;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.vremanagement.executor.plugin.PluginStateEvolution;
import org.gcube.vremanagement.executor.plugin.PluginStateNotification;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendNotification
extends PluginStateNotification {
    private Map<String, String> pluginInputs;
    private static Logger logger = LoggerFactory.getLogger(SendNotification.class);
    private static final String NOTIFY_METHOD_JOB_STATUS = "2/notifications/notify-job-status";
    private static final String USERS_METHOD_HAVING_ROLE = "2/users/get-usernames-by-global-role";
    private static final String NOTIFY_METHOD_MESSAGE = "2/messages/write-message";
    private static final String RESOURE_SN = "jersey-servlet";
    private static final String SERVICE_NAME_SN = "SocialNetworking";
    private static final String SERVICE_CLASSE_SN = "Portal";
    public static final String RECIPIENT_KEY = "recipient";
    private static final String SERVICE_NAME = "Smart-Executor";

    public SendNotification(Map<String, String> inputs) {
        super(inputs);
        this.pluginInputs = inputs;
    }

    /*
     * Unable to fully structure code
     */
    public void pluginStateEvolution(PluginStateEvolution pluginStateEvolution, Exception exception) throws Exception {
        switch (1.$SwitchMap$org$gcube$vremanagement$executor$plugin$PluginState[pluginStateEvolution.getPluginState().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                recipient = this.pluginInputs.get("recipient");
                basePath = SendNotification.discoverEndPoint();
                SendNotification.logger.info("Recipient of the notification is " + recipient + ". Base path found for the notification service is " + basePath);
                if (basePath == null || recipient == null) ** GOTO lbl72
                basePath = basePath.endsWith("/") != false ? basePath : basePath + "/";
                basePath = basePath + "2/notifications/notify-job-status?gcube-token=" + SecurityTokenProvider.instance.get();
                basePath = basePath.trim();
                try {
                    httpClient = HttpClientBuilder.create().build();
                    var6_7 = null;
                    obj = new JSONObject();
                    obj.put("job_id", pluginStateEvolution.getUuid().toString());
                    obj.put("recipient", recipient);
                    obj.put("job_name", pluginStateEvolution.getPluginDeclaration().getName());
                    obj.put("service_name", "Smart-Executor");
                    obj.put("status", "FAILED");
                    obj.put("status_message", "original status reported by Smart-Executor was " + pluginStateEvolution.getPluginState() + ". Exception is " + exception != null ? exception.getMessage() : null);
                    SendNotification.logger.debug("Request json is going to be " + obj.toString());
                    response = SendNotification.performRequestPost(httpClient, basePath, obj.toString());
                    SendNotification.logger.info(response.getStatusLine().getStatusCode() + " and response message is " + response.getStatusLine().getReasonPhrase());
                    status = response.getStatusLine().getStatusCode();
                    if (status == 200) {
                        SendNotification.logger.info("Notification sent");
                    } else if (status == 302 || status == 301 || status == 303) {
                        locations = response.getHeaders("Location");
                        lastLocation = locations[locations.length - 1];
                        realLocation = lastLocation.getValue();
                        SendNotification.logger.info("New location is " + realLocation);
                        response = SendNotification.performRequestPost(httpClient, realLocation, obj.toString());
                        SendNotification.logger.info(" " + response.getStatusLine().getStatusCode() + " and response message is " + response.getStatusLine().getReasonPhrase());
                    } else {
                        SendNotification.logger.warn(" " + response.getStatusLine().getStatusCode() + " and response message is " + response.getStatusLine().getReasonPhrase());
                    }
                    if (httpClient == null) break;
                    if (var6_7 == null) ** GOTO lbl51
                    try {
                        httpClient.close();
                    }
                    catch (Throwable var7_9) {
                        var6_7.addSuppressed(var7_9);
                    }
                    break;
lbl51:
                    // 1 sources

                    httpClient.close();
                    ** break;
                    catch (Throwable var7_10) {
                        try {
                            var6_7 = var7_10;
                            throw var7_10;
                        }
                        catch (Throwable var13_16) {
                            if (httpClient != null) {
                                if (var6_7 != null) {
                                    try {
                                        httpClient.close();
                                    }
                                    catch (Throwable var14_17) {
                                        var6_7.addSuppressed(var14_17);
                                    }
                                } else {
                                    httpClient.close();
                                }
                            }
                            throw var13_16;
lbl68:
                            // 1 sources

                        }
                    }
                }
                catch (Exception e) {
                    SendNotification.logger.warn("Something failed when trying to notify the user", (Throwable)e);
                }
                break;
lbl72:
                // 1 sources

                SendNotification.logger.error("No notification is going to be sent because social service is missing or recipient is not specified");
                break;
            }
            default: {
                SendNotification.logger.info("No notification is going to be sent because the status of the plugin execution is " + pluginStateEvolution.getPluginState().name());
            }
        }
    }

    public static void sendMessage(Map<String, List<BasicFunctionalityBean>> missingResourcesPerContext, String otherFailures, String role) {
        String basePath = SendNotification.discoverEndPoint();
        logger.debug("Sending notification to users having role = " + role + " using social service at path " + basePath);
        if (basePath != null && role != null) {
            basePath = basePath.endsWith("/") ? basePath : basePath + "/";
            basePath = basePath.trim();
            String fetchUsersPath = basePath + USERS_METHOD_HAVING_ROLE + "?gcube-token=" + SecurityTokenProvider.instance.get() + "&role-name=" + role;
            String sendMessagePath = basePath + NOTIFY_METHOD_MESSAGE + "?gcube-token=" + SecurityTokenProvider.instance.get();
            try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
                HttpResponse response = SendNotification.performRequestGet(httpClient, fetchUsersPath);
                int status = response.getStatusLine().getStatusCode();
                logger.debug("Status code is " + status + " and response message is " + response.getStatusLine().getReasonPhrase());
                if (status == 200) {
                    String resultUsers = EntityUtils.toString(response.getEntity());
                    JSONParser parser = new JSONParser();
                    JSONObject resultJson = (JSONObject)parser.parse(resultUsers);
                    JSONArray array = (JSONArray)resultJson.get("result");
                    logger.info("list of users to notify is " + array);
                    if (array.isEmpty()) {
                        logger.warn("No one has role " + role + " .. exiting");
                        return;
                    }
                    JSONArray arrayRecipients = new JSONArray();
                    for (int i = 0; i < array.size(); ++i) {
                        String user = (String)array.get(i);
                        JSONObject objR = new JSONObject();
                        objR.put("id", user);
                        arrayRecipients.add(objR);
                    }
                    SimpleDateFormat sdf = new SimpleDateFormat();
                    sdf.applyPattern("dd/MM/yy HH:mm:ss");
                    String dataStr = sdf.format(new Date());
                    StringBuilder sb = new StringBuilder();
                    sb.append("Dear ");
                    sb.append(role).append(",").append("\n");
                    sb.append("this is the report of the last running of the " + "resource-checker-se-plugin".toUpperCase() + " (" + dataStr + ").\nThe following missing resources have been found:\n");
                    Iterator<Map.Entry<String, List<BasicFunctionalityBean>>> iterator = missingResourcesPerContext.entrySet().iterator();
                    if (!iterator.hasNext()) {
                        sb.append("none.");
                    }
                    while (iterator.hasNext()) {
                        Map.Entry<String, List<BasicFunctionalityBean>> entry = iterator.next();
                        List<BasicFunctionalityBean> list = entry.getValue();
                        for (BasicFunctionalityBean basicFunctionalityBean : list) {
                            sb.append("- resource's name ");
                            sb.append(basicFunctionalityBean.getName());
                            sb.append(" and resource's class/category ");
                            sb.append(basicFunctionalityBean.getCategory());
                            sb.append(" (in context " + entry.getKey() + ")");
                        }
                        if (iterator.hasNext()) {
                            sb.append(";\n");
                            continue;
                        }
                        sb.append(".\n");
                    }
                    sb.append("\n\n");
                    sb.append(otherFailures + "\n");
                    sb.append("Best,\nresource-checker-se-plugin");
                    String message = sb.toString();
                    logger.debug("Going to send this message \n" + message);
                    JSONObject obj = new JSONObject();
                    obj.put("body", message);
                    obj.put("subject", "Resource Checker SE - Report (" + dataStr + ")");
                    obj.put("recipients", arrayRecipients);
                    logger.debug("Request json is going to be " + obj.toString());
                    response = SendNotification.performRequestPost(httpClient, sendMessagePath, obj.toString());
                    logger.info(response.getStatusLine().getStatusCode() + " and response message is " + response.getStatusLine().getReasonPhrase());
                    status = response.getStatusLine().getStatusCode();
                    if (status == 200) {
                        logger.info("Message sent");
                    } else if (status == 302 || status == 301 || status == 303) {
                        Header[] locations = response.getHeaders("Location");
                        Header lastLocation = locations[locations.length - 1];
                        String realLocation = lastLocation.getValue();
                        logger.info("New location is " + realLocation);
                        response = SendNotification.performRequestPost(httpClient, realLocation, obj.toString());
                    }
                }
            }
            catch (Exception e) {
                logger.warn("Failed to notify users...", (Throwable)e);
            }
        }
    }

    private static HttpResponse performRequestPost(CloseableHttpClient httpClient, String path, String params) throws ClientProtocolException, IOException {
        HttpPost request = new HttpPost(path);
        StringEntity paramsEntity = new StringEntity(params, ContentType.APPLICATION_JSON);
        request.setEntity(paramsEntity);
        return httpClient.execute(request);
    }

    private static HttpResponse performRequestGet(CloseableHttpClient httpClient, String path) throws ClientProtocolException, IOException {
        HttpGet request = new HttpGet(path);
        return httpClient.execute(request);
    }

    private static String discoverEndPoint() {
        String context = ScopeProvider.instance.get();
        String basePath = null;
        try {
            XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
            query.addCondition(String.format("$resource/Profile/ServiceClass/text() eq '%s'", SERVICE_CLASSE_SN));
            query.addCondition("$resource/Profile/DeploymentData/Status/text() eq 'ready'");
            query.addCondition(String.format("$resource/Profile/ServiceName/text() eq '%s'", SERVICE_NAME_SN));
            query.setResult("$resource/Profile/AccessPoint/RunningInstanceInterfaces//Endpoint[@EntryName/string() eq \"jersey-servlet\"]/text()");
            DiscoveryClient client = ICFactory.client();
            List endpoints = client.submit((Query)query);
            if (endpoints == null || endpoints.isEmpty()) {
                throw new Exception("Cannot retrieve the GCoreEndpoint serviceName: SocialNetworking, serviceClass: Portal, in scope: " + context);
            }
            basePath = (String)endpoints.get(0);
            if (basePath == null) {
                throw new Exception("Endpoint:jersey-servlet, is null for serviceName: SocialNetworking, serviceClass: Portal, in scope: " + context);
            }
            logger.info("found entryname " + basePath + " for ckanResource: " + RESOURE_SN);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such service endpoint information!", (Throwable)e);
        }
        return basePath;
    }
}

