package org.gcube.parthenosentities.model.reference.entity.resource.cidoc;

/**
 * @author Luca Frosini (ISTI - CNR)
 * Scope note: This class comprises items that have a persistent identity, sometimes known as “endurants” in
 * philosophy.
 * 
 * They can be repeatedly recognized within the duration of their existence by identity criteria rather than
 * by continuity or observation. Persistent Items can be either physical entities, such as people, animals or
 * things, or conceptual entities such as ideas, concepts, products of the imagination or common names.
 * The criteria that determine the identity of an item are often difficult to establish -; the decision depends
 * largely on the judgement of the observer. For example, a building is regarded as no longer existing if it
 * is dismantled and the materials reused in a different configuration. On the other hand, human beings go
 * through radical and profound changes during their life-span, affecting both material composition and
 * form, yet preserve their identity by other criteria. Similarly, inanimate objects may be subject to
 * exchange of parts and matter. The class E77 Persistent Item does not take any position about the nature
 * of the applicable identity criteria and if actual knowledge about identity of an instance of this class
 * exists. There may be cases, where the identity of an E77 Persistent Item is not decidable by a certain
 * state of knowledge.
 * 
 * The main classes of objects that fall outside the scope the E77 Persistent Item class are temporal
 * objects such as periods, events and acts, and descriptive properties.
 * 
 * Examples:
 * - Leonard da Vinci
 * - Stonehenge
 * - the hole in the ozone layer
 * - the First Law of Thermodynamics
 * - the Bermuda Triangle
 * 
 * In First Order Logic:
 * E77(x) ⊃ E1(x)
 */
public interface E77_Persistent_Item extends E1_CRM_Entity {
	
}
