package org.gcube.informationsystem.icproxy.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;

import java.util.List;

import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import lombok.extern.slf4j.Slf4j;

import org.gcube.informationsystem.icproxy.swagger.Bootstrap;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.QueryBox;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.LoggerFactory;

@Path("Resource")
@Slf4j
@Api(value="resource", authorizations={@Authorization(value = Bootstrap.GCUBE_TOKEN_IN_QUERY_DEF), @Authorization(value = Bootstrap.GCUBE_TOKEN_IN_HEADER_DEF)})
public class ICResource {

	private static final org.slf4j.Logger log = LoggerFactory.getLogger(ICResource.class);
	
	@GET
	@Path("/{id}")
	@ApiOperation(value = "Retrieve a resource of any kind by its id.", response=String.class, 
	notes="Retrieve a resource of any kind by its id. For example"
			+ " /ic-proxy/gcube/service/search/7f7f6d23-5c47-4cfd-9e88-9d10716fc59b", nickname="get-resource-by-id")
	@Produces(MediaType.TEXT_PLAIN)
	public String getById(@NotNull @PathParam("id") String id){
		log.info("resource request with id ",id);
						
		Query q = new QueryBox(String.format("declare namespace ic = 'http://gcube-system.org/namespaces/informationsystem/registry'; " +
				"for $resource in collection('/db/Profiles')//Document/Data/ic:Profile/Resource " +
				"where ($resource/ID/text() eq '%s') return $resource", id));
		DiscoveryClient<String> client = ICFactory.client();
		List<String> resources = client.submit(q);
		if (resources.size()>0)
			return resources.get(0);
		else throw new WebApplicationException("id "+id+" not found",Response.Status.NOT_FOUND);
		
	}
	
}
