package org.gcube.indexmanagement.storagehandling;

//import static org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections.NAME;
//import static org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections.document;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import javax.xml.namespace.QName;

import org.apache.commons.io.IOUtils;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.resource.StorageObject;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.indexmanagement.common.IndexException;
import org.gcube.indexmanagement.common.IndexManagementWSResource;
import org.gcube.indexmanagement.common.IndexServiceConst;
import org.gcube.indexmanagement.common.IndexWSResource;
import org.gcube.indexmanagement.common.IndexWSResource.DestructionMode;
import org.gcube.indexmanagement.storagehandling.stubs.DeltaActionType;
import org.gcube.indexmanagement.storagehandling.stubs.DeltaFileInfoType;
import org.gcube.indexmanagement.storagehandling.stubs.DeltaListManagerCreatedNotificationMessageType;
import org.gcube.indexmanagement.storagehandling.stubs.IndexRemovedNotificationMessageType;
import org.gcube.indexmanagement.storagehandling.stubs.StatusNotificationMessageType;
import org.gcube.indexmanagement.storagehandling.stubs.UpdateNotificationMessageType;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.impl.SimpleTopic;
import org.w3c.dom.Element;

public class DeltaListManagementHandler {
	
	private static final String RP_DELTA_FILE_LIST = "DeltaFileList";
    
    /* Topic Names */
    static final String TOPIC_ADD_DELTA = "AddDelta";
    static final String TOPIC_DELETE_DELTA = "DeleteDelta";
    static final String TOPIC_INDEX_REMOVED = "IndexRemoved";
    static final String TOPIC_INDEX_STATUS = "IndexStatus";
    static final String TOPIC_INDEX_MANAGER_CREATED = "IndexManagerCreated";
    
    private static final String NS = "http://gcube-system.org/namespaces/indexmanagement/DeltaListManagementProvider";
    
    static GCUBELog logger = new GCUBELog(DeltaListManagementHandler.class);
    
    private SimpleTopic addDeltaTopic;
    private SimpleTopic deleteDeltaTopic;
    private SimpleTopic indexRemovedTopic;
    private SimpleTopic indexStatusTopic;
    private SimpleTopic indexManagerCreatedTopic;
    private ArrayList <DeltaFileInfoType> deltaFileListBuffer = new ArrayList<DeltaFileInfoType>();
    private String stateObjectName = null;
    private String stateObjectID = null;
    private GCUBEServiceContext sctx;
    private IndexManagementWSResource resource;
    private String deltaFileCollectionID;
    private volatile boolean isAlive = true;

    public DeltaListManagementHandler() { 
    	
    }
    
    public DeltaListManagementHandler(IndexManagementWSResource resource, String stateFilename) throws IndexException { 
        try {
            this.resource = resource;
            this.sctx = resource.getServiceContext();

            String indexNS = NS + "/" + resource.getIndexID();

            /* Create the resource properties */
            deltaFileCollectionID = IndexServiceConst.INDEX_COLLECTION_NAME;//getIndexCollectionID();
            
            ResourceProperty prop = resource.createProperty(RP_DELTA_FILE_LIST, NS);
            prop.add(new DeltaFileInfoType[0]);
            
            /* Create the topics */
            this.addDeltaTopic = resource.createTopic(TOPIC_ADD_DELTA, indexNS);
            this.deleteDeltaTopic = resource.createTopic(TOPIC_DELETE_DELTA, indexNS);
            this.indexRemovedTopic = resource.createTopic(TOPIC_INDEX_REMOVED, indexNS);
            this.indexStatusTopic = resource.createTopic(TOPIC_INDEX_STATUS, indexNS);
            this.indexManagerCreatedTopic = resource.createTopic(TOPIC_INDEX_MANAGER_CREATED, indexNS);

            this.stateObjectName = stateFilename;
            
            			
			/* Start a new thread to restore a CMS state - if one is found - and 
			 * wait for the completion of the 'manager created' topic
			 * registration before sending a 'manager created' notification.
			 */
            RestoreCMSStateAndWaitForRegistrationCompletion();
        }
        catch (Exception e){
            logger.error("Unable to create DeltaListManagementHandler [ IndexID: " + resource.getIndexID() + ", Key: " + resource.getID() + " ]", e);
            throw new IndexException(e);
        }
    }
    
    /**
     * Spawns a new thread to find if a state for this index is stored in the CMS, and to 
     * restore the state in case one is found. Then it waits for the completion of the 
     * 'manager creation' topic registration. After the registration is completed, it sends a 
     * notification on this topic to state that a manager has been created.
     */
    private void RestoreCMSStateAndWaitForRegistrationCompletion() {
    	Thread restoreAndWaitThr = new Thread() {
        	/*
        	 * (non-Javadoc)
        	 * @see java.lang.Thread#run()
        	 */
        	public void run() {
        		// Try to revive from persistent storage
    			try {
    				restoreIndexStateFromCMS();
    			}catch(Exception e){
    				logger.error("Failed to restore index state from the CMS.", e);
    			}
    			/* Poll the notifier to see if the registration of the 'manager
    			 * creation' notification topic is completed. When it is, notify
    			 * delta file consumers that a new manager for this index has been
    			 * constructed.
    			 */
    			//ISNotifier notifier = GHNContext.getImplementation(ISNotifier.class);
    			while (true) {
    				try {
    					Thread.sleep(40000);	// Poll every 40 seconds
    				} catch (Exception e) { }
    				//if (notifier.isTopicRegistered(indexManagerCreatedTopic.getName(), resource.getEPR(), sctx, sctx.getScope()))
    				try {
    					if (resource.isTopicRegistered(indexManagerCreatedTopic))
    						break;
    				} catch (Exception e) { }
    			}
    			sendManagerCreationNotification();
        	}
        };
        
        try {
	        logger.debug("Starting new thread for restoring a state from CMS and checking notification topics registration completion...");
	        sctx.setScope(restoreAndWaitThr, sctx.getScope());
	        sctx.useCallerCredentials(restoreAndWaitThr);
	        restoreAndWaitThr.start();
	        logger.debug("'Restore CMS state'-'Registration completion check' thread started.");
        } catch (Exception e) {
        	logger.error("Failed to start 'Restore CMS state'-'Registration completion check' thread.", e);
        }
    }
    
    /**
     * Spawns a new thread to wait for the completion of the 'manager creation' topic
     * registration. After the registration is completed, send a notification on this
     * topic to state that a manager has been created.
     */
    private void waitForManagerCreationTopicRegistrationCompletion() {
    	Thread registrationCompletionThr = new Thread() {
        	/*
        	 * (non-Javadoc)
        	 * @see java.lang.Thread#run()
        	 */
        	public void run() {
    			/* Poll the notifier to see if the registration of the 'manager
    			 * creation' notification topic is completed. When it is, notify
    			 * delta file consumers that a new manager for this index has been
    			 * constructed.
    			 */
    			//ISNotifier notifier = GHNContext.getImplementation(ISNotifier.class);
    			while (true) {
    				try {
    					Thread.sleep(40000);	// Poll every 40 seconds
    				} catch (Exception e) { }
    				//if (notifier.isTopicRegistered(indexManagerCreatedTopic.getName(), resource.getEPR(), sctx, sctx.getScope()))
    				try {
    					if (resource.isTopicRegistered(indexManagerCreatedTopic))
    						break;
    				} catch (Exception e) { }
    			}
    			sendManagerCreationNotification();
        	}
        };
        
        try {
	        logger.debug("Starting new thread for notification topics registration completion check...");
	        sctx.setScope(registrationCompletionThr, sctx.getScope());
	        sctx.useCallerCredentials(registrationCompletionThr);
	        registrationCompletionThr.start();
	        logger.debug("Registration completion check thread started.");
        } catch (Exception e) {
        	logger.error("Failed to start registration completion checker thread.", e);
        }
    }
    
    
    /**
     * Stores the current state of this DeltaListManagementHandler to an object stream.
     * @param oos the output stream
     */
    public void storeState(ObjectOutputStream oos) {
    	try {
    		oos.writeObject(deltaFileCollectionID);
    		oos.writeInt(deltaFileListBuffer.size());
	    	for (DeltaFileInfoType delta : deltaFileListBuffer) {
	    		oos.writeObject(delta);
	    	}
	    	oos.writeObject(this.stateObjectName);
	    	if (this.stateObjectID == null)
	    		oos.writeBoolean(false);
	    	else {
	    		oos.writeBoolean(true);
	    		oos.writeObject(this.stateObjectID);
	    	}
    	} catch (Exception e) {
    		logger.error("Failed to store DeltaListManagementHandler state.", e);
    	}
    }
    
    /**
     * Loads the current state of this DeltaListManagementHandler from an object stream.
     * @param ois the input stream
     * @param firstLoad specifies whether this is the first load or not
     * @param resource the manager resource associated with this DeltaListManagementHandler
     */
    public void loadState(ObjectInputStream ois, boolean firstLoad, IndexManagementWSResource resource) throws Exception {
    	ResourceProperty deltaList = null;
    	
    	try {
	        this.resource = resource;
	        this.sctx = resource.getServiceContext();
	
	        String indexNS = NS + "/" + resource.getIndexID();
	
	        deltaFileCollectionID = (String) ois.readObject();

	        /* Create the resource properties */
	        deltaList = resource.createProperty(RP_DELTA_FILE_LIST, NS);
	        
	        /* Create the topics */
	        this.addDeltaTopic = resource.createTopic(TOPIC_ADD_DELTA, indexNS);
	        this.deleteDeltaTopic = resource.createTopic(TOPIC_DELETE_DELTA, indexNS);
	        this.indexRemovedTopic = resource.createTopic(TOPIC_INDEX_REMOVED, indexNS);
	        this.indexStatusTopic = resource.createTopic(TOPIC_INDEX_STATUS, indexNS);
	        this.indexManagerCreatedTopic = resource.createTopic(TOPIC_INDEX_MANAGER_CREATED, indexNS);
	    }
	    catch (Exception e) {
	        logger.error("Unable to create DeltaListManagementHandler [ IndexID: " + resource.getIndexID() + ", Key: " + resource.getID() + " ]", e);
	        throw new IndexException(e);
	    }

    	try {
    		int numDeltaFiles = ois.readInt();
    		for (int i=0; i<numDeltaFiles; i++) {
    			DeltaFileInfoType delta = (DeltaFileInfoType) ois.readObject();
    			deltaFileListBuffer.add(delta);
    		}
    		deltaList.add(deltaFileListBuffer.toArray(new DeltaFileInfoType[deltaFileListBuffer.size()]));
    	} catch (Exception e) {
    		logger.error("Failed to load DeltaListManagementHandler state.");
            throw new IndexException("Failed to load DeltaListManagementHandler state.", e);
    	}
    	
    	this.stateObjectName = (String) ois.readObject();
    	boolean bReadStateOID = ois.readBoolean();
    	if (bReadStateOID)
    		this.stateObjectID = (String) ois.readObject();
    	
    	/* Start a new thread to wait for the completion of the 'manager created' topic
		 * registration before sending a 'manager created' notification to notify
		 * delta file consumers that a new manager for this index has been constructed.
		 */
    	if (firstLoad)
    		waitForManagerCreationTopicRegistrationCompletion();
    }
	
	/**
	 * Restores the previously saved index state from the CMS
	 * @throws IndexException 
	 */
    private void restoreIndexStateFromCMS() throws Exception {
    	
    	/* OLD WAY TO FIND STATE THROUGH CMS - DELETE IT
    	CollectionMemberDescription[] members = null;
		
		try {
			members = colms.getMembers((String) resource.getResourcePropertySet().get(new QName(NS, RP_DELTA_FILE_COLLECTION_ID)).get(0)).getMembers();
		} catch (Exception e) {
			logger.error("Failed to retrieve info from the index CMS collection.", e);
			throw new IndexException("Failed to retrieve info from the index CMS collection.", e);				
		}

		// Find the CMS object that contains the index state
		for (CollectionMemberDescription desc : members) {
			if (desc.getObjectName().equals(stateObjectName)) {
				stateObjectID = desc.getObjectID();
				break;
			}
		}
    	*/
		/*
    	final CollectionMemberDescription iod = new CollectionMemberDescription();
    	ColMSServiceHandler colmsHandler = new ColMSServiceHandler(sctx) {
			@Override
			protected void interact(EndpointReferenceType arg0) throws Exception {
				CoMSPortType colms = getNewColmsPortType(arg0);
				
				logger.trace("calling CoMS with params Name: " + stateObjectName + ", Type: " + BasicInfoObjectDescription.OBJECT_TYPE_DOCUMENT + ", colID: " + deltaFileCollectionID);
				ArrayList<CollectionMemberFilter> filters = new ArrayList<CollectionMemberFilter>();
				filters.add(new MemberTypeFilter(BasicInfoObjectDescription.OBJECT_TYPE_DOCUMENT));
				filters.add(new MemberTypeFilter(stateObjectName));
				
				CollectionManagementCall call = new CollectionManagementCall(colms);
				String locator;
				try{
					locator = call.findMembers(deltaFileCollectionID, filters, new CollectionMemberDescriptionResponse());
				}catch(Exception e) {
					logger.error("Error while trying to contact the CollectionManagement service.", e);
		            throw new Exception("Error while trying to contact the CollectionManagement service.", e);
				}
				
				logger.trace("CoMS returned: " + locator);
				RSXMLReader reader = RSXMLReader.getRSXMLReader( new RSLocator(locator));
				reader = reader.makeLocal(new RSResourceLocalType());
				RSXMLIterator iterator = reader.getRSIterator();
				
				//read the RS returned by findMembers
				boolean first = true;
				int i = 0;
				
				logger.trace("reading the RS returned by findMembers");
				
				while(iterator.hasNext()){
					ResultElementXBean element = (ResultElementXBean)iterator.next(ResultElementXBean.class);
					CollectionMemberDescription mDesc = (CollectionMemberDescription)element.getBean();
					if (first){
						iod.setObjectID(mDesc.getObjectID());
						first = false;
					}
					logger.trace("found IO with id: " + mDesc.getObjectID());
					i++;
				}
				
				logger.trace("found " + i + " IOs");
				if(i > 1)
					logger.warn("Found more than 1 IO for CMS stored state");
				
			}
		};
		colmsHandler.setNewPortType();
		colmsHandler.setHandled(resource);
		colmsHandler.run();
        if (iod.getObjectID() == null) {
        	logger.debug("A saved state for this index was not found.");
            return;
        }
        */
        
        logger.trace("calling CMS with params Name: " + stateObjectName + ", colID: " + deltaFileCollectionID);
		
        //get the document using this DocID and the Delta Collection ID
		if(this.deltaFileCollectionID == null)
		{
			logger.error("There is no delta collection ID during delta file download from CMS ");
			throw new Exception("No delta collection ID during delta file download from CMS ");
		}
		
		int i = 0;
//      GCubeDocument document = null;
		String documentID = null;
        
	    try{    
	    	
	    	ScopeProvider.instance.set(sctx.getScope().toString());
	    	
	    	IClient client=new StorageClient("Index", "StorageHandler", "delta", AccessType.SHARED).getClient();
	    	
	    	logger.info("LISTING : " + deltaFileCollectionID);
	    	
	    	List<StorageObject> storageObjects=client.showDir().RDir(deltaFileCollectionID);
	    
	    	for (StorageObject so : storageObjects) {
	    		documentID = so.getName();
	    		logger.debug("Found document with ID: " + documentID);
	    		i++;
	    		logger.info("-> " + documentID);
	    	}
	    	
//	        //instantiate the CMReader
//	        DocumentReader docReader = new DocumentReader(deltaFileCollectionID, sctx.getScope());
//	        
//	        //define a gcube main document projection
//	        DocumentProjection projection = document().withValue(NAME, stateObjectName);
//	        
//	        
//	        //ask for all documents having the specified name
//	        RemoteIterator<GCubeDocument> documentIterator = docReader.get(projection);
//	    
//	        //iterate over the collection
//	        while(documentIterator.hasNext()){
//	          if(i == 0){
//	        	  document = documentIterator.next();
//	        	  logger.debug("Found document with ID: " + document.id());
//	          }else{
//	        	  logger.debug("Found document with ID: " + documentIterator.next().id());
//	          }
//	          i++;          
//	        }
	    }catch(Exception e) {
			logger.error("Error when calling CMS with params Name: " + stateObjectName + ", colID: " + deltaFileCollectionID, e);
	        throw new Exception("Error when calling CMS with params Name: " + stateObjectName + ", colID: " + deltaFileCollectionID, e);
		}
        
        logger.trace("found " + i + " documents");
		if(i > 1)
			logger.warn("Found more than 1 document for CMS stored state");
		
		if (documentID == null) {
        	logger.debug("A saved state for this index was not found.");
            return;
        }


        /* If a saved state was found... */
        stateObjectID = documentID;
		logger.debug("Found a saved state for this index (id=" + stateObjectID + "). Attempting to load it...");
		/*
		CMSServiceHandler cmsHandler = new CMSServiceHandler(sctx) {
			@Override
			protected void interact(EndpointReferenceType arg0) throws Exception {
				CMSPortType1PortType cms = getCmsPortType(arg0);
		    	GetDocumentParameters getDocumentParams = new GetDocumentParameters();
				getDocumentParams.setDocumentID(stateObjectID);
				getDocumentParams.setTargetFileLocation(BasicInfoObjectDescription.RAW_CONTENT_IN_MESSAGE);
				try {
					String persistenceInfo = new String(cms.getDocument(getDocumentParams).getRawContent(), "utf-8");
				    	
			    	BufferedReader br = new BufferedReader(new StringReader(persistenceInfo));
					String ID = null;
					String action = null;
					String indexTypeID = null;
					String docCount = null;
					while ((ID = br.readLine()) != null) { 
						action = br.readLine();
						indexTypeID = br.readLine();
						docCount = br.readLine();
						DeltaFileInfoType df = new DeltaFileInfoType();
						df.setDeltaAction(DeltaActionType.fromString(action));
						df.setDeltaFileID(ID);
						df.setDocumentCount(Integer.parseInt(docCount));
						df.setIndexTypeID(indexTypeID);
						
						logger.debug("Found deltafile with ID: " + ID);
						
						mergeDeltaFile(df, false);
					}
					br.close();
					
					logger.debug("Loading of the saved index state finished.");
				} catch (GCUBEFault f) {
					logger.error("Failed to retrieve the saved index state from the CMS.", f);
					throw f;
				} catch (Exception e) {
					logger.error("Failed to retrieve the saved index state from the CMS.", e);
				}
			}
		};		
		cmsHandler.setHandled(resource);
		cmsHandler.run();*/
		
		try {
			
			//instantiate the CMReader
			
			
			
//			DocumentReader docReader = new DocumentReader(this.deltaFileCollectionID, sctx.getScope());
//			
//			DocumentProjection projection = document();
//			//setting the include content into true is not needed in the current version of CM - 22/10/10
//			//projection.includeContent(true);
//             
//			//retrieve the document, we are not specifying projections, therefore the entire document is returned.
//			document = docReader.get(stateObjectID, projection);
//			
//			String persistenceInfo = new String(document.bytestream());
		    	
			ScopeProvider.instance.set(sctx.getScope().toString());
			
			IClient client=new StorageClient("Index", "StorageHandler", "delta", AccessType.SHARED).getClient();
			
			String remoteFile = this.deltaFileCollectionID + "/" + stateObjectID;
			logger.info("GET as stream : remote : " + remoteFile);
			
			InputStream is = (InputStream) client.get().RFileAsInputStream(remoteFile);
			
			
//			StringWriter writer = new StringWriter();
//			IOUtils.copy(is, writer, "UTF-8");
//			String persistenceInfo = writer.toString();
			
	    	/* Read the index state and restore the delta files list */
	    	BufferedReader br = new BufferedReader(new InputStreamReader(is));
			String ID = null;
			String action = null;
			String indexTypeID = null;
			String docCount = null;
			while ((ID = br.readLine()) != null) { 
				action = br.readLine();
				indexTypeID = br.readLine();
				docCount = br.readLine();
				DeltaFileInfoType df = new DeltaFileInfoType();
				df.setDeltaAction(DeltaActionType.fromString(action));
				df.setDeltaFileID(ID);
				df.setDocumentCount(Integer.parseInt(docCount));
				df.setIndexTypeID(indexTypeID);
				
				logger.debug("Found deltafile with ID: " + ID);
				
				mergeDeltaFile(df, false);
			}
			br.close();
			
			logger.debug("Loading of the saved index state finished.");
		} catch (Exception e) {
			logger.error("Failed to retrieve the saved index state from the CMS.", e);
			throw e;
		}
    }
    
    /**
     * Saves the current index state to the CMS
     * @throws IndexException 
     */
    private void saveIndexStateToCMS() throws IndexException {
    	logger.debug("Saving the index state on the CMS...");
    	
    	try {
	    	/* Construct the state information */
	    	StringBuilder sb = new StringBuilder();
	    	for (DeltaFileInfoType deltaInfo : deltaFileListBuffer) {
	    		logger.debug("DeltaFileID: " + deltaInfo.getDeltaFileID());
	    		sb.append(deltaInfo.getDeltaFileID() + "\n");
	    		sb.append(deltaInfo.getDeltaAction() + "\n");
	    		sb.append(deltaInfo.getIndexTypeID() + "\n");
	    		sb.append(deltaInfo.getDocumentCount() + "\n");
	    	}
	    	final byte[] persistenceInfoBytes = sb.toString().getBytes("utf-8");
	    	
	    	/*CMSServiceHandler cmsHandler = new CMSServiceHandler(sctx) {
				@Override
				protected void interact(EndpointReferenceType arg0) throws Exception {
					CMSPortType1PortType cms = getCmsPortType(arg0);
			    	if (stateObjectID == null) {
			    		StoreDocumentParameters storeDocParams = new StoreDocumentParameters();
						storeDocParams.setDocumentName(stateObjectName);
						storeDocParams.setRawContent(persistenceInfoBytes);
						storeDocParams.setCollectionID(deltaFileCollectionID);
						stateObjectID = cms.storeDocument(storeDocParams).getDocumentID();
			    	}
			    	else {
			    		UpdateDocumentParameters updateParams = new UpdateDocumentParameters();
						updateParams.setDocumentID(stateObjectID);
						updateParams.setRawContent(persistenceInfoBytes);
						cms.updateDocumentContent(updateParams);				
			    	}
			    	logger.debug("Index state saved, OID = " + stateObjectID);
				}
    		};
    		cmsHandler.setHandled(resource);
    		cmsHandler.run();*/
    		
    		//save the state in the CMS
    		if(this.deltaFileCollectionID == null)
			{
				logger.error("There is no delta collection ID during delta file upload to CMS ");
				throw new Exception("No delta collection ID during delta file upload to CMS ");
			}
    		if (stateObjectID == null) { /* There is no existing state for this index in the CMS, so create it */
    			
	    		//instantiate the CMWriter
//				DocumentWriter cmWriter = new DocumentWriter(this.deltaFileCollectionID, sctx.getScope());
//				 
//				//create an instance of a gcube document
//				GCubeDocument document = new GCubeDocument();
//				document.setName(stateObjectName);
//				document.setMimeType("application/octet-stream");
//				document.setBytestream(persistenceInfoBytes);
				
				
    			ScopeProvider.instance.set(sctx.getScope().toString());
    			
    			InputStream is = (InputStream) new ByteArrayInputStream(persistenceInfoBytes);
    			
				IClient client=new StorageClient("Index", "StorageHandler", "delta", AccessType.SHARED).getClient();
				
				String remoteFile = this.deltaFileCollectionID + "/" + stateObjectName;
				logger.info("PUT as stream : remoteFile : " + remoteFile);
				
				String ret = client.put(true).LFile(is).RFile(remoteFile);
				
				
				stateObjectID = ret;
    		}
    		else { /* There is already a state for this index in the CMS, so update it */
    			//instantiate a CMWriter and a CMReader
    			
    			InputStream is = (InputStream) new ByteArrayInputStream(persistenceInfoBytes);
    			
    			ScopeProvider.instance.set(sctx.getScope().toString());
    			
    			
    			IClient client=new StorageClient("Index", "StorageHandler", "delta", AccessType.SHARED).getClient();
    			
    			String remoteFile = this.deltaFileCollectionID + "/" + stateObjectName;
				logger.info("PUT as stream : remoteFile : " + remoteFile);
    			
				client.put(true).LFile(is).RFile(this.deltaFileCollectionID + "/" + stateObjectName);
				
    			
				//TODO: update???
//    			GCubeDocument virtualDocument = new GCubeDocument(stateObjectID);
//    			
//    			//reset the content
//    			//this is astaged update - we need to put an indication for the delta tree change
//    			virtualDocument.setBytestream(new byte[0]);
//    			
//    			virtualDocument.trackChanges();
//    			
//    			virtualDocument.setBytestream(persistenceInfoBytes);
//    			DocumentWriter docWriter = new DocumentWriter(this.deltaFileCollectionID, sctx.getScope());
//    			docWriter.update(virtualDocument);
    		}
    		logger.debug("Index state saved, OID = " + stateObjectID);
			
	    	
    	} catch (Exception e) {
    		throw new IndexException("Failed to save index state on the CMS.", e);
    	}
    }
    
    /**
     * Deletes the index state from the CMS
     * @throws IndexException 
     */
    private void deleteIndexStateFromCMS() throws IndexException {
    	try {
	    	/* Check if there is a saved state of the index in the CMS */
	    	if (stateObjectID != null) {
	    		
	    		/*ColMSServiceHandler colmsHandler = new ColMSServiceHandler(sctx) {
					@Override
					protected void interact(EndpointReferenceType arg0) throws Exception {
						
						CoMSPortType1PortType colms = getColmsPortType(arg0);
			    		CollectionMember member = new CollectionMember();
			    		member.setCollectionID(deltaFileCollectionID);
			    		member.setMemberOID(stateObjectID);
			    		colms.removeMember(member);
			    		logger.debug("Removed index state object from index internal collection");
					}
	    		};
	    		colmsHandler.setHandled(resource);
	    		colmsHandler.run();
	    		
	    		CMSServiceHandler cmsHandler = new CMSServiceHandler(sctx) {
					@Override
					protected void interact(EndpointReferenceType arg0) throws Exception {
						CMSPortType1PortType cms = getCmsPortType(arg0);
						
			    		try {	
				    		cms.deleteDocument(stateObjectID);
				    		logger.debug("Deleted index state from CMS, OID = " + stateObjectID);
						} catch (Exception e) {
							logger.error("Error while removing index state object from CMS, OID = " + stateObjectID);
							throw new Exception("Error while removing index state object from CMS, OID = " + stateObjectID);
						}
						
			    		try {
				    		for(DeltaFileInfoType deltaFileInfo : deltaFileListBuffer){
				                cms.deleteDocument(deltaFileInfo.getDeltaFileID());
				                logger.debug("Deleted delta file: " + deltaFileInfo.getDeltaFileID());
				            }
			    		} catch (Exception e) {
			    			logger.error("Error while removing delta files from the CMS.", e);
			    			throw new Exception("Error while removing delta files from the CMS.");
			    		}
					}
	    		};
	    		cmsHandler.setHandled(resource);
	    		cmsHandler.run();
	    		*/
	    		
	    		/* Remove the state object from the delta collection */
	    		if(this.deltaFileCollectionID == null)
				{
					logger.error("There is no delta collection ID during delta file deletion from CMS ");
					throw new Exception("No delta collection ID during delta file deletion from CMS ");
				}
				//instantiate the CMWriter
	    		ScopeProvider.instance.set(sctx.getScope().toString());
	    		
	    		IClient client=new StorageClient("Index", "StorageHandler", "delta", AccessType.SHARED).getClient();
	    		//DocumentWriter docWriter = new DocumentWriter(this.deltaFileCollectionID, sctx.getScope());
	    		
	    		try{
		    		//docWriter.delete(new GCubeDocument(stateObjectID));
	    			String id = this.deltaFileCollectionID + "/" + stateObjectID;
					logger.info("REMOVE by ID  : " + id);
		    		client.remove().RFileById(id);
		    		logger.debug("Deleted index state from CMS, OID = " + stateObjectID);
		    	} catch (Exception e) {
					logger.error("Error while removing index state object from CMS, OID = " + stateObjectID, e);
					throw new Exception("Error while removing index state object from CMS, OID = " + stateObjectID, e);
				}
		    	
		    	/* Remove the delta files from the CMS */
	    		try {
		    		for(DeltaFileInfoType deltaFileInfo : deltaFileListBuffer){
		    			//docWriter.delete(new GCubeDocument(deltaFileInfo.getDeltaFileID()));
		    			//client.remove(this.deltaFileCollectionID + "/" + deltaFileInfo.getDeltaFileID());
		    			String id = deltaFileInfo.getDeltaFileID();
						logger.info("REMOVE by ID  : " + id);
			    		client.remove().RFileById(id);
		                logger.debug("Deleted delta file: " + deltaFileInfo.getDeltaFileID());
		            }
	    		} catch (Exception e) {
	    			logger.error("Error while removing delta files from the CMS.", e);
	    			throw new Exception("Error while removing delta files from the CMS.");
	    		}
	    	}
    	} catch (Exception e) {
    		throw new IndexException("Failed to delete saved index state on the CMS.", e);
    	}
    }
    
    public synchronized int connectLookup() throws IndexException {
        if(isAlive){
            int connID = resource.getConnectionCount();
            resource.setConnectionCount(connID + 1);
            return connID;
        }
        else{
            throw new IndexException("IndexManagement has been removed. Unable to connect.");
        }
    }
    
    public synchronized int connectUpdater() throws IndexException {
        if(isAlive){
        	int connID = resource.getConnectionCount();
        	logger.debug("Adding to updater list: " +  connID);
        	resource.addUpdater(connID);
            resource.setConnectionCount(connID + 1);
            if(!resource.getIndexStatus().equals(IndexManagementWSResource.MANAGER_STATUS_UPDATING)){
                setIndexStatus(IndexManagementWSResource.MANAGER_STATUS_UPDATING);
            }
            return connID;
        }
        else{
            throw new IndexException("IndexManagement has been removed. Unable to connect.");
        }
    }
    
    public void disconnectUpdater(int connectionID) {    	
        try{
        	resource.deleteUpdater(connectionID);
            //should somehow also check if the main lookup has actually downloaded all
            if(resource.getUpdaterCount() == 0)
                setIndexStatus(IndexManagementWSResource.MANAGER_STATUS_FINISHED);
            
            /* The update has been completed, store the index state in the CMS */
            saveIndexStateToCMS();
            logger.info("Updater " + connectionID + " has been disconnected, storing resource...");
            resource.store();
        }
        catch(Exception e){
            logger.error("Failed to disconnect updater: " + connectionID , e);
        }
    }

    protected void mergeDeltaFile(DeltaFileInfoType deltaInfo, boolean bSendUpdateNotification) throws Exception{
        int deltaIdx = deltaFileListBuffer.size();
        addDeltaFile(deltaInfo);
        if(deltaInfo.getDeltaAction().equals(DeltaActionType.Addition)){
            resource.setDocumentCount(resource.getDocumentCount() + deltaInfo.getDocumentCount());
        }
        else if(deltaInfo.getDeltaAction().equals(DeltaActionType.Deletion)){
            resource.setDocumentCount(resource.getDocumentCount() - deltaInfo.getDocumentCount());
        }
        resource.setModified(Calendar.getInstance());
        if (bSendUpdateNotification)
        	sendUpdateNotification(deltaInfo, deltaIdx);
    }
    
    public DeltaFileInfoType getDeltaFileInfo(int idx) {
    	String str = new String();
    	for (DeltaFileInfoType d : deltaFileListBuffer) {
    		str += d.getDeltaFileID();
    	}
    	
    	logger.info("DeltasInfoTypes : " + str);
    	
    	return deltaFileListBuffer.get(idx); 
    }
    
    public DeltaFileInfoType[] getDeltaFileList() {return (DeltaFileInfoType[]) resource.getResourcePropertySet().get(new QName(NS, RP_DELTA_FILE_LIST)).get(0); }
    
    /**
     * Closes the delta list management handler by performing clean up.
     * Must be called when an index management resource is being destroyed.
     */
    public synchronized void close() {
        isAlive = false;
        
        /* Send an index removal notification */
        if (resource.getDestructionMode() == DestructionMode.FULL_DESTRUCTION)
        	sendRemoveNotification();
        
        /* Unregister the notification topics */
        try{
            unregisterTopics();
        }catch(IndexException e) {
        	logger.error("Unable to unregister topics: ", e);
        }

        if (resource.getDestructionMode() == DestructionMode.FULL_DESTRUCTION) {
	        /* Delete persistence info from CMS */
	        try {
	        	deleteIndexStateFromCMS();
	        } catch (IndexException e) {
	        	logger.error("Failed to delete index state from the CMS.", e);
	        }
        }
    }
    
    
    private void addDeltaFile(DeltaFileInfoType deltaFileInfo) {
        this.deltaFileListBuffer.add(deltaFileInfo);
        logger.info("Adding info for : " + deltaFileInfo.getDeltaFileID());
        resource.getResourcePropertySet().get(new QName(NS, RP_DELTA_FILE_LIST)).set(0, deltaFileListBuffer.toArray(new DeltaFileInfoType[deltaFileListBuffer.size()]));
    }
    
    private void sendUpdateNotification(DeltaFileInfoType deltaInfo, int deltaIdx){
        try{
            UpdateNotificationMessageType message = new UpdateNotificationMessageType(deltaIdx, deltaInfo);
            Element msgElement = ObjectSerializer.toElement(message, new QName("http://gcube-system.org/namespaces/indexmanagement/DeltaListManagementProvider", "UpdateNotificationMessage"));
            
            if(deltaInfo.getDeltaAction().equals(DeltaActionType.Addition)){
                addDeltaTopic.notify(msgElement);
                logger.debug("Delta file addition notification sent by DeltaListManager. DeltaID =  " + deltaInfo.getDeltaFileID());
                logger.debug("Notification topic is: " + addDeltaTopic.getName());
            }
            else if(deltaInfo.getDeltaAction().equals(DeltaActionType.Deletion)){
                deleteDeltaTopic.notify(msgElement);   
                logger.debug("Delta file deletion notification sent by DeltaListManager. DeltaID =  " + deltaInfo.getDeltaFileID());
            }
            else{
                throw new Exception("Error: unknown action specified in DeltaFileInfo: " + deltaInfo.getDeltaAction().getValue());
            }
        }catch(Exception e){logger.error("Exception while trying to send delta file update notification", e);}
    }

    private void sendManagerCreationNotification(){
        try{
        	DeltaListManagerCreatedNotificationMessageType message = new DeltaListManagerCreatedNotificationMessageType(resource.getEPR());
        	Element msgElement = ObjectSerializer.toElement(message, new QName("http://gcube-system.org/namespaces/indexmanagement/DeltaListManagementProvider", "DeltaListManagerCreatedNotificationMessage"));        	
        	indexManagerCreatedTopic.notify(msgElement);
            logger.debug("Index manager creation notification sent by DeltaListManager. IndexID =  " + resource.getIndexID());            
        }catch(Exception e){logger.error("Exception while trying to send index manager creation notification", e);}
    }

    private void sendRemoveNotification(){
        try{            
            IndexRemovedNotificationMessageType message = new IndexRemovedNotificationMessageType();
            Element msgElement = ObjectSerializer.toElement(message, new QName("http://gcube-system.org/namespaces/indexmanagement/DeltaListManagementProvider", "IndexRemovedNotificationMessage"));
            indexRemovedTopic.notify(msgElement);   
            logger.debug("Index removal notification sent by DeltaListManager. IndexID =  " + resource.getIndexID());
        }catch(Exception e){logger.error("Exception while trying to send index removal notification", e);}
    }
    
    private void sendStatusNotification(String status){
        try{            
            StatusNotificationMessageType message =  new StatusNotificationMessageType(status);
            Element msgElement = ObjectSerializer.toElement(message, new QName("http://gcube-system.org/namespaces/indexmanagement/DeltaListManagementProvider", "StatusNotificationMessage"));
            indexStatusTopic.notify(msgElement);
            logger.debug("Index status notification sent by DeltaListManager. IndexID =  " + resource.getIndexID());
        }catch(Exception e){logger.error("Exception while trying to send index status notification", e);}
    }
    
    private void unregisterTopics() throws IndexException {

    }

    /**
     * Sets the scope of the current thread in the service context of the index resource to
     * the scope of the current thread as given by the DeltaListManagementHandler's ServiceContext.
     * This method is used when an operation of the StorageHandling layer is directly invoked, so
     * the index resource's service context does not define a scope for the current thread because
     * an operation of the index resource has not been invoked. However, everything is done based
     * on the scope of the index resource's ServiceContext, so it is required to copy this scope.
     */
	public void setIndexResourceScopeToDeltaListManagementScope() {
		sctx.setScope(ServiceContext.getContext().getScope());
	}

	
//    private String getIndexCollectionID() throws Exception {
//		final StringBuilder indexInternalCollectionID = new StringBuilder();
//		
//    	/*ColMSServiceHandler colmsHandler = new ColMSServiceHandler(sctx) {
//			@Override
//			protected void interact(EndpointReferenceType arg0) throws Exception {
//				try {
//					CoMSPortType1PortType colms = getColmsPortType(arg0);
//					ArrayOfMemberOID cols = colms.listCollectionIDsHavingName(IndexServiceConst.INDEX_COLLECTION_NAME);
//		    		if (cols==null || cols.getMemberOIDs()==null || cols.getMemberOIDs().length==0) {
//		        		CreateCollectionParameters newCollectionParams = new CreateCollectionParameters();
//		        		newCollectionParams.setCollectionName(IndexServiceConst.INDEX_COLLECTION_NAME);
//		        		newCollectionParams.setUserCollection(false);
//		        		newCollectionParams.setVirtual(false);
//		        		indexInternalCollectionID.append(colms.createCollection(newCollectionParams));
//		        		logger.info("MgmtHandler created Index Delta Internal collection:" + indexInternalCollectionID);
//		    		}
//		        	else {
//		        		indexInternalCollectionID.append(cols.getMemberOIDs()[0]);
//		        		logger.info("MgmtHandler found Index Delta Internal collection:" + indexInternalCollectionID);
//		        	}
//				} catch (GCUBEFault f) {
//					logger.error("Failed to retrieve/create the Index Internal collection", f);
//					throw f;
//				} catch(Exception e){
//	                logger.error("Failed to retrieve/create the Index Internal collection", e);
//	            }
//			}
//		};
//		colmsHandler.setHandled(resource);
//		colmsHandler.run();*/
//		
//		//List<Collection> cols = Collections.findByName(sctx.getScope(), IndexServiceConst.INDEX_COLLECTION_NAME);
//		List<GCUBEGenericResource> cols = findByName(sctx.getScope(), IndexServiceConst.INDEX_COLLECTION_NAME);
//		if(cols==null || cols.size()==0) {
//			//collection description
//			String collectionDescription = "The collection with the deltafiles related documents";
//			 
//			//propagate the request to others CM
//			//and when the CM state is cleaned, 
//			//a manager will be created automatically
//			boolean propagateRequest = true;
//			 
//			//the collection will be readable and writable
//			boolean readable = true;
//			boolean writable = true;
//			 
//			//create the collection
//			List<CollectionReference> collectionReferences = GCubeCollections.createGCubeCollection(propagateRequest, 
//					IndexServiceConst.INDEX_COLLECTION_NAME, collectionDescription, false, 
//					readable, writable, sctx.getScope(), sctx);
//			 
//			
//			
//			
//			if(collectionReferences.size() > 1)
//				logger.error("Created more than one collection with name: " + IndexServiceConst.INDEX_COLLECTION_NAME);
//			
//			indexInternalCollectionID.append(collectionReferences.get(0).getCollectionID());
//			logger.info("MgmtHandler created Index Delta Internal collection:" + indexInternalCollectionID);
//		}
//		else {
//			if(cols.size() > 1)
//				logger.warn("Found more than one collection with name: " + IndexServiceConst.INDEX_COLLECTION_NAME);
//			
//			indexInternalCollectionID.append(cols.get(0).getID());
//			logger.info("MgmtHandler found Index Delta Internal collection:" + indexInternalCollectionID);
//		}
//		String colID = indexInternalCollectionID.toString();
//		if (colID.length()==0)
//			throw new Exception("Failed to retrieve/create the Index Internal collection");
//		return colID;
//    }
    
    
    private void setIndexStatus(String indexStatus) {
    	resource.setIndexStatus(indexStatus);
        sendStatusNotification(indexStatus);
    }

    public boolean isUpdating() {
    	if (resource.getIndexStatus().equals(IndexManagementWSResource.MANAGER_STATUS_UPDATING))
    		return true;
    	return false;
    }
    
    public IndexWSResource getResource() {
    	return resource;
    }
    
    public String getDeltaFileCollectionID() { 
    	return deltaFileCollectionID;
    }
    
//    public static List<GCUBEGenericResource> findByName(GCUBEScope scope, String name) throws Exception
//	{
//		ISClient client = GHNContext.getImplementation(ISClient.class);
//		GCUBEGenericResourceQuery query = client.getQuery(GCUBEGenericResourceQuery.class);
//		query.addAtomicConditions(new AtomicCondition("/Profile/SecondaryType", "GCUBECollection"));
//		query.addAtomicConditions(new AtomicCondition("/Profile/Name", name));
//		
//		List<GCUBEGenericResource> resources = client.execute(query, scope);
//		return resources;
//	}

}