package org.gcube.indexmanagement.storagehandling;


import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.indexmanagement.common.IndexNotificationConsumer;
import org.gcube.indexmanagement.storagehandling.stubs.ConnectUpdaterResponse;
import org.gcube.indexmanagement.storagehandling.stubs.DeltaFileInfoType;
import org.globus.wsrf.core.notification.SubscriptionManager;

public interface DeltaListManagementWrapper {

	public void setIndexManagerEPR(EndpointReferenceType managerEPR) throws Exception;
	
	public EndpointReferenceType getIndexManagerEPR();
	
	public boolean isEmpty();
	
    public int connectLookup() throws Exception;
    
    public ConnectUpdaterResponse connectUpdater() throws Exception;
    
    public void disconnectUpdater(int updaterID) throws Exception;
    
    public void mergeDeltaFile(DeltaFileInfoType deltaInfo) throws Exception;
    
    public String getDeltaCollectionID() throws Exception;
    
    public DeltaFileInfoType getDeltaFileInfo(int idx) throws Exception;
    
    public DeltaFileInfoType[] getDeltaFileList() throws Exception;
    
    public SubscriptionManager subscribeForAdditions(IndexNotificationConsumer consumer) throws Exception;
    
    public SubscriptionManager subscribeForDeletions(IndexNotificationConsumer consumer) throws Exception;
    
    public SubscriptionManager subscribeForIndexRemoval(IndexNotificationConsumer consumer) throws Exception;
    
    public SubscriptionManager subscribeForManagerCreation(IndexNotificationConsumer consumer) throws Exception;
}
