/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.storagehandling;

import java.rmi.RemoteException;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.common.IndexException;
import org.gcube.indexmanagement.storagehandling.DeltaListManagementHandler;
import org.gcube.indexmanagement.storagehandling.DeltaListManager;
import org.gcube.indexmanagement.storagehandling.ServiceContext;
import org.gcube.indexmanagement.storagehandling.stubs.ConnectLookup;
import org.gcube.indexmanagement.storagehandling.stubs.ConnectUpdater;
import org.gcube.indexmanagement.storagehandling.stubs.ConnectUpdaterResponse;
import org.gcube.indexmanagement.storagehandling.stubs.DeltaFileInfoType;
import org.gcube.indexmanagement.storagehandling.stubs.DisconnectUpdaterResponse;
import org.gcube.indexmanagement.storagehandling.stubs.GetDeltaCollectionID;
import org.gcube.indexmanagement.storagehandling.stubs.GetDeltaFileList;
import org.gcube.indexmanagement.storagehandling.stubs.GetDeltaFileListResponse;
import org.gcube.indexmanagement.storagehandling.stubs.IsUpdating;
import org.gcube.indexmanagement.storagehandling.stubs.MergeResponse;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.Topic;
import org.globus.wsrf.TopicList;
import org.globus.wsrf.TopicListAccessor;
import org.globus.wsrf.impl.notification.GetCurrentMessageProvider;
import org.oasis.wsn.GetCurrentMessage;
import org.oasis.wsn.GetCurrentMessageResponse;
import org.oasis.wsn.InvalidTopicExpressionFaultType;
import org.oasis.wsn.NoCurrentMessageOnTopicFaultType;
import org.oasis.wsn.ResourceUnknownFaultType;
import org.oasis.wsn.TopicNotSupportedFaultType;

public class DeltaListManagementProvider
extends GCUBEPortType {
    static GCUBELog logger = new GCUBELog(DeltaListManagementProvider.class);
    private GetCurrentMessageProvider gcmProvider = new GetCurrentMessageProvider();

    public GetDeltaFileListResponse getDeltaFileList(GetDeltaFileList request) throws GCUBEUnrecoverableFault {
        try {
            DeltaListManagementHandler handler = this.getHandler();
            handler.setIndexResourceScopeToDeltaListManagementScope();
            GetDeltaFileListResponse response = new GetDeltaFileListResponse();
            response.setDeltaFiles(handler.getDeltaFileList());
            return response;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get delta file list.", (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{e.getMessage()});
        }
    }

    public DeltaFileInfoType getDeltaFileInfo(int deltaFileIdx) throws GCUBEUnrecoverableFault {
        try {
            DeltaListManagementHandler handler = this.getHandler();
            handler.setIndexResourceScopeToDeltaListManagementScope();
            return handler.getDeltaFileInfo(deltaFileIdx);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get delta file info.", (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{e.getMessage()});
        }
    }

    public String getDeltaCollectionID(GetDeltaCollectionID empty) throws GCUBEUnrecoverableFault {
        try {
            DeltaListManagementHandler handler = this.getHandler();
            handler.setIndexResourceScopeToDeltaListManagementScope();
            return handler.getDeltaFileCollectionID();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get delta file info.", (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{e.getMessage()});
        }
    }

    public MergeResponse mergeDeltaFile(DeltaFileInfoType deltaFileInfo) throws GCUBEUnrecoverableFault {
        try {
            DeltaListManagementHandler handler = this.getHandler();
            handler.setIndexResourceScopeToDeltaListManagementScope();
            if (!this.getManagerResource().isDeltaValid(deltaFileInfo)) {
                throw new IndexException("The delta file is not valid");
            }
            handler.mergeDeltaFile(deltaFileInfo, true);
            logger.info((Object)("Added deltaFile [" + deltaFileInfo.getDeltaFileID() + "] containing " + deltaFileInfo.getDocumentCount() + " documents to the delta file list."));
        }
        catch (Exception e) {
            logger.error((Object)("Unable to merge deltaFile: " + deltaFileInfo.getDeltaFileID()), (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{e.getMessage()});
        }
        return new MergeResponse();
    }

    public int connectLookup(ConnectLookup empty) throws GCUBEUnrecoverableFault {
        try {
            DeltaListManagementHandler handler = this.getHandler();
            handler.setIndexResourceScopeToDeltaListManagementScope();
            return handler.connectLookup();
        }
        catch (Exception ie) {
            logger.error((Object)"Unable to connect lookup to DeltaListManagementProvider.", (Throwable)ie);
            throw new GCUBEUnrecoverableFault(new String[]{ie.getMessage()});
        }
    }

    public ConnectUpdaterResponse connectUpdater(ConnectUpdater empty) throws GCUBEUnrecoverableFault {
        try {
            DeltaListManagementHandler handler = this.getHandler();
            handler.setIndexResourceScopeToDeltaListManagementScope();
            ConnectUpdaterResponse response = new ConnectUpdaterResponse();
            response.setConnectionID(handler.connectUpdater());
            response.setDeltaFileCollectionID(handler.getDeltaFileCollectionID());
            return response;
        }
        catch (Exception ie) {
            logger.error((Object)"Unable to connect updater to DeltaListManagementProvider.", (Throwable)ie);
            throw new GCUBEUnrecoverableFault(new String[]{ie.getMessage()});
        }
    }

    public DisconnectUpdaterResponse disconnectUpdater(int updaterID) throws GCUBEUnrecoverableFault {
        try {
            DeltaListManagementHandler handler = this.getHandler();
            handler.setIndexResourceScopeToDeltaListManagementScope();
            handler.disconnectUpdater(updaterID);
            return new DisconnectUpdaterResponse();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to disconnect updater from DeltaListManagementProvider.", (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{e.getMessage()});
        }
    }

    public boolean isUpdating(IsUpdating empty) throws GCUBEUnrecoverableFault {
        try {
            return this.getHandler().isUpdating();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get the manager resource.", (Throwable)e);
            throw new GCUBEUnrecoverableFault(e, new String[0]);
        }
    }

    private DeltaListManagementHandler getHandler() throws Exception {
        return this.getManagerResource().getIndexManagerHandler();
    }

    private DeltaListManager getManagerResource() throws Exception {
        Resource resource = ResourceContext.getResourceContext().getResource();
        return (DeltaListManager)resource;
    }

    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public GetCurrentMessageResponse getCurrentMessage(GetCurrentMessage request) throws RemoteException, ResourceUnknownFaultType, InvalidTopicExpressionFaultType, TopicNotSupportedFaultType, NoCurrentMessageOnTopicFaultType {
        logger.info((Object)"'getCurrentMessage' called on DeltaListManagementProvider");
        logger.info((Object)("Requested resourceKey: " + ResourceContext.getResourceContext().getResourceKey()));
        Topic topic = null;
        try {
            Resource resource = ResourceContext.getResourceContext().getResource();
            TopicList topicList = ((TopicListAccessor)resource).getTopicList();
            topic = (Topic)topicList.getTopics(request.getTopic()).toArray()[0];
        }
        catch (Exception e) {
            logger.error((Object)"Failed to retrieve current message.", (Throwable)e);
            throw new RemoteException("Failed to retrieve current message.", e);
        }
        String topicName = topic.getName().getLocalPart();
        logger.info((Object)("Current message requested for Topic: " + topic.getName()));
        if (topicName.equals("AddDelta") || topicName.equals("DeleteDelta")) {
            logger.info((Object)"Throwing a NoCurrentMessageOnTopicFaultType.");
            throw new NoCurrentMessageOnTopicFaultType();
        }
        logger.info((Object)"Dispatching request to the default getCurrentMessage provider.");
        return this.gcmProvider.getCurrentMessage(request);
    }
}

