/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.storagehandling;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.namespace.QName;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.resource.StorageObject;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.indexmanagement.common.IndexException;
import org.gcube.indexmanagement.common.IndexManagementWSResource;
import org.gcube.indexmanagement.common.IndexWSResource;
import org.gcube.indexmanagement.storagehandling.ServiceContext;
import org.gcube.indexmanagement.storagehandling.stubs.DeltaActionType;
import org.gcube.indexmanagement.storagehandling.stubs.DeltaFileInfoType;
import org.gcube.indexmanagement.storagehandling.stubs.DeltaListManagerCreatedNotificationMessageType;
import org.gcube.indexmanagement.storagehandling.stubs.IndexRemovedNotificationMessageType;
import org.gcube.indexmanagement.storagehandling.stubs.StatusNotificationMessageType;
import org.gcube.indexmanagement.storagehandling.stubs.UpdateNotificationMessageType;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.impl.SimpleTopic;
import org.w3c.dom.Element;

public class DeltaListManagementHandler {
    private static final String RP_DELTA_FILE_LIST = "DeltaFileList";
    static final String TOPIC_ADD_DELTA = "AddDelta";
    static final String TOPIC_DELETE_DELTA = "DeleteDelta";
    static final String TOPIC_INDEX_REMOVED = "IndexRemoved";
    static final String TOPIC_INDEX_STATUS = "IndexStatus";
    static final String TOPIC_INDEX_MANAGER_CREATED = "IndexManagerCreated";
    private static final String NS = "http://gcube-system.org/namespaces/indexmanagement/DeltaListManagementProvider";
    static GCUBELog logger = new GCUBELog(DeltaListManagementHandler.class);
    private SimpleTopic addDeltaTopic;
    private SimpleTopic deleteDeltaTopic;
    private SimpleTopic indexRemovedTopic;
    private SimpleTopic indexStatusTopic;
    private SimpleTopic indexManagerCreatedTopic;
    private ArrayList<DeltaFileInfoType> deltaFileListBuffer = new ArrayList();
    private String stateObjectName = null;
    private String stateObjectID = null;
    private GCUBEServiceContext sctx;
    private IndexManagementWSResource resource;
    private String deltaFileCollectionID;
    private volatile boolean isAlive = true;

    public DeltaListManagementHandler() {
    }

    public DeltaListManagementHandler(IndexManagementWSResource resource, String stateFilename) throws IndexException {
        try {
            this.resource = resource;
            this.sctx = resource.getServiceContext();
            String indexNS = "http://gcube-system.org/namespaces/indexmanagement/DeltaListManagementProvider/" + resource.getIndexID();
            this.deltaFileCollectionID = "Index Delta Internal";
            ResourceProperty prop = resource.createProperty(RP_DELTA_FILE_LIST, NS);
            prop.add((Object)new DeltaFileInfoType[0]);
            this.addDeltaTopic = resource.createTopic(TOPIC_ADD_DELTA, indexNS);
            this.deleteDeltaTopic = resource.createTopic(TOPIC_DELETE_DELTA, indexNS);
            this.indexRemovedTopic = resource.createTopic(TOPIC_INDEX_REMOVED, indexNS);
            this.indexStatusTopic = resource.createTopic(TOPIC_INDEX_STATUS, indexNS);
            this.indexManagerCreatedTopic = resource.createTopic(TOPIC_INDEX_MANAGER_CREATED, indexNS);
            this.stateObjectName = stateFilename;
            this.RestoreCMSStateAndWaitForRegistrationCompletion();
        }
        catch (Exception e) {
            logger.error((Object)("Unable to create DeltaListManagementHandler [ IndexID: " + resource.getIndexID() + ", Key: " + resource.getID() + " ]"), (Throwable)e);
            throw new IndexException((Throwable)e);
        }
    }

    private void RestoreCMSStateAndWaitForRegistrationCompletion() {
        Thread restoreAndWaitThr = new Thread(){

            @Override
            public void run() {
                try {
                    DeltaListManagementHandler.this.restoreIndexStateFromCMS();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to restore index state from the CMS.", (Throwable)e);
                }
                while (true) {
                    try {
                        Thread.sleep(40000L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        if (!DeltaListManagementHandler.this.resource.isTopicRegistered(DeltaListManagementHandler.this.indexManagerCreatedTopic)) continue;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
                DeltaListManagementHandler.this.sendManagerCreationNotification();
            }
        };
        try {
            logger.debug((Object)"Starting new thread for restoring a state from CMS and checking notification topics registration completion...");
            this.sctx.setScope(restoreAndWaitThr, this.sctx.getScope());
            this.sctx.useCallerCredentials(new Thread[]{restoreAndWaitThr});
            restoreAndWaitThr.start();
            logger.debug((Object)"'Restore CMS state'-'Registration completion check' thread started.");
        }
        catch (Exception e) {
            logger.error((Object)"Failed to start 'Restore CMS state'-'Registration completion check' thread.", (Throwable)e);
        }
    }

    private void waitForManagerCreationTopicRegistrationCompletion() {
        Thread registrationCompletionThr = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(40000L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        if (!DeltaListManagementHandler.this.resource.isTopicRegistered(DeltaListManagementHandler.this.indexManagerCreatedTopic)) continue;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
                DeltaListManagementHandler.this.sendManagerCreationNotification();
            }
        };
        try {
            logger.debug((Object)"Starting new thread for notification topics registration completion check...");
            this.sctx.setScope(registrationCompletionThr, this.sctx.getScope());
            this.sctx.useCallerCredentials(new Thread[]{registrationCompletionThr});
            registrationCompletionThr.start();
            logger.debug((Object)"Registration completion check thread started.");
        }
        catch (Exception e) {
            logger.error((Object)"Failed to start registration completion checker thread.", (Throwable)e);
        }
    }

    public void storeState(ObjectOutputStream oos) {
        try {
            oos.writeObject(this.deltaFileCollectionID);
            oos.writeInt(this.deltaFileListBuffer.size());
            for (DeltaFileInfoType delta : this.deltaFileListBuffer) {
                oos.writeObject(delta);
            }
            oos.writeObject(this.stateObjectName);
            if (this.stateObjectID == null) {
                oos.writeBoolean(false);
            } else {
                oos.writeBoolean(true);
                oos.writeObject(this.stateObjectID);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to store DeltaListManagementHandler state.", (Throwable)e);
        }
    }

    public void loadState(ObjectInputStream ois, boolean firstLoad, IndexManagementWSResource resource) throws Exception {
        ResourceProperty deltaList = null;
        try {
            this.resource = resource;
            this.sctx = resource.getServiceContext();
            String indexNS = "http://gcube-system.org/namespaces/indexmanagement/DeltaListManagementProvider/" + resource.getIndexID();
            this.deltaFileCollectionID = (String)ois.readObject();
            deltaList = resource.createProperty(RP_DELTA_FILE_LIST, NS);
            this.addDeltaTopic = resource.createTopic(TOPIC_ADD_DELTA, indexNS);
            this.deleteDeltaTopic = resource.createTopic(TOPIC_DELETE_DELTA, indexNS);
            this.indexRemovedTopic = resource.createTopic(TOPIC_INDEX_REMOVED, indexNS);
            this.indexStatusTopic = resource.createTopic(TOPIC_INDEX_STATUS, indexNS);
            this.indexManagerCreatedTopic = resource.createTopic(TOPIC_INDEX_MANAGER_CREATED, indexNS);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to create DeltaListManagementHandler [ IndexID: " + resource.getIndexID() + ", Key: " + resource.getID() + " ]"), (Throwable)e);
            throw new IndexException((Throwable)e);
        }
        try {
            int numDeltaFiles = ois.readInt();
            for (int i = 0; i < numDeltaFiles; ++i) {
                DeltaFileInfoType delta = (DeltaFileInfoType)ois.readObject();
                this.deltaFileListBuffer.add(delta);
            }
            deltaList.add((Object)this.deltaFileListBuffer.toArray(new DeltaFileInfoType[this.deltaFileListBuffer.size()]));
        }
        catch (Exception e) {
            logger.error((Object)"Failed to load DeltaListManagementHandler state.");
            throw new IndexException("Failed to load DeltaListManagementHandler state.", (Throwable)e);
        }
        this.stateObjectName = (String)ois.readObject();
        boolean bReadStateOID = ois.readBoolean();
        if (bReadStateOID) {
            this.stateObjectID = (String)ois.readObject();
        }
        if (firstLoad) {
            this.waitForManagerCreationTopicRegistrationCompletion();
        }
    }

    private void restoreIndexStateFromCMS() throws Exception {
        IClient client;
        logger.trace((Object)("calling CMS with params Name: " + this.stateObjectName + ", colID: " + this.deltaFileCollectionID));
        if (this.deltaFileCollectionID == null) {
            logger.error((Object)"There is no delta collection ID during delta file download from CMS ");
            throw new Exception("No delta collection ID during delta file download from CMS ");
        }
        int i = 0;
        String documentID = null;
        try {
            ScopeProvider.instance.set(this.sctx.getScope().toString());
            client = new StorageClient("Index", "StorageHandler", "delta", AccessType.SHARED).getClient();
            logger.info((Object)("LISTING : " + this.deltaFileCollectionID));
            List storageObjects = client.showDir().RDir(this.deltaFileCollectionID);
            for (StorageObject so : storageObjects) {
                documentID = so.getName();
                logger.debug((Object)("Found document with ID: " + documentID));
                ++i;
                logger.info((Object)("-> " + documentID));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error when calling CMS with params Name: " + this.stateObjectName + ", colID: " + this.deltaFileCollectionID), (Throwable)e);
            throw new Exception("Error when calling CMS with params Name: " + this.stateObjectName + ", colID: " + this.deltaFileCollectionID, e);
        }
        logger.trace((Object)("found " + i + " documents"));
        if (i > 1) {
            logger.warn((Object)"Found more than 1 document for CMS stored state");
        }
        if (documentID == null) {
            logger.debug((Object)"A saved state for this index was not found.");
            return;
        }
        this.stateObjectID = documentID;
        logger.debug((Object)("Found a saved state for this index (id=" + this.stateObjectID + "). Attempting to load it..."));
        try {
            ScopeProvider.instance.set(this.sctx.getScope().toString());
            client = new StorageClient("Index", "StorageHandler", "delta", AccessType.SHARED).getClient();
            String remoteFile = this.deltaFileCollectionID + "/" + this.stateObjectID;
            logger.info((Object)("GET as stream : remote : " + remoteFile));
            InputStream is = client.get().RFileAsInputStream(remoteFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String ID = null;
            String action = null;
            String indexTypeID = null;
            String docCount = null;
            while ((ID = br.readLine()) != null) {
                action = br.readLine();
                indexTypeID = br.readLine();
                docCount = br.readLine();
                DeltaFileInfoType df = new DeltaFileInfoType();
                df.setDeltaAction(DeltaActionType.fromString((String)action));
                df.setDeltaFileID(ID);
                df.setDocumentCount(Integer.parseInt(docCount));
                df.setIndexTypeID(indexTypeID);
                logger.debug((Object)("Found deltafile with ID: " + ID));
                this.mergeDeltaFile(df, false);
            }
            br.close();
            logger.debug((Object)"Loading of the saved index state finished.");
        }
        catch (Exception e) {
            logger.error((Object)"Failed to retrieve the saved index state from the CMS.", (Throwable)e);
            throw e;
        }
    }

    private void saveIndexStateToCMS() throws IndexException {
        logger.debug((Object)"Saving the index state on the CMS...");
        try {
            ByteArrayInputStream is;
            StringBuilder sb = new StringBuilder();
            for (DeltaFileInfoType deltaInfo : this.deltaFileListBuffer) {
                logger.debug((Object)("DeltaFileID: " + deltaInfo.getDeltaFileID()));
                sb.append(deltaInfo.getDeltaFileID() + "\n");
                sb.append(deltaInfo.getDeltaAction() + "\n");
                sb.append(deltaInfo.getIndexTypeID() + "\n");
                sb.append(deltaInfo.getDocumentCount() + "\n");
            }
            byte[] persistenceInfoBytes = sb.toString().getBytes("utf-8");
            if (this.deltaFileCollectionID == null) {
                logger.error((Object)"There is no delta collection ID during delta file upload to CMS ");
                throw new Exception("No delta collection ID during delta file upload to CMS ");
            }
            if (this.stateObjectID == null) {
                String ret;
                ScopeProvider.instance.set(this.sctx.getScope().toString());
                is = new ByteArrayInputStream(persistenceInfoBytes);
                IClient client = new StorageClient("Index", "StorageHandler", "delta", AccessType.SHARED).getClient();
                String remoteFile = this.deltaFileCollectionID + "/" + this.stateObjectName;
                logger.info((Object)("PUT as stream : remoteFile : " + remoteFile));
                this.stateObjectID = ret = client.put(true).LFile((InputStream)is).RFile(remoteFile);
            } else {
                is = new ByteArrayInputStream(persistenceInfoBytes);
                ScopeProvider.instance.set(this.sctx.getScope().toString());
                IClient client = new StorageClient("Index", "StorageHandler", "delta", AccessType.SHARED).getClient();
                String remoteFile = this.deltaFileCollectionID + "/" + this.stateObjectName;
                logger.info((Object)("PUT as stream : remoteFile : " + remoteFile));
                client.put(true).LFile((InputStream)is).RFile(this.deltaFileCollectionID + "/" + this.stateObjectName);
            }
            logger.debug((Object)("Index state saved, OID = " + this.stateObjectID));
        }
        catch (Exception e) {
            throw new IndexException("Failed to save index state on the CMS.", (Throwable)e);
        }
    }

    private void deleteIndexStateFromCMS() throws IndexException {
        block8: {
            try {
                if (this.stateObjectID == null) break block8;
                if (this.deltaFileCollectionID == null) {
                    logger.error((Object)"There is no delta collection ID during delta file deletion from CMS ");
                    throw new Exception("No delta collection ID during delta file deletion from CMS ");
                }
                ScopeProvider.instance.set(this.sctx.getScope().toString());
                IClient client = new StorageClient("Index", "StorageHandler", "delta", AccessType.SHARED).getClient();
                try {
                    String id = this.deltaFileCollectionID + "/" + this.stateObjectID;
                    logger.info((Object)("REMOVE by ID  : " + id));
                    client.remove().RFileById(id);
                    logger.debug((Object)("Deleted index state from CMS, OID = " + this.stateObjectID));
                }
                catch (Exception e) {
                    logger.error((Object)("Error while removing index state object from CMS, OID = " + this.stateObjectID), (Throwable)e);
                    throw new Exception("Error while removing index state object from CMS, OID = " + this.stateObjectID, e);
                }
                try {
                    for (DeltaFileInfoType deltaFileInfo : this.deltaFileListBuffer) {
                        String id = deltaFileInfo.getDeltaFileID();
                        logger.info((Object)("REMOVE by ID  : " + id));
                        client.remove().RFileById(id);
                        logger.debug((Object)("Deleted delta file: " + deltaFileInfo.getDeltaFileID()));
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Error while removing delta files from the CMS.", (Throwable)e);
                    throw new Exception("Error while removing delta files from the CMS.");
                }
            }
            catch (Exception e) {
                throw new IndexException("Failed to delete saved index state on the CMS.", (Throwable)e);
            }
        }
    }

    public synchronized int connectLookup() throws IndexException {
        if (this.isAlive) {
            int connID = this.resource.getConnectionCount();
            this.resource.setConnectionCount(connID + 1);
            return connID;
        }
        throw new IndexException("IndexManagement has been removed. Unable to connect.");
    }

    public synchronized int connectUpdater() throws IndexException {
        if (this.isAlive) {
            int connID = this.resource.getConnectionCount();
            logger.debug((Object)("Adding to updater list: " + connID));
            this.resource.addUpdater(connID);
            this.resource.setConnectionCount(connID + 1);
            if (!this.resource.getIndexStatus().equals("UPDATING")) {
                this.setIndexStatus("UPDATING");
            }
            return connID;
        }
        throw new IndexException("IndexManagement has been removed. Unable to connect.");
    }

    public void disconnectUpdater(int connectionID) {
        try {
            this.resource.deleteUpdater(connectionID);
            if (this.resource.getUpdaterCount() == 0) {
                this.setIndexStatus("FINISHED");
            }
            this.saveIndexStateToCMS();
            logger.info((Object)("Updater " + connectionID + " has been disconnected, storing resource..."));
            this.resource.store();
        }
        catch (Exception e) {
            logger.error((Object)("Failed to disconnect updater: " + connectionID), (Throwable)e);
        }
    }

    protected void mergeDeltaFile(DeltaFileInfoType deltaInfo, boolean bSendUpdateNotification) throws Exception {
        int deltaIdx = this.deltaFileListBuffer.size();
        this.addDeltaFile(deltaInfo);
        if (deltaInfo.getDeltaAction().equals((Object)DeltaActionType.Addition)) {
            this.resource.setDocumentCount(this.resource.getDocumentCount() + deltaInfo.getDocumentCount());
        } else if (deltaInfo.getDeltaAction().equals((Object)DeltaActionType.Deletion)) {
            this.resource.setDocumentCount(this.resource.getDocumentCount() - deltaInfo.getDocumentCount());
        }
        this.resource.setModified(Calendar.getInstance());
        if (bSendUpdateNotification) {
            this.sendUpdateNotification(deltaInfo, deltaIdx);
        }
    }

    public DeltaFileInfoType getDeltaFileInfo(int idx) {
        String str = new String();
        for (DeltaFileInfoType d : this.deltaFileListBuffer) {
            str = str + d.getDeltaFileID();
        }
        logger.info((Object)("DeltasInfoTypes : " + str));
        return this.deltaFileListBuffer.get(idx);
    }

    public DeltaFileInfoType[] getDeltaFileList() {
        return (DeltaFileInfoType[])this.resource.getResourcePropertySet().get(new QName(NS, RP_DELTA_FILE_LIST)).get(0);
    }

    public synchronized void close() {
        this.isAlive = false;
        if (this.resource.getDestructionMode() == IndexWSResource.DestructionMode.FULL_DESTRUCTION) {
            this.sendRemoveNotification();
        }
        try {
            this.unregisterTopics();
        }
        catch (IndexException e) {
            logger.error((Object)"Unable to unregister topics: ", (Throwable)e);
        }
        if (this.resource.getDestructionMode() == IndexWSResource.DestructionMode.FULL_DESTRUCTION) {
            try {
                this.deleteIndexStateFromCMS();
            }
            catch (IndexException e) {
                logger.error((Object)"Failed to delete index state from the CMS.", (Throwable)e);
            }
        }
    }

    private void addDeltaFile(DeltaFileInfoType deltaFileInfo) {
        this.deltaFileListBuffer.add(deltaFileInfo);
        logger.info((Object)("Adding info for : " + deltaFileInfo.getDeltaFileID()));
        this.resource.getResourcePropertySet().get(new QName(NS, RP_DELTA_FILE_LIST)).set(0, (Object)this.deltaFileListBuffer.toArray(new DeltaFileInfoType[this.deltaFileListBuffer.size()]));
    }

    private void sendUpdateNotification(DeltaFileInfoType deltaInfo, int deltaIdx) {
        block4: {
            try {
                UpdateNotificationMessageType message = new UpdateNotificationMessageType(deltaIdx, deltaInfo);
                Element msgElement = ObjectSerializer.toElement((Object)message, (QName)new QName(NS, "UpdateNotificationMessage"));
                if (deltaInfo.getDeltaAction().equals((Object)DeltaActionType.Addition)) {
                    this.addDeltaTopic.notify((Object)msgElement);
                    logger.debug((Object)("Delta file addition notification sent by DeltaListManager. DeltaID =  " + deltaInfo.getDeltaFileID()));
                    logger.debug((Object)("Notification topic is: " + this.addDeltaTopic.getName()));
                    break block4;
                }
                if (deltaInfo.getDeltaAction().equals((Object)DeltaActionType.Deletion)) {
                    this.deleteDeltaTopic.notify((Object)msgElement);
                    logger.debug((Object)("Delta file deletion notification sent by DeltaListManager. DeltaID =  " + deltaInfo.getDeltaFileID()));
                    break block4;
                }
                throw new Exception("Error: unknown action specified in DeltaFileInfo: " + deltaInfo.getDeltaAction().getValue());
            }
            catch (Exception e) {
                logger.error((Object)"Exception while trying to send delta file update notification", (Throwable)e);
            }
        }
    }

    private void sendManagerCreationNotification() {
        try {
            DeltaListManagerCreatedNotificationMessageType message = new DeltaListManagerCreatedNotificationMessageType(this.resource.getEPR());
            Element msgElement = ObjectSerializer.toElement((Object)message, (QName)new QName(NS, "DeltaListManagerCreatedNotificationMessage"));
            this.indexManagerCreatedTopic.notify((Object)msgElement);
            logger.debug((Object)("Index manager creation notification sent by DeltaListManager. IndexID =  " + this.resource.getIndexID()));
        }
        catch (Exception e) {
            logger.error((Object)"Exception while trying to send index manager creation notification", (Throwable)e);
        }
    }

    private void sendRemoveNotification() {
        try {
            IndexRemovedNotificationMessageType message = new IndexRemovedNotificationMessageType();
            Element msgElement = ObjectSerializer.toElement((Object)message, (QName)new QName(NS, "IndexRemovedNotificationMessage"));
            this.indexRemovedTopic.notify((Object)msgElement);
            logger.debug((Object)("Index removal notification sent by DeltaListManager. IndexID =  " + this.resource.getIndexID()));
        }
        catch (Exception e) {
            logger.error((Object)"Exception while trying to send index removal notification", (Throwable)e);
        }
    }

    private void sendStatusNotification(String status) {
        try {
            StatusNotificationMessageType message = new StatusNotificationMessageType(status);
            Element msgElement = ObjectSerializer.toElement((Object)message, (QName)new QName(NS, "StatusNotificationMessage"));
            this.indexStatusTopic.notify((Object)msgElement);
            logger.debug((Object)("Index status notification sent by DeltaListManager. IndexID =  " + this.resource.getIndexID()));
        }
        catch (Exception e) {
            logger.error((Object)"Exception while trying to send index status notification", (Throwable)e);
        }
    }

    private void unregisterTopics() throws IndexException {
    }

    public void setIndexResourceScopeToDeltaListManagementScope() {
        this.sctx.setScope(ServiceContext.getContext().getScope());
    }

    private void setIndexStatus(String indexStatus) {
        this.resource.setIndexStatus(indexStatus);
        this.sendStatusNotification(indexStatus);
    }

    public boolean isUpdating() {
        return this.resource.getIndexStatus().equals("UPDATING");
    }

    public IndexWSResource getResource() {
        return this.resource;
    }

    public String getDeltaFileCollectionID() {
        return this.deltaFileCollectionID;
    }
}

