/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.textextractor.extractors;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.gcube.semantic.annotator.AnnotationBase;
import org.gcube.semantic.annotator.utils.ANNOTATIONS;
import org.gcube.textextractor.entities.ExtractedEntity;
import org.gcube.textextractor.entities.ShortenCE4NameResponse;
import org.gcube.textextractor.extractors.InformationExtractor;
import org.gcube.textextractor.helpers.ExtractorHelper;
import org.gcube.textextractor.helpers.XPathHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLExtractor
extends InformationExtractor {
    private static final Logger logger = LoggerFactory.getLogger(XMLExtractor.class);

    /*
     * Exception decompiling
     */
    @Override
    public Map<String, String> extractFieldsFromFile(String filename) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<Map<String, String>> extractInfo(String path) throws FileNotFoundException {
        ArrayList<Map<String, String>> extractedInfo = new ArrayList<Map<String, String>>();
        int cnt = 0;
        List<String> filenames = ExtractorHelper.getFilenames(path);
        for (String filename : filenames) {
            logger.info("Processing file : " + ++cnt + " " + filename);
            try {
                Map<String, String> info = this.extractFieldsFromFile(filename);
                long part_start_time = System.currentTimeMillis();
                Map<String, String> enriched = this.enrichRecord(info, filename);
                long part_end_time = System.currentTimeMillis();
                logger.info("~> field enrichment time  : " + (double)(part_end_time - part_start_time) / 1000.0 + " secs");
                extractedInfo.add(enriched);
            }
            catch (Exception e) {
                logger.error("error while extracting info from : " + filename + " . will skip this file", (Throwable)e);
            }
        }
        return extractedInfo;
    }

    @Override
    public Map<String, String> enrichRecord(Map<String, String> record, String filename) {
        HashMap<String, String> enrichedRecord = new HashMap<String, String>();
        HashMap<String, List<String>> uris = new HashMap<String, List<String>>();
        String docName = null;
        String[] filenameParts = filename.split("_");
        docName = filenameParts != null && filenameParts.length > 1 ? filenameParts[filenameParts.length - 2] : filename;
        String docURI = "http://smartfish.collection/firms/" + docName.toLowerCase();
        enrichedRecord.putAll(record);
        enrichedRecord.put("documentID", docURI);
        ExtractorHelper.enrichListField(record, enrichedRecord, uris, ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#country"), new ExtractorHelper.QueryWrapperList(){

            @Override
            public String doCall(List<ExtractedEntity> arg) throws Exception {
                return ExtractorHelper.queryCountry(arg);
            }
        });
        ExtractorHelper.enrichSimpleField(record, enrichedRecord, uris, ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#year"), new ExtractorHelper.QueryWrapperSimple(){

            @Override
            public String doCall(ExtractedEntity arg) throws Exception {
                return ExtractorHelper.queryYear(arg);
            }
        });
        ExtractorHelper.enrichListField(record, enrichedRecord, uris, ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#status"), new ExtractorHelper.QueryWrapperList(){

            @Override
            public String doCall(List<ExtractedEntity> arg) throws Exception {
                return ExtractorHelper.queryExploitationStatus(arg);
            }
        });
        try {
            String speciesURIJson = null;
            if (record.get("species_english_name") != null && record.get("species_english_name").trim().length() > 0) {
                List<String> asList = Arrays.asList(record.get("species_english_name").split("\\s*,\\s*"));
                ArrayList<ExtractedEntity> eList = new ArrayList<ExtractedEntity>();
                for (String name : asList) {
                    eList.add(new ExtractedEntity(name, ""));
                }
                speciesURIJson = ExtractorHelper.querySpecies(eList);
                uris.put("species_uris", ShortenCE4NameResponse.getURIFromJSON(speciesURIJson));
                enrichedRecord.put("species_uris", speciesURIJson);
            }
        }
        catch (Exception e) {
            logger.warn("Error processing species : " + record.get("species_english_name"), (Throwable)e);
        }
        ExtractorHelper.enrichListField(record, enrichedRecord, uris, ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#management"), new ExtractorHelper.QueryWrapperList(){

            @Override
            public String doCall(List<ExtractedEntity> arg) throws Exception {
                return ExtractorHelper.queryManagement(arg);
            }
        });
        try {
            String mng = record.get("management");
            if (mng != null) {
                if (mng.equalsIgnoreCase("true")) {
                    mng = "Management Unit";
                }
                String managementURIJson = ExtractorHelper.queryManagement(new ExtractedEntity(mng, ""));
                uris.put("management_uris", ShortenCE4NameResponse.getURIFromJSON(managementURIJson));
                enrichedRecord.put("management_uris", managementURIJson);
            }
        }
        catch (Exception e) {
            logger.warn("Error processing management : " + record.get("management"), (Throwable)e);
        }
        try {
            this.annotate(docURI, uris);
        }
        catch (FileNotFoundException ex) {
            logger.error("file : " + filename + " not found", (Throwable)ex);
        }
        return enrichedRecord;
    }

    private Map<String, String> customFields(String filename) throws SAXException, IOException, ParserConfigurationException, XPathExpressionException {
        HashMap<String, String> fields = new HashMap<String, String>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new File(filename));
        doc.getDocumentElement().normalize();
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        xpath.setNamespaceContext(new FigisNamespaceContext(null));
        String xpathStr = null;
        xpathStr = "/fi:FIGISDoc/fi:AqRes/fi:AqResIdent/dc:Title/text()";
        fields.put("title", XPathHelper.getValueXPath(xpath, doc, xpathStr));
        xpathStr = "/fi:FIGISDoc/fi:AqRes/fi:WaterAreaOverview/fi:WaterAreaRef/dc:Title[@xml:lang='en']/text()";
        fields.put(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#country"), XPathHelper.getMultiValuesXPath(xpath, doc, xpathStr));
        xpathStr = "/fi:FIGISDoc/fi:AqRes/fi:AqResIdent/fi:SpeciesList/fi:SpeciesRef/dc:Title[@xml:lang=\"en\"]/text()";
        fields.put("species_english_name", XPathHelper.getMultiValuesXPath(xpath, doc, xpathStr));
        xpathStr = "/fi:FIGISDoc/fi:AqRes/fi:AqResIdent/fi:SpeciesList/fi:SpeciesRef/fi:ForeignID[@CodeSystem='scientific_name']";
        fields.put("species_scientific_name", XPathHelper.getMultiValuesXPath(xpath, doc, xpathStr, "Code"));
        xpathStr = "/fi:FIGISDoc/fi:AqRes/fi:Management[@ManagementUnit='true']";
        if (XPathHelper.checkNodeExists(xpath, doc, xpathStr).booleanValue()) {
            fields.put(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#management"), "true");
        }
        if (XPathHelper.checkNodeExists(xpath, doc, xpathStr = "/fi:FIGISDoc/fi:AqRes/fi:AqResIdent[@Factsheet='true']/fi:ReportingYear/text()").booleanValue()) {
            fields.put(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#year"), XPathHelper.getStringAttribute(xpath, doc, xpathStr));
        }
        xpathStr = "/fi:FIGISDoc/fi:AqRes/fi:AqResStateTrend/fi:ExploitState/@Value";
        fields.put(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#status"), XPathHelper.getStringAttribute(xpath, doc, xpathStr));
        logger.info("extracted fields : " + fields);
        return fields;
    }

    @Override
    public String convertInfoToRowset(Map<String, String> info) {
        return ExtractorHelper.createRowseFromFields(info.get("documentID"), "faoCollection", "SmartfishFT", info.get("language"), info);
    }

    private void annotate(String filename, Map<String, List<String>> uris) throws FileNotFoundException {
        AnnotationBase annotator = AnnotationBase.getInstance();
        Set<Map.Entry<String, List<String>>> entrySet = uris.entrySet();
        for (Map.Entry<String, List<String>> entry : entrySet) {
            List<String> uris_;
            if (entry.getKey().equals(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#country") + "_uris")) {
                uris_ = entry.getValue();
                for (String uri_ : uris_) {
                    annotator.FIRMS_country(filename, uri_);
                }
                continue;
            }
            if (entry.getKey().equals(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#species") + "_uris")) {
                uris_ = entry.getValue();
                for (String uri_ : uris_) {
                    annotator.FIRMS_species(filename, uri_);
                }
                continue;
            }
            if (entry.getKey().equals(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#gear") + "_uris")) {
                uris_ = entry.getValue();
                for (String uri_ : uris_) {
                    annotator.FIRMS_gear(filename, uri_);
                }
                continue;
            }
            if (entry.getKey().equals(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#management") + "_uris")) {
                uris_ = entry.getValue();
                for (String uri_ : uris_) {
                    annotator.FIRMS_management(filename, uri_);
                }
                continue;
            }
            if (entry.getKey().equals(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#year") + "_uris")) {
                uris_ = entry.getValue();
                for (String uri_ : uris_) {
                    annotator.FIRMS_year(filename, uri_);
                }
                continue;
            }
            if (!entry.getKey().equals(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#status") + "_uris")) continue;
            uris_ = entry.getValue();
            for (String uri_ : uris_) {
                annotator.FIRMS_status(filename, uri_);
            }
        }
    }

    public static class FigisNamespaceContext
    implements NamespaceContext {
        private final Map<String, String> prefixMap;

        FigisNamespaceContext(Map<String, String> prefixMap) {
            this.prefixMap = prefixMap != null ? Collections.unmodifiableMap(new HashMap<String, String>(prefixMap)) : Collections.emptyMap();
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return null;
        }

        public Iterator<?> getPrefixes(String namespaceURI) {
            return null;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix == null) {
                throw new NullPointerException("Invalid Namespace Prefix");
            }
            if ("fi".equalsIgnoreCase(prefix)) {
                return "http://www.fao.org/fi/figis/devcon/";
            }
            if ("argls".equals(prefix)) {
                return "http://www.naa.gov.au/recordkeeping/gov_online/agls/1.1";
            }
            if ("ags".equals(prefix)) {
                return "http://www.purl.org/agmes/1.1/";
            }
            if ("aida".equals(prefix)) {
                return "http://www.idmlinitiative.org/resources/dtds/AIDA22.xsd";
            }
            if ("dc".equals(prefix)) {
                return "http://purl.org/dc/elements/1.1/";
            }
            if ("dcterms".equals(prefix)) {
                return "http://purl.org/dc/terms/";
            }
            if ("xsi".equals(prefix)) {
                return "http://www.w3.org/2001/XMLSchema-instance";
            }
            if ("xml".equals(prefix)) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            return "";
        }
    }
}

