/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.textextractor.extractors;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.semantic.annotator.AnnotationBase;
import org.gcube.semantic.annotator.utils.ANNOTATIONS;
import org.gcube.textextractor.entities.ShortenCE4NameResponse;
import org.gcube.textextractor.extractors.InformationExtractor;
import org.gcube.textextractor.helpers.ExtractorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVExtractor
extends InformationExtractor {
    private static final Logger logger = LoggerFactory.getLogger(CSVExtractor.class);

    /*
     * Exception decompiling
     */
    @Override
    public Map<String, String> extractFieldsFromFile(String filename) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<Map<String, String>> extractInfo(String path) throws FileNotFoundException {
        ArrayList<Map<String, String>> extractedInfo = new ArrayList<Map<String, String>>();
        int cnt = 0;
        List<String> filenames = ExtractorHelper.getFilenames(path);
        for (String filename : filenames) {
            logger.info("Processing file : " + ++cnt + " " + filename);
            try {
                Map<String, String> info = this.extractFieldsFromFile(filename);
                long part_start_time = System.currentTimeMillis();
                Map<String, String> enriched = this.enrichRecord(info, filename);
                long part_end_time = System.currentTimeMillis();
                logger.info("~> field enrichment time  : " + (double)(part_end_time - part_start_time) / 1000.0 + " secs");
                extractedInfo.add(enriched);
            }
            catch (Exception e) {
                logger.error("error while extracting info from : " + filename + " . will skip this file", (Throwable)e);
            }
        }
        return extractedInfo;
    }

    private void gatherInfo(Map<String, Set<String>> totalInfo, String fieldName, String value) {
        if (value == null || value.trim().length() == 0) {
            return;
        }
        totalInfo.get(fieldName).add(value.trim());
    }

    @Override
    public Map<String, String> enrichRecord(Map<String, String> record, String filename) {
        HashMap<String, String> enrichedRecord = new HashMap<String, String>();
        HashMap<String, List<String>> uris = new HashMap<String, List<String>>();
        String[] docParts = filename.split("/");
        String fname = docParts[docParts.length - 1];
        String[] fnameParts = fname.split("\\.");
        String docID = fnameParts[0].toLowerCase();
        String docURI = "http://smartfish.collection/statbase/" + docID;
        enrichedRecord.put("documentID", docURI);
        enrichedRecord.putAll(record);
        ExtractorHelper.enrichSimpleField(record, enrichedRecord, uris, ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#country"), new ExtractorHelper.QueryWrapperSimple(){

            @Override
            public String doCall(String arg) throws Exception {
                return ExtractorHelper.queryCountry(arg);
            }
        });
        try {
            String speciesURIJson = null;
            if (record.get("species_english_name").trim().length() > 0) {
                speciesURIJson = ExtractorHelper.querySpecies(ExtractorHelper.covertToStringList(record.get("species_english_name")));
                uris.put("species_uris", ShortenCE4NameResponse.getURIFromJSON(speciesURIJson));
                enrichedRecord.put("species_uris", speciesURIJson);
            }
        }
        catch (Exception e) {
            logger.warn("Error processing species : " + record.get("species_english_name"), (Throwable)e);
        }
        try {
            this.annotate(docURI, uris);
        }
        catch (FileNotFoundException ex) {
            logger.error("file : " + filename + " not found", (Throwable)ex);
        }
        return enrichedRecord;
    }

    @Override
    public String convertInfoToRowset(Map<String, String> info) {
        String documentID = info.get("documentID");
        info.remove("documentID");
        return ExtractorHelper.createRowseFromFields(documentID, "faoCollection", "SmartfishFT", info.get("language"), info);
    }

    private void annotate(String filename, Map<String, List<String>> uris) throws FileNotFoundException {
        AnnotationBase annotator = AnnotationBase.getInstance();
        Set<Map.Entry<String, List<String>>> entrySet = uris.entrySet();
        for (Map.Entry<String, List<String>> entry : entrySet) {
            List<String> uris_;
            if (entry.getKey().equals(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#country") + "_uris")) {
                uris_ = entry.getValue();
                for (String uri_ : uris_) {
                    annotator.STATBASE_country(filename, uri_);
                }
            }
            if (entry.getKey().equals(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#species") + "_uris")) {
                uris_ = entry.getValue();
                for (String uri_ : uris_) {
                    annotator.STATBASE_species(filename, uri_);
                }
            }
            if (entry.getKey().equals(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#gear") + "_uris")) {
                uris_ = entry.getValue();
                for (String uri_ : uris_) {
                    annotator.STATBASE_gear(filename, uri_);
                }
            }
            if (entry.getKey().equals(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#vessel") + "_uris")) {
                uris_ = entry.getValue();
                for (String uri_ : uris_) {
                    annotator.STATBASE_vessel(filename, uri_);
                }
            }
            if (entry.getKey().equals(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#water_area") + "_uris")) {
                uris_ = entry.getValue();
                for (String uri_ : uris_) {
                    annotator.STATBASE_water_area(filename, uri_);
                }
            }
            if (!entry.getKey().equals(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#land_area") + "_uris")) continue;
            uris_ = entry.getValue();
            for (String uri_ : uris_) {
                annotator.STATBASE_land_area(filename, uri_);
            }
        }
    }
}

