/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.semantic.annotator;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.resultset.ResultSetMem;
import com.hp.hpl.jena.sparql.util.ModelUtils;
import com.hp.hpl.jena.sparql.util.ResultSetUtils;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.ArrayUtils;
import org.apache.jena.riot.RiotWriter;
import org.apache.jena.web.DatasetGraphAccessorHTTP;
import org.gcube.semantic.annotator.FLOD_EntityCollection;
import org.gcube.semantic.annotator.utils.MD5Generator;

public class SMARTFISH_EntityCollection {
    private static SMARTFISH_EntityCollection instance;
    private static DatasetGraph entityCollection_locale;
    private final Node chimaeraKBnode = NodeFactory.createURI((String)"http://smartfish.d4science.org/entities");
    private static Model m;

    private SMARTFISH_EntityCollection() {
        DatasetGraphAccessorHTTP kbAccressor = new DatasetGraphAccessorHTTP("http://dl051.madgik.di.uoa.gr:3030/chimaera_kb_update/data");
        Graph chimaeraGraph = kbAccressor.httpGet(this.chimaeraKBnode);
        if (chimaeraGraph == null) {
            chimaeraGraph = Graph.emptyGraph;
        }
        m.add(ModelUtils.triplesToStatements((Iterator)GraphUtil.findAll((Graph)chimaeraGraph), (Model)m));
    }

    public static SMARTFISH_EntityCollection getInstance() {
        if (instance == null) {
            instance = new SMARTFISH_EntityCollection();
        }
        return instance;
    }

    private void addInstance(String en_name, String fr_name, String typeURI) throws NoSuchAlgorithmException {
        if ("".equals(en_name)) {
            return;
        }
        System.out.println("Adding entity to smartfish_kb for : " + en_name);
        Node graphNode = NodeFactory.createURI((String)"http://smartfish.d4science.org/entities");
        Node typeNode = NodeFactory.createURI((String)typeURI);
        String entity_uri = "http://smartfish.d4science.org/entities/" + typeNode.getLocalName().toLowerCase() + "/" + MD5Generator.getMD5Sum(en_name);
        Node entity_node = NodeFactory.createURI((String)entity_uri);
        entityCollection_locale.add(graphNode, entity_node, RDF.type.asNode(), typeNode);
        entityCollection_locale.add(graphNode, entity_node, RDFS.label.asNode(), NodeFactory.createLiteral((String)en_name, (String)"en", null));
        m.add(m.createResource(entity_uri), RDF.type, (RDFNode)m.createResource(typeURI));
        m.add(m.createResource(entity_uri), RDFS.label, (RDFNode)m.createLiteral(en_name, "en"));
        if (fr_name != null && !fr_name.isEmpty()) {
            entityCollection_locale.add(graphNode, entity_node, RDFS.label.asNode(), NodeFactory.createLiteral((String)fr_name, (String)"fr", null));
            m.add(m.createResource(entity_uri), RDFS.label, (RDFNode)m.createLiteral(fr_name, "fr"));
        }
    }

    public File toFile() throws FileNotFoundException {
        File f = new File("smartfish_kb.nq");
        FileOutputStream fos = new FileOutputStream(f);
        RiotWriter.createNQuads().write((OutputStream)fos, entityCollection_locale, null, null, entityCollection_locale.getContext());
        return f;
    }

    public File dump(File f) throws FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(f);
        RiotWriter.createNQuads().write((OutputStream)fos, entityCollection_locale, null, null, entityCollection_locale.getContext());
        entityCollection_locale.deleteAny(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
        return f;
    }

    public String getURI(String name, String resType) {
        ResultSet rs = this.getURIrs(name, resType);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsJSON((OutputStream)bos, (ResultSet)rs);
        return bos.toString();
    }

    public ResultSet getURIrs(String name, String resType) {
        ResultSet rs = this.ce4name(name, resType);
        if (rs.getRowNumber() <= 0) {
            System.out.println("SMARTFISH entity collection - NO URI FOUND for : " + name);
            this.addIfNotThere(name, resType);
            rs = this.ce4name(name, resType);
        }
        return rs;
    }

    public String getURI(String[] names, String resType) {
        ResultSet[] rsList = new ResultSet[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (name.isEmpty()) continue;
            ResultSet rs = this.ce4name(name, resType);
            if (rs.getRowNumber() <= 0) {
                System.out.println("SMARTFISH entity collection - NO URI FOUND for : " + name);
                this.addIfNotThere(name, resType);
                rs = this.ce4name(name, resType);
            }
            rsList[i] = rs;
        }
        ResultSet rsm = ResultSetUtils.union((ResultSet[])rsList);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsJSON((OutputStream)bos, (ResultSet)rsm);
        return bos.toString();
    }

    private ResultSet ce4name(String name, String resType) {
        String sanitized_name = this.sanitize(name);
        String BGP = "{?uri rdf:type <" + resType + "> ." + "?uri rdfs:label ?label . " + "BIND (str(?label) as ?label_str) " + "BIND (lang(?label) as ?lang) " + "filter(?label_str = '" + sanitized_name + "') " + "filter(?lang = 'en' || ?lang = 'fr')" + "}";
        String querySelect = "  SELECT distinct ?uri ?label_str ?lang WHERE " + BGP;
        return QueryExecutionFactory.create((String)(FLOD_EntityCollection.prefixes + querySelect), (Model)m).execSelect();
    }

    private boolean ask_ce4name(String name, String resType) {
        name = this.sanitize(name);
        System.out.println("SMARTFISH entity collection ask for : " + name);
        String query = "ASK {?uri rdf:type <" + resType + "> ." + "?uri rdfs:label ?label . " + "BIND (str(?label) as ?label_str) " + "BIND (lang(?label) as ?lang) " + "filter(?label_str = '" + name + "') " + "filter(?lang = 'en' || ?lang = 'fr')" + "}";
        return QueryExecutionFactory.create((String)(FLOD_EntityCollection.prefixes + query), (Model)m).execAsk();
    }

    public String getLabel(String uri, String lang) {
        ResultSet rs = this.label4uri(uri, lang);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsJSON((OutputStream)bos, (ResultSet)rs);
        return bos.toString();
    }

    public String getLabel(List<String> entitiesURIs, String lang) {
        ResultSet[] rsList = new ResultSet[entitiesURIs.size()];
        ResultSetMem rsm = new ResultSetMem();
        for (int i = 0; i < entitiesURIs.size(); ++i) {
            String uri = entitiesURIs.get(i);
            ResultSet rs = this.label4uri(uri, lang);
        }
        if (rsList.length > 0) {
            rsm = (ResultSetMem)ResultSetUtils.union((ResultSet[])rsList);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsJSON((OutputStream)bos, (ResultSet)rsm);
        return bos.toString();
    }

    private ResultSet label4uri(String uri, String lang) {
        String filter = "";
        String select = " select distinct ?uri ?label_str ?lang";
        String where = " where ";
        String gbpattern = "BIND (IRI('" + uri + "') as ?uri) " + " ?uri rdfs:label ?label_lang . " + "BIND (str(?label_lang) as ?label_str) " + "BIND (lang(?label_lang) as ?lang) ";
        filter = !"".equals(lang) ? filter + "filter(?lang = '" + lang + "')" : filter + "filter(?lang = 'en' || ?lang = 'fr' || ?lang = 'la')";
        Query q = QueryFactory.create((String)(FLOD_EntityCollection.prefixes + select + where + "{" + gbpattern + filter + " }"));
        return QueryExecutionFactory.create((Query)q, (Model)m).execSelect();
    }

    private String sanitize(String name) {
        if (name.contains("/")) {
            name = name.split("/")[0].trim();
        }
        name = name.replace("'", "\\'");
        return name;
    }

    public static void main(String[] args) throws FileNotFoundException {
        ResultSet ce4name = SMARTFISH_EntityCollection.getInstance().ce4name("Vanderbilt's chromis", "http://www.fao.org/figis/flod/onto/linneanspecies.owl#SpeciesCode");
        System.out.println(ResultSetFormatter.asText((ResultSet)ce4name));
    }

    private String addIfNotThere(String name, String resType) {
        String name_en = "";
        String name_fr = "";
        try {
            String[] names = name.split("/");
            name_en = names[0];
            try {
                name_fr = names[1];
            }
            catch (Exception e) {
                // empty catch block
            }
            this.addInstance(name_en.trim(), name_fr.trim(), resType);
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(SMARTFISH_EntityCollection.class.getName()).log(Level.SEVERE, null, ex);
        }
        return name_en;
    }

    private String[] orderByPresence(String[] names, String type) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (name.isEmpty()) continue;
            if (!this.ask_ce4name(name, type)) {
                list.add(0, name);
                continue;
            }
            list.add(name);
        }
        return list.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    static {
        entityCollection_locale = DatasetGraphFactory.createMem();
        m = ModelFactory.createDefaultModel();
    }
}

