/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.common;

import java.util.List;
import org.gcube.indexmanagement.common.IndexField;
import org.gcube.indexmanagement.common.IndexType;
import org.gcube.indexmanagement.common.IndexTypeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullTextIndexType
extends IndexType {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(FullTextIndexType.class);
    private List<IndexField> fields;

    public FullTextIndexType(String indexTypeName, String scope) {
        super(indexTypeName);
        try {
            String indexType = this.retrieveIndexTypeGenericResource(scope);
            this.fields = IndexTypeParser.readAllFields(indexType);
        }
        catch (Exception ex) {
            logger.error("Error initializing FullTextIndexType.", (Throwable)ex);
        }
    }

    public List<IndexField> getFields() {
        return this.fields;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer("\nID=" + this.indexTypeID + "\n\nFields:\n");
        for (IndexField field : this.fields) {
            ret.append(field + "\n");
        }
        return ret.toString();
    }
}

