/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.featureindexlibrary.fullscan;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import org.apache.log4j.Logger;
import org.gcube.indexmanagement.featureindexlibrary.commons.FeatureVectorElement;
import org.gcube.indexmanagement.featureindexlibrary.fullscan.FullScanParams;

public class FullScanWriter {
    private static Logger log = Logger.getLogger(FullScanWriter.class);
    private FullScanParams charact = null;
    private FileOutputStream fos = null;
    private BufferedOutputStream bos = null;
    private DataOutputStream ds = null;

    public FullScanWriter(FullScanParams charact) {
        this.charact = charact;
    }

    private String readString(RandomAccessFile ds) {
        try {
            int count = ds.readInt();
            char[] buf = new char[count];
            for (int i = 0; i < count; ++i) {
                buf[i] = ds.readChar();
            }
            return new String(buf);
        }
        catch (EOFException e) {
            return null;
        }
        catch (Exception e) {
            log.debug((Object)"Could not read string. Assuming eof", (Throwable)e);
            return null;
        }
    }

    private float[] readVector(RandomAccessFile ds) {
        try {
            int count = ds.readInt();
            float[] buf = new float[count];
            for (int i = 0; i < count; ++i) {
                buf[i] = ds.readFloat();
            }
            return buf;
        }
        catch (EOFException e) {
            return null;
        }
        catch (Exception e) {
            log.debug((Object)"Could not read string. Assuming eof", (Throwable)e);
            return null;
        }
    }

    private void writeString(String toWrite, DataOutputStream ds) throws Exception {
        char[] toWriteA = toWrite.toCharArray();
        ds.writeInt(toWriteA.length);
        for (int i = 0; i < toWriteA.length; ++i) {
            ds.writeChar(toWriteA[i]);
        }
    }

    private void writeString(String toWrite, RandomAccessFile ds) throws Exception {
        char[] toWriteA = toWrite.toCharArray();
        ds.writeInt(toWriteA.length);
        for (int i = 0; i < toWriteA.length; ++i) {
            ds.writeChar(toWriteA[i]);
        }
    }

    private void writeVector(float[] vector, DataOutputStream ds) throws Exception {
        ds.writeInt(vector.length);
        for (int i = 0; i < vector.length; ++i) {
            ds.writeFloat(vector[i]);
        }
    }

    public void writeHead(String file) throws Exception {
        RandomAccessFile rand = null;
        try {
            rand = new RandomAccessFile(file, "rw");
            rand.seek(0L);
            rand.writeLong(this.charact.getElementCount());
            this.writeString(this.charact.getDistanceMeasure().toString(), rand);
            this.writeString(this.charact.getFeatureName().toString(), rand);
            this.writeString(this.charact.getIndexID(), rand);
            this.writeString(this.charact.getIndexName(), rand);
            this.writeString(this.charact.getStorage(), rand);
            rand.close();
        }
        catch (Exception e) {
            if (rand != null) {
                rand.close();
            }
            log.error((Object)"Could not write header. thrpwing exception", (Throwable)e);
            throw new Exception("Could not write header");
        }
    }

    public void removeEntry(String id, String file) throws Exception {
        RandomAccessFile rand = null;
        try {
            rand = new RandomAccessFile(file, "rw");
            rand.seek(0L);
            rand.readLong();
            this.readString(rand);
            this.readString(rand);
            this.readString(rand);
            this.readString(rand);
            this.readString(rand);
            while (true) {
                float[] vector;
                long offset = rand.getFilePointer();
                String idc = this.readString(rand);
                if (idc == null || (vector = this.readVector(rand)) == null) break;
                long newOffset = rand.getFilePointer();
                if (idc.compareTo(id) == 0) {
                    rand.seek(offset);
                    rand.write(45);
                }
                rand.seek(newOffset);
            }
            rand.close();
        }
        catch (Exception e) {
            if (rand != null) {
                rand.close();
            }
            log.error((Object)"Could not remove entry. thrpwing exception", (Throwable)e);
            throw new Exception("Could not remove entry");
        }
    }

    public void writeEntry(FeatureVectorElement elem) throws Exception {
        try {
            this.writeString(elem.getId(), this.ds);
            this.writeVector(elem.getVector(), this.ds);
        }
        catch (Exception e) {
            log.error((Object)"Could not write entry. Throwing Exception", (Throwable)e);
            throw new Exception("Could not write entry");
        }
    }

    public void openForUpdate(String file) throws Exception {
        try {
            this.fos = new FileOutputStream(file, true);
            this.bos = new BufferedOutputStream(this.fos);
            this.ds = new DataOutputStream(this.bos);
        }
        catch (Exception e) {
            log.error((Object)"Could not open writer. Throwing Exception", (Throwable)e);
            throw new Exception("Could not open writer");
        }
    }

    public void close() throws Exception {
        try {
            this.ds.close();
            this.bos.close();
            this.fos.close();
        }
        catch (Exception e) {
            log.error((Object)"Could not close writer. Throwing Exception", (Throwable)e);
            throw new Exception("Could not close writer");
        }
    }
}

