/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.common.notifications;

import java.util.LinkedList;
import java.util.List;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.indexmanagement.common.notifications.NotifierRequest;
import org.gcube.indexmanagement.common.notifications.NotifierRequestQueue;
import org.globus.wsrf.impl.SimpleTopic;

public class UnregisterNotificationRequest
extends NotifierRequest {
    private List<SimpleTopic> topicList;

    public UnregisterNotificationRequest(EndpointReferenceType epr, List<SimpleTopic> topicList, GCUBEServiceContext sctx, GCUBEScope scope) {
        super(epr, sctx, scope);
        this.topicList = new LinkedList<SimpleTopic>(topicList);
    }

    @Override
    public void doRequest() {
        ISNotifier notifier = NotifierRequestQueue.getInstance().getNotifier();
        boolean bRetry = true;
        while (bRetry) {
            try {
                notifier.unregisterISNotification(this.epr, this.topicList, (GCUBESecurityManager)this.sctx, new GCUBEScope[]{this.scope});
                bRetry = false;
            }
            catch (Exception e) {
                logger.warn((Object)"Exception while trying to unregister topics. Retrying...", (Throwable)e);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {}
            }
        }
    }
}

