/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.common;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.gcube.indexmanagement.common.IndexWSResource;
import org.globus.wsrf.Topic;

public abstract class IndexManagementWSResource
extends IndexWSResource {
    private static final String RP_UPDATER = "Updater";
    private static final String RP_INDEX_STATUS = "IndexStatus";
    private static final String RP_CONNECTION_COUNT = "ConnectionCount";
    private static final String RP_DOCUMENT_COUNT = "DocumentCount";
    public static final String MANAGER_STATUS_EMPTY = "EMPTY";
    public static final String MANAGER_STATUS_UPDATING = "UPDATING";
    public static final String MANAGER_STATUS_FINISHED = "FINISHED";
    private static final String STATE_CHANGE_TOPIC_NAME = "SharedStateChange";
    protected Topic sharedStateChangeTopic;

    @Override
    public void initialise(String namespace, String indexID, String indexTypeName, String[] collectionID) throws Exception {
        super.initialise(namespace, indexID, indexTypeName, collectionID);
        this.createProperty(RP_INDEX_STATUS);
        this.getResourcePropertySet().get(RP_INDEX_STATUS).clear();
        this.getResourcePropertySet().get(RP_INDEX_STATUS).add((Object)MANAGER_STATUS_EMPTY);
        this.createProperty(RP_UPDATER);
        this.createProperty(RP_CONNECTION_COUNT);
        this.getResourcePropertySet().get(RP_CONNECTION_COUNT).clear();
        this.getResourcePropertySet().get(RP_CONNECTION_COUNT).add((Object)0);
        this.createProperty(RP_DOCUMENT_COUNT);
        this.getResourcePropertySet().get(RP_DOCUMENT_COUNT).clear();
        this.getResourcePropertySet().get(RP_DOCUMENT_COUNT).add((Object)0);
        this.sharedStateChangeTopic = this.createTopic(STATE_CHANGE_TOPIC_NAME, namespace + "/" + indexID);
    }

    @Override
    protected void onLoad(ObjectInputStream ois, boolean firstLoad) throws Exception {
        super.onLoad(ois, firstLoad);
        String status = (String)ois.readObject();
        this.createProperty(RP_INDEX_STATUS);
        this.getResourcePropertySet().get(RP_INDEX_STATUS).clear();
        this.getResourcePropertySet().get(RP_INDEX_STATUS).add((Object)status);
        int size = ois.readInt();
        this.createProperty(RP_UPDATER);
        this.getResourcePropertySet().get(RP_UPDATER).clear();
        for (int i = 0; i < size; ++i) {
            this.getResourcePropertySet().get(RP_UPDATER).add((Object)ois.readInt());
        }
        Integer connectionCount = ois.readInt();
        this.createProperty(RP_CONNECTION_COUNT);
        this.getResourcePropertySet().get(RP_CONNECTION_COUNT).clear();
        this.getResourcePropertySet().get(RP_CONNECTION_COUNT).add((Object)connectionCount);
        Integer docCount = ois.readInt();
        this.createProperty(RP_DOCUMENT_COUNT);
        this.getResourcePropertySet().get(RP_DOCUMENT_COUNT).clear();
        this.getResourcePropertySet().get(RP_DOCUMENT_COUNT).add((Object)docCount);
        this.sharedStateChangeTopic = this.createTopic(STATE_CHANGE_TOPIC_NAME, this.namespace + "/" + this.getIndexID());
    }

    @Override
    protected void onStore(ObjectOutputStream oos) throws Exception {
        super.onStore(oos);
        oos.writeObject((String)this.getResourcePropertySet().get(RP_INDEX_STATUS).get(0));
        int size = this.getResourcePropertySet().get(RP_UPDATER).size();
        oos.writeInt(size);
        for (int i = 0; i < size; ++i) {
            oos.writeInt((Integer)this.getResourcePropertySet().get(RP_UPDATER).get(i));
        }
        oos.writeInt((Integer)this.getResourcePropertySet().get(RP_CONNECTION_COUNT).get(0));
        oos.writeInt((Integer)this.getResourcePropertySet().get(RP_DOCUMENT_COUNT).get(0));
    }

    public void sendSharedStateChangeNotification(Object message) {
        try {
            this.sharedStateChangeTopic.notify(message);
            logger.debug((Object)("State change notification sent on topic: " + this.sharedStateChangeTopic.getName()));
        }
        catch (Exception e) {
            logger.error((Object)"Exception while trying to send state change notification.", (Throwable)e);
        }
    }

    public String getIndexStatus() {
        return (String)this.getResourcePropertySet().get(RP_INDEX_STATUS).get(0);
    }

    public int getConnectionCount() {
        return (Integer)this.getResourcePropertySet().get(RP_CONNECTION_COUNT).get(0);
    }

    public int getDocumentCount() {
        return (Integer)this.getResourcePropertySet().get(RP_DOCUMENT_COUNT).get(0);
    }

    public int[] getUpdater() {
        int size = this.getResourcePropertySet().get(RP_UPDATER).size();
        int[] upds = new int[size];
        for (int i = 0; i < size; ++i) {
            upds[i] = (Integer)this.getResourcePropertySet().get(RP_UPDATER).get(i);
        }
        return upds;
    }

    public int getUpdaterCount() {
        return this.getResourcePropertySet().get(RP_UPDATER).size();
    }

    public void setIndexStatus(String indexStatus) {
        this.getResourcePropertySet().get(RP_INDEX_STATUS).clear();
        this.getResourcePropertySet().get(RP_INDEX_STATUS).add((Object)indexStatus);
    }

    public synchronized void setConnectionCount(int connectionCount) {
        this.getResourcePropertySet().get(RP_CONNECTION_COUNT).clear();
        this.getResourcePropertySet().get(RP_CONNECTION_COUNT).add((Object)new Integer(connectionCount));
    }

    public void setDocumentCount(int docCount) {
        this.getResourcePropertySet().get(RP_DOCUMENT_COUNT).clear();
        this.getResourcePropertySet().get(RP_DOCUMENT_COUNT).add((Object)new Integer(docCount));
    }

    public void setUpdater(int[] updaters) {
        int size = updaters.length;
        this.getResourcePropertySet().get(RP_UPDATER).clear();
        for (int i = 0; i < size; ++i) {
            this.getResourcePropertySet().get(RP_UPDATER).add((Object)new Integer(updaters[i]));
        }
    }

    public void addUpdater(int updater) {
        this.getResourcePropertySet().get(RP_UPDATER).add((Object)new Integer(updater));
    }

    public void deleteUpdater(int updater) {
        this.getResourcePropertySet().get(RP_UPDATER).remove((Object)new Integer(updater));
    }
}

