/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.featureindexlibrary.commons;

import java.io.File;

public class FileHelper {
    private static final String BUFFERPOSTFIX = ".tmp";
    private static final String FULLSCANPOSTFIX = ".FullScan";
    private static final String VAFVECTORPOSTFIX = ".VAFVector";
    private static final String VAFAPPROXPOSTFIX = ".VAFApprox";

    public static boolean existsFullScanFile(String storage, String indexID) {
        File tmp = new File(FileHelper.getFullScanFile(storage, indexID));
        return tmp.exists();
    }

    public static boolean existsFullScanBufferFile(String storage, String indexID) {
        File tmp = new File(FileHelper.getFullScanBufferFile(storage, indexID));
        return tmp.exists();
    }

    public static String getFullScanFile(String storage, String indexID) {
        return storage + indexID + FULLSCANPOSTFIX;
    }

    public static String getFullScanBufferFile(String storage, String indexID) {
        return storage + indexID + FULLSCANPOSTFIX + BUFFERPOSTFIX;
    }

    public static boolean removeFullScanBufferFile(String storage, String indexID) {
        File buf = new File(FileHelper.getFullScanBufferFile(storage, indexID));
        return buf.delete();
    }

    public static boolean existsVAFBufferFile(String storage, String indexID) {
        File tmp = new File(FileHelper.getVAFBufferFile(storage, indexID));
        return tmp.exists();
    }

    public static boolean existsVAFVectorFile(String storage, String indexID) {
        File tmp = new File(FileHelper.getVAFVectorFile(storage, indexID));
        return tmp.exists();
    }

    public static boolean existsVAFApproxFile(String storage, String indexID) {
        File tmp = new File(FileHelper.getVAFApproxFile(storage, indexID));
        return tmp.exists();
    }

    public static String getVAFBufferFile(String storage, String indexID) {
        return storage + indexID + VAFVECTORPOSTFIX + BUFFERPOSTFIX;
    }

    public static String getVAFVectorFile(String storage, String indexID) {
        return storage + indexID + VAFVECTORPOSTFIX;
    }

    public static String getVAFApproxFile(String storage, String indexID) {
        return storage + indexID + VAFAPPROXPOSTFIX;
    }

    public static boolean removeVAFBufferFile(String storage, String indexID) {
        File buf = new File(FileHelper.getVAFBufferFile(storage, indexID));
        return buf.delete();
    }
}

