package org.gcube.indexmanagement.geo;

import java.util.Arrays;

public class RankingRequest {

	private String rankerID;
	
	private boolean reverse = false;
	
	private String[] args;
	
	/**
	 * Default constructor
	 * 
	 * @param rankerID
	 * @param args
	 */
	public RankingRequest(String rankerID, String[] args, boolean reverse) {
		this.setRankerID(rankerID);
		this.setArgs(args);
		this.setReverse(reverse);
	}

	/**
	 * setter for the ranker ID property
	 * @param rankerID
	 */
	public void setRankerID(String rankerID) {
		this.rankerID = rankerID;
	}

	/**
	 * getter for the ranker ID property
	 * @return the ranker ID
	 */
	public String getRankerID() {
		return rankerID;
	}

	/**
	 * setter for the ranker arguments
	 * @param args
	 */
	public void setArgs(String[] args) {
		this.args = args;
	}

	/**
	 * getter of the ranker arguments
	 * @return the arguments
	 */
	public String[] getArgs() {
		return args;
	}

	public void setReverse(boolean reverse) {
		this.reverse = reverse;
	}

	public boolean isReverse() {
		return reverse;
	}
	
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("RankerID: " + rankerID);
		builder.append(" - reverse: " + reverse);
		builder.append(" - args: " + Arrays.toString(args));
		
		return builder.toString();
	}
	

}
