package org.gcube.indexmanagement.featureindexlibrary.merger;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.gcube.indexmanagement.featureindexlibrary.commons.FeatureFactoryStatsContainer;
import org.gcube.indexmanagement.featureindexlibrary.commons.RankedResultElement;
import org.gcube.indexmanagement.featureindexlibrary.commons.SortAscRankedResultComparator;
import org.gcube.indexmanagement.featureindexlibrary.commons.SortDescMergedResultComparator;

/**
 * merges results from multiple index lookups
 * 
 * @author UoA
 */
public class ResultMerger {
	/**
	 * The number of results to produce
	 */
	private int k=0;
	/**
	 * Statistics
	 */
	private FeatureFactoryStatsContainer stats=null;
	
	/**
	 * Creates a new instance
	 * 
	 * @param k The number of results
	 * @param stats statistics
	 */
	public ResultMerger(int k,FeatureFactoryStatsContainer stats){
		this.k=k;
		this.stats=stats;
	}
	
	/**
	 * Merges the given ranked results
	 * 
	 * @param results The ranked results with respective weights
	 * @return The merged results
	 */
	public List<MergedResultElement> merge(RankedMergeElement []results){
		long start=Calendar.getInstance().getTimeInMillis();
		List<MergedResultElement> res=new ArrayList<MergedResultElement>(k);
		Hashtable<String,RankedResultElement> []hashes=new Hashtable[results.length];
		float []minRank=new float[results.length];
		float bestScore=0;
		for(int i=0;i<results.length;i+=1) bestScore+=results[i].getWeight();
		Set<String> oids=new HashSet<String>();
		for(int i=0;i<results.length;i+=1){
			hashes[i]=new Hashtable<String,RankedResultElement>(results[i].getResults().size());
			minRank[i]=results[i].getResults().get(results[i].getResults().size()-1).getRank();
			for(int q=0;q<results[i].getResults().size();q+=1){
				oids.add(results[i].getResults().get(q).getId());
				hashes[i].put(results[i].getResults().get(q).getId(),results[i].getResults().get(q));
			}
		}
		Iterator<String> iter=oids.iterator();
		while(iter.hasNext()){
			String oid=iter.next();
			float rank=0;
			MergedResultElement mres=new MergedResultElement(oid);
			Set<String> names=new HashSet<String>();
			for(int i=0;i<hashes.length;i+=1){
				RankedResultElement elem=hashes[i].get(oid);
				if(elem==null) rank+=results[i].getWeight()*minRank[i];
				else{
					rank+=results[i].getWeight()*elem.getRank();
					names.add(elem.getIndexName());
				}
			}
			rank=rank/bestScore;
			mres.setRank(rank);
			mres.setIndexNames(names);
			res.add(mres);
		}
		Collections.sort(res,new SortDescMergedResultComparator());
		stats.mergeTime(Calendar.getInstance().getTimeInMillis()-start);
		stats.mergeResults(res.size());
		return res.subList(0,k);
	}
}
