package org.gcube.indexmanagement.featureindexlibrary.commons;

import java.util.Comparator;

import org.gcube.indexmanagement.featureindexlibrary.merger.MergedResultElement;

/**
 * Comparator for sorting in descending order {@link org.gcube.indexmanagement.featureindexlibrary.merger.MergedResultElement} 
 * 
 * @author UoA
 */
public class SortDescMergedResultComparator implements Comparator{
	/**
	 * compares the two instances
	 * 
	 * @param o1 The left operant
	 * @param o2 The right operant
	 * @return The result of the comparison
	 */
	public int compare(Object o1, Object o2){
		if(!(o1 instanceof MergedResultElement)) throw new ClassCastException();
		if(!(o2 instanceof MergedResultElement)) throw new ClassCastException();
		try{
	    	if(((MergedResultElement)o1).getRank()<((MergedResultElement)o2).getRank()) return 1;
	    	else if(((MergedResultElement)o1).getRank()>((MergedResultElement)o2).getRank()) return -1;
	    	else return 0;
		}catch(Exception e){
			throw new ClassCastException("INvalid Token Format Comparison");
		}
	}
	
	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 * @param o The object to check for comparison
	 * @return the result of the equality check
	 */
	public boolean equals(Object o){
	    if(!(o instanceof SortDescMergedResultComparator))
	        return false;
	    else return true;
	  }
}
