package org.gcube.indexmanagement.featureindexlibrary.vafile.io;

import java.io.*;

import org.apache.log4j.Logger;
import org.gcube.indexmanagement.featureindexlibrary.commons.*;
import org.gcube.indexmanagement.featureindexlibrary.vafile.VAFileParams;

/**
 * Buffer file writer helper 
 * 
 * @author UoA
 */
public class FileBufferWriter {
	/**
	 * The Logger used by the class
	 */
	private static Logger log = Logger.getLogger(FileBufferWriter.class);
	/**
	 *The file  
	 */
	private String file=null;
	/**
	 * The input stream
	 */
	private FileOutputStream fos=null;
	/**
	 * The input stream
	 */
	private BufferedOutputStream bos=null;
	/**
	 * The input stream
	 */
	private DataOutputStream dos=null;
	/**
	 * The id length
	 */
	private int idlength=0;
	/**
	 * The vector length
	 */
	private int vectorlength=0;
	
	/**
	 * Creates a new instance
	 * 
	 * @param file The file
	 * @param params The VAFIle header params
	 */
	public FileBufferWriter(String file,VAFileParams params){
		this.file=file;
		this.idlength=params.getIDLength();
		this.vectorlength=params.getVectorLength();
	}
	
	/**
	 * Writes  a string
	 * 
	 * @param id The id 
	 * @throws Exception An error
	 */
	private void write(String id) throws Exception{
		char []idA=id.toCharArray();
		for(int i=0;i<idA.length;i+=1){
			dos.writeChar(idA[i]);
		}
	}
	
	/**
	 * Writes a vector
	 * 
	 * @param vector The vector
	 * @throws Exception An error
	 */
	private void write(float []vector) throws Exception{
		for(int i=0;i<vector.length;i+=1){
			dos.writeFloat(vector[i]);
		}
	}
	
	/**
	 * Opens for update
	 * 
	 * @throws Exception An error
	 */
	public void openForUpdate() throws Exception{
		try{
			fos=new FileOutputStream(this.file,true);
			bos=new BufferedOutputStream(fos);
			dos=new DataOutputStream(bos);
		}catch(Exception e){
			log.error("Could not open writer. Throwing Exception",e);
			throw new Exception("Could not open writer");
		}
	}
	
	/**
	 * Adds an element
	 * 
	 * @param elem The element 
	 * @return if the write was successful or not
	 * @throws Exception An error
	 */
	public boolean addElement(FeatureVectorElement elem) throws Exception{
		try{
			if(elem.getId().length()!= this.idlength || elem.getVector().length!=this.vectorlength){
				return false;
			}
			this.write(elem.getId());
			this.write(elem.getVector());
			return true;
		}catch(Exception e){
			log.error("Could not add vector element. Throwing Exception",e);
			throw new Exception("Could not add vector element");
		}
	}
	
	/**
	 * Closes
	 * 
	 * @throws Exception An error
	 */
	public void close() throws Exception{
		try{
			dos.flush();
			if(fos!=null) fos.close();
			if(dos!=null) dos.close();
			if(bos!=null) bos.close();
		}catch(Exception e){
			log.error("Could not close writer. throwing Exception",e);
			throw new Exception("Could not close writer");
		}
	}
}
