/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.geo;

import java.util.ArrayList;
import org.gcube.indexmanagement.geo.InclusionType;
import org.gcube.indexmanagement.geo.RankingRequest;
import org.gcube.indexmanagement.geo.RefinementRequest;
import org.gcube.indexmanagement.geo.shape.Polygon;

public class GeoGcqlCollectionQuery {
    private boolean not;
    private InclusionType inclusion;
    private Polygon searchPolygon;
    private ArrayList<RefinementRequest> refineRequests = new ArrayList();
    private RankingRequest rankRequest;

    public GeoGcqlCollectionQuery(InclusionType inclusion, Polygon searchPolygon, ArrayList<RefinementRequest> refineRequests, RankingRequest rankRequest, boolean not) {
        this.setInclusion(inclusion);
        this.setSearchPolygon(searchPolygon);
        this.setRefineRequests(refineRequests);
        this.setRankRequest(rankRequest);
        this.setNot(not);
    }

    public void setInclusion(InclusionType inclusion) {
        this.inclusion = inclusion;
    }

    public InclusionType getInclusion() {
        return this.inclusion;
    }

    public void setSearchPolygon(Polygon searchPolygon) {
        this.searchPolygon = searchPolygon;
    }

    public Polygon getSearchPolygon() {
        return this.searchPolygon;
    }

    public void setRefineRequests(ArrayList<RefinementRequest> refineRequests) {
        this.refineRequests = refineRequests;
    }

    public void addRefineRequests(RefinementRequest refineRequest) {
        this.refineRequests.add(refineRequest);
    }

    public ArrayList<RefinementRequest> getRefineRequests() {
        return this.refineRequests;
    }

    public void setRankRequest(RankingRequest rankRequest) {
        this.rankRequest = rankRequest;
    }

    public RankingRequest getRankRequest() {
        return this.rankRequest;
    }

    public void setNot(boolean not) {
        this.not = not;
    }

    public boolean isNot() {
        return this.not;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("not: " + this.not);
        if (this.inclusion != null) {
            builder.append(" - inclusion: " + (Object)((Object)this.inclusion));
        }
        if (this.searchPolygon != null) {
            builder.append(" - Polygon: " + this.searchPolygon);
        }
        for (RefinementRequest req : this.refineRequests) {
            builder.append(" - refinerRequest: " + req.toString());
        }
        if (this.rankRequest != null) {
            builder.append(" - rankingRequest: " + this.rankRequest.toString());
        }
        return builder.toString();
    }
}

