package org.gcube.indexmanagement.lucenewrapper;

import java.util.Vector;

import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.gcube.indexmanagement.common.FullTextIndexType;
import org.gcube.indexmanagement.common.IndexException;
import org.gcube.indexmanagement.common.linguistics.lemmatizerplugin.Language;
import org.gcube.indexmanagement.common.linguistics.lemmatizerplugin.LemmatizerFactory;
import org.gcube.indexmanagement.common.linguistics.lemmatizerplugin.LemmatizerPlugin;

public class ParserTesting {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		
		try {
//			LemmatizerPlugin lepl = null;
//            Vector<Language> languages = new Vector<Language>();
//            lepl = LemmatizerFactory.loadPlugin("DummyLemmatizerPlugin");
//            
//            languages.add(Language.en);
//            languages.add(Language.it);
//            languages.add(Language.fr);
//            languages.add(Language.es);
//            languages.add(Language.de);
////              languages.add(Language.sv);
////              languages.add(Language.af);
//            lepl.init("/have/no/idea",languages);     
//			StandardAnalyzer analyzer = new StandardAnalyzer(new String[0]);
			StandardAnalyzer analyzer = new StandardAnalyzer();
			QueryParser defaultParser = new QueryParser("_contents", analyzer);
//			LuceneSearcher ls = new LuceneSearcher("org.gcube.indexmanagement.common.linguistics.lemmatizerplugin.DummyLemmatizerPlugin","/have/no/idea",Language.en);
			LuceneSearcher ls = new LuceneSearcher("org.gcube.indexmanagement.common.linguistics.lemmatizerplugin.SnowballStemmingPlugin","/have/no/idea",Language.en);
			
			ls.fieldNames.add("foo_field");
//			ls.setIndexType(new FullTextIndexType("foo",null));
			String queryString = "_querylang_en: \"europe and asia\" AND cats";
			Boolean  onlyLemmatize = false;
			String defaultLang = "en";
			
			if (queryString.startsWith("_querylang_") || queryString.startsWith("_querylemlang_")){
                int langStart;
                if(queryString.startsWith("_querylang_")){
                    langStart = 11;
                    onlyLemmatize = false;
                }
                else{
                    langStart = 14;
                    onlyLemmatize = true;
                }
                int prefixEnd = queryString.indexOf(':');
                defaultLang = queryString.substring(langStart, prefixEnd);
                System.out.println("Default lang = "+defaultLang);
                queryString = queryString.substring(prefixEnd + 1);
                
            }  

			String ex_query = ls.expandQuery(queryString, defaultLang, defaultLang, onlyLemmatize);
			
            System.out.println("Query: " + queryString);
 			System.out.println("XQuery: " + ex_query);
	//		ex_query = ls.sanitizeQuery(ex_query);
	//		Query query = defaultParser.parse(ex_query);
            System.out.println("Query: " + queryString);
            
 	//		System.out.println("XQuery: " + ex_query);
			System.out.println("Test OK");
		} catch (Exception e) {
			if (e.getMessage().contains("Cannot parse '':"))
				System.out.println("Empty Query String");

			e.printStackTrace();
			System.out.println("Test Failed");
		}
	}

}
