/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.lucenewrapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleFragmenter;
import org.gcube.common.core.utils.logging.GCUBELog;

public class HighlighterWrapper {
    static GCUBELog logger = new GCUBELog(HighlighterWrapper.class);
    private Integer snippetSize = 150;
    private Integer maximumSnippetsCount = 10;
    private IndexReader indexReader;

    public HighlighterWrapper(IndexReader indexReader) {
        this.indexReader = indexReader;
    }

    public Integer getSnippetSize() {
        return this.snippetSize;
    }

    public void setSnippetSize(Integer snippetSize) {
        this.snippetSize = snippetSize;
    }

    public Integer getMaximumSnippetsCount() {
        return this.maximumSnippetsCount;
    }

    public void setMaximumSnippetsCount(Integer maximumSnippetsCount) {
        this.maximumSnippetsCount = maximumSnippetsCount;
    }

    public IndexReader getIndexReader() {
        return this.indexReader;
    }

    public void setIndexReader(IndexReader indexReader) {
        this.indexReader = indexReader;
    }

    private List<String> getSnippets(String field, String text, String queryString) throws Exception {
        logger.info((Object)("Getting snippets for snippetSize : " + this.snippetSize + " , maximumSnippetsCount : " + this.maximumSnippetsCount));
        StandardAnalyzer analyzer = new StandardAnalyzer();
        QueryParser parser = new QueryParser(field, (Analyzer)analyzer);
        Query query = parser.parse(queryString);
        Query rewrittenQuery = query.rewrite(this.getIndexReader());
        Highlighter highlighter = new Highlighter((Scorer)new QueryScorer(rewrittenQuery));
        highlighter.setTextFragmenter((Fragmenter)new SimpleFragmenter(this.snippetSize.intValue()));
        return Arrays.asList(highlighter.getBestFragments((Analyzer)analyzer, field, text, this.maximumSnippetsCount.intValue()));
    }

    public List<String> getDocSnippets(Document doc, HashMap<String, ArrayList<String>> queryMap) throws Exception {
        ArrayList<String> snippets = new ArrayList<String>();
        for (Map.Entry<String, ArrayList<String>> e : queryMap.entrySet()) {
            String field = e.getKey();
            String text = doc.get(field);
            if (text == null) continue;
            String query = this.getQueryFromEntries((List<String>)e.getValue());
            try {
                snippets.addAll(this.getSnippets(field, text, query));
            }
            catch (Exception ex) {
                throw new Exception("Error while getting snippets", ex);
            }
        }
        return snippets;
    }

    private String getQueryFromEntries(List<String> entries) {
        StringBuffer strbuf = new StringBuffer("");
        for (String entry : entries) {
            strbuf.append(entry);
            strbuf.append(" ");
        }
        return strbuf.toString();
    }

    public static String getSnippetString(List<String> snippets) {
        StringBuffer strbuf = new StringBuffer("");
        if (snippets.size() > 0) {
            strbuf.append("...");
        }
        for (String snippet : snippets) {
            strbuf.append(snippet);
            strbuf.append("...");
        }
        return strbuf.toString();
    }
}

