/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.featureindexlibrary.fullscan;

import java.util.ArrayList;
import java.util.Calendar;
import org.apache.log4j.Logger;
import org.gcube.indexmanagement.featureindexlibrary.commons.DistanceCalculation;
import org.gcube.indexmanagement.featureindexlibrary.commons.FIEnums;
import org.gcube.indexmanagement.featureindexlibrary.commons.FeatureIndex;
import org.gcube.indexmanagement.featureindexlibrary.commons.FeatureVectorElement;
import org.gcube.indexmanagement.featureindexlibrary.commons.FileHelper;
import org.gcube.indexmanagement.featureindexlibrary.commons.LookupBuffer;
import org.gcube.indexmanagement.featureindexlibrary.commons.LookupParams;
import org.gcube.indexmanagement.featureindexlibrary.commons.RankedResultElement;
import org.gcube.indexmanagement.featureindexlibrary.fullscan.FullScanParams;
import org.gcube.indexmanagement.featureindexlibrary.fullscan.FullScanReader;
import org.gcube.indexmanagement.featureindexlibrary.fullscan.FullScanWriter;

public class FullVectorScan
implements FeatureIndex {
    private static final Object lockMe = new Object();
    private static Logger logger = Logger.getLogger(FullVectorScan.class);
    private FullScanParams charact = null;

    public FullVectorScan(FullScanParams charact) throws Exception {
        try {
            this.charact = charact;
            if (this.charact.getDistanceMeasure().compareTo(FIEnums.DistanceTypes.Default) == 0) {
                logger.error((Object)"Cannot initialize index with default distance measure. throwing exception");
                throw new Exception("Cannot initialize index with default distance measure");
            }
            if (FileHelper.existsFullScanFile(charact.getStorage(), charact.getIndexID())) {
                FullScanReader reader = new FullScanReader(FileHelper.getFullScanFile(charact.getStorage(), charact.getIndexID()));
                this.charact = reader.getCharacteristics();
                reader.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Could not initialize FullVectorSan. Throwinbg Exception", (Throwable)e);
            throw new Exception("Could not initialize FullVectorSan");
        }
    }

    @Override
    public long getNumberOfElements() {
        return this.charact.getElementCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFeatureVector(FeatureVectorElement elem) throws Exception {
        Object object = lockMe;
        synchronized (object) {
            FullScanWriter writer = new FullScanWriter(this.charact);
            try {
                writer.openForUpdate(FileHelper.getFullScanBufferFile(this.charact.getStorage(), this.charact.getIndexID()));
                writer.writeEntry(elem);
                writer.close();
            }
            catch (Exception e) {
                if (writer != null) {
                    writer.close();
                }
                logger.error((Object)"Could not add vector. Throwinbg Exception", (Throwable)e);
                throw new Exception("Could not add vector");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFeatureVector(FeatureVectorElement[] elem) throws Exception {
        Object object = lockMe;
        synchronized (object) {
            FullScanWriter writer = new FullScanWriter(this.charact);
            try {
                writer.openForUpdate(FileHelper.getFullScanBufferFile(this.charact.getStorage(), this.charact.getIndexID()));
                for (int i = 0; i < elem.length; ++i) {
                    writer.writeEntry(elem[i]);
                }
            }
            catch (Exception e) {
                if (writer != null) {
                    writer.close();
                }
                logger.error((Object)"Could not add vector. Throwinbg Exception", (Throwable)e);
                throw new Exception("Could not add vector");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws Exception {
        Object object = lockMe;
        synchronized (object) {
            if (!FileHelper.existsFullScanBufferFile(this.charact.getStorage(), this.charact.getIndexID())) {
                return;
            }
            FullScanWriter writer = null;
            FullScanReader reader = null;
            try {
                FeatureVectorElement elem;
                writer = new FullScanWriter(this.charact);
                reader = new FullScanReader(FileHelper.getFullScanBufferFile(this.charact.getStorage(), this.charact.getIndexID()));
                if (!FileHelper.existsFullScanFile(this.charact.getStorage(), this.charact.getIndexID())) {
                    writer.writeHead(FileHelper.getFullScanFile(this.charact.getStorage(), this.charact.getIndexID()));
                }
                writer.openForUpdate(FileHelper.getFullScanFile(this.charact.getStorage(), this.charact.getIndexID()));
                long count = this.charact.getElementCount();
                while ((elem = reader.getElement()) != null) {
                    writer.writeEntry(elem);
                    ++count;
                }
                reader.close();
                writer.close();
                this.charact.setElementCount(count);
                writer.writeHead(FileHelper.getFullScanFile(this.charact.getStorage(), this.charact.getIndexID()));
                FileHelper.removeFullScanBufferFile(this.charact.getStorage(), this.charact.getIndexID());
            }
            catch (Exception e) {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
                FileHelper.removeFullScanBufferFile(this.charact.getStorage(), this.charact.getIndexID());
                logger.error((Object)"Could not commit vector. Throwinbg Exception", (Throwable)e);
                throw new Exception("Could not commit vector");
            }
        }
    }

    @Override
    public ArrayList<RankedResultElement> lookup(float[] vector, int k) throws Exception {
        return this.lookup(vector, k, new LookupParams(FIEnums.AlgoType.Default, FIEnums.DistanceTypes.Default, false));
    }

    @Override
    public ArrayList<RankedResultElement> lookup(float[] vector, int k, LookupParams params) throws Exception {
        if (!FileHelper.existsFullScanFile(this.charact.getStorage(), this.charact.getIndexID())) {
            return new ArrayList<RankedResultElement>();
        }
        params.setWeighted(false);
        FullScanReader reader = null;
        try {
            long now = Calendar.getInstance().getTimeInMillis();
            long dtotal = 0L;
            long btotal = 0L;
            LookupBuffer buffer = new LookupBuffer(k);
            reader = new FullScanReader(FileHelper.getFullScanFile(this.charact.getStorage(), this.charact.getIndexID()));
            reader.getCharacteristics();
            FeatureVectorElement elem = null;
            float threshold = Float.MAX_VALUE;
            while ((elem = reader.getElement()) != null) {
                long dnow = Calendar.getInstance().getTimeInMillis();
                FIEnums.DistanceTypes distMeasure = this.charact.getDistanceMeasure();
                if (params.getDist().compareTo(FIEnums.DistanceTypes.Default) != 0) {
                    distMeasure = params.getDist();
                }
                float distance = DistanceCalculation.distance(vector, elem.getVector(), threshold, distMeasure);
                dtotal += Calendar.getInstance().getTimeInMillis() - dnow;
                long bnow = Calendar.getInstance().getTimeInMillis();
                if (distance != threshold) {
                    threshold = buffer.process(new RankedResultElement(elem.getId(), distance));
                }
                btotal += Calendar.getInstance().getTimeInMillis() - bnow;
            }
            logger.info((Object)("distance calculations took in total " + dtotal + " miliseconds"));
            logger.info((Object)("buffer calculations took in total " + btotal + " miliseconds"));
            logger.info((Object)("lookup took in total " + (Calendar.getInstance().getTimeInMillis() - now) + " miliseconds"));
            return buffer.getResults(this.charact.getIndexName());
        }
        catch (Exception e) {
            if (reader != null) {
                reader.close();
            }
            logger.error((Object)"Could not perform lookup. throwing Exception", (Throwable)e);
            throw new Exception("Could not perform lookup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEntry(String id) throws Exception {
        Object object = lockMe;
        synchronized (object) {
            try {
                FullScanWriter writer = new FullScanWriter(this.charact);
                writer.removeEntry(id, FileHelper.getFullScanFile(this.charact.getStorage(), this.charact.getIndexID()));
            }
            catch (Exception e) {
                logger.error((Object)"Could not remove entry. throwing Exception", (Throwable)e);
                throw new Exception("Could not remove entry");
            }
        }
    }

    @Override
    public String getIndexID() throws Exception {
        return this.charact.getIndexID();
    }
}

