/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.geo;

import com.vividsolutions.jts.geom.Envelope;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.HashMap;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.common.IndexException;
import org.gcube.indexmanagement.geo.GeoIndexField;
import org.gcube.indexmanagement.geo.GeoIndexType;
import org.gcube.indexmanagement.geo.shape.Rectangle;
import org.geotools.index.Data;
import org.geotools.index.DataDefinition;

public class DataWrapper {
    public static final String OFFSET_SEPARATOR = ":";
    public static final String DEFAULT_CHARSET = "UTF-8";
    static GCUBELog logger = new GCUBELog(DataWrapper.class);
    private HashMap<String, String> fieldsMap = new HashMap();
    private Data data;
    private String colID;
    private String colLang;
    private long x1;
    private long x2;
    private long y1;
    private long y2;
    private String id;
    private GeoIndexType indexTypeObject;

    private DataWrapper(GeoIndexType indexTypeObject, Data data) {
        this.data = data;
        this.x1 = (Long)data.getValue(0);
        this.x2 = (Long)data.getValue(1);
        this.y1 = (Long)data.getValue(2);
        this.y2 = (Long)data.getValue(3);
        this.id = (String)data.getValue(4);
        this.indexTypeObject = indexTypeObject;
    }

    private DataWrapper(GeoIndexType indexTypeObject, Data data, RandomAccessFile rawDataFile) throws Exception {
        this.data = data;
        this.x1 = (Long)data.getValue(0);
        this.x2 = (Long)data.getValue(1);
        this.y1 = (Long)data.getValue(2);
        this.y2 = (Long)data.getValue(3);
        this.id = (String)data.getValue(4);
        String allFields = DataWrapper.getFromFile((String)data.getValue(5), rawDataFile);
        this.fieldsMap = DataWrapper.parseFieldString(allFields);
        this.indexTypeObject = indexTypeObject;
    }

    private DataWrapper(String colIdString, String colLangString, GeoIndexType indexTypeObject, Data geoData, HashMap<String, String> fieldsMap) {
        this(indexTypeObject, geoData);
        this.colID = colIdString;
        this.colLang = colLangString;
        this.fieldsMap = fieldsMap;
    }

    public long getMinX() {
        return this.x1;
    }

    public long getMaxX() {
        return this.x2;
    }

    public long getMinY() {
        return this.y1;
    }

    public long getMaxY() {
        return this.y2;
    }

    public String getID() {
        return this.id;
    }

    public Data getData() {
        return this.data;
    }

    public Envelope getMbr() {
        return new Envelope((double)this.x1, (double)this.x2, (double)this.y1, (double)this.y2);
    }

    public Object getValue(String fieldName) {
        return this.fieldsMap.get(fieldName);
    }

    public static DataWrapper getInstance(GeoIndexType indexTypeObject, Data data, RandomAccessFile rawDataFile) throws Exception {
        return new DataWrapper(indexTypeObject, data, rawDataFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataWrapper getInstance(GeoIndexType indexTypeObject, ReadableByteChannel inChannel, RandomAccessFile rawDataFile) throws IndexException {
        try {
            int length;
            long offset;
            ByteBuffer countBuffer = ByteBuffer.allocate(4);
            if (inChannel.read(countBuffer) == -1) {
                return null;
            }
            countBuffer.flip();
            int idSize = countBuffer.getInt();
            ByteBuffer buffer = ByteBuffer.allocate(idSize);
            inChannel.read(buffer);
            buffer.flip();
            byte[] charArray = new byte[idSize];
            buffer.get(charArray);
            ByteBuffer chars = ByteBuffer.wrap(charArray);
            Charset western = Charset.forName("ISO-8859-1");
            CharsetDecoder isoDecoder = western.newDecoder();
            String colIdString = null;
            colIdString = new String(isoDecoder.decode(chars).array());
            logger.trace((Object)("read ColID: " + colIdString));
            countBuffer = ByteBuffer.allocate(4);
            if (inChannel.read(countBuffer) == -1) {
                return null;
            }
            countBuffer.flip();
            idSize = countBuffer.getInt();
            buffer = ByteBuffer.allocate(idSize);
            inChannel.read(buffer);
            buffer.flip();
            charArray = new byte[idSize];
            buffer.get(charArray);
            chars = ByteBuffer.wrap(charArray);
            String colLangString = null;
            colLangString = new String(isoDecoder.decode(chars).array());
            logger.trace((Object)("read ColLang: " + colLangString));
            countBuffer = ByteBuffer.allocate(4);
            if (inChannel.read(countBuffer) == -1) {
                return null;
            }
            countBuffer.flip();
            idSize = countBuffer.getInt();
            buffer = ByteBuffer.allocate(idSize + 32);
            inChannel.read(buffer);
            buffer.flip();
            charArray = new byte[idSize];
            buffer.get(charArray);
            chars = ByteBuffer.wrap(charArray);
            String idString = null;
            idString = new String(isoDecoder.decode(chars).array());
            logger.trace((Object)("read ID: " + idString));
            Rectangle rect = new Rectangle(buffer.getLong(), buffer.getLong(), buffer.getLong(), buffer.getLong());
            logger.trace((Object)("read rect: " + rect.toString()));
            countBuffer = ByteBuffer.allocate(4);
            if (inChannel.read(countBuffer) == -1) {
                return null;
            }
            countBuffer.flip();
            idSize = countBuffer.getInt();
            buffer = ByteBuffer.allocate(idSize);
            inChannel.read(buffer);
            buffer.flip();
            charArray = new byte[idSize];
            buffer.get(charArray);
            chars = ByteBuffer.wrap(charArray);
            String allFields = null;
            allFields = new String(isoDecoder.decode(chars).array());
            logger.trace((Object)("read allFields: " + allFields));
            HashMap<String, String> fields = DataWrapper.parseFieldString(allFields);
            for (String fieldName : fields.keySet()) {
                if (indexTypeObject.getFieldPosition(fieldName) != null) continue;
                logger.error((Object)("The geo index lookup received a field with name : " + fieldName + ", that is not declared in the geoindexType." + " All fields String: " + allFields));
                throw new IndexException("The geo index lookup received a field with name : " + fieldName + ", that is not declared in the geoindexType.");
            }
            Data geoData = new Data(DataWrapper.createDefinition());
            geoData.addValue((Object)rect.getMinX());
            geoData.addValue((Object)rect.getMaxX());
            geoData.addValue((Object)rect.getMinY());
            geoData.addValue((Object)rect.getMaxY());
            geoData.addValue((Object)idString);
            RandomAccessFile randomAccessFile = rawDataFile;
            synchronized (randomAccessFile) {
                rawDataFile.seek(rawDataFile.length());
                offset = rawDataFile.getFilePointer();
                byte[] byteArray = allFields.getBytes(DEFAULT_CHARSET);
                length = byteArray.length;
                rawDataFile.write(byteArray);
            }
            String position = "" + offset + OFFSET_SEPARATOR + length;
            geoData.addValue((Object)position);
            return new DataWrapper(colIdString, colLangString, indexTypeObject, geoData, fields);
        }
        catch (Exception e) {
            logger.error((Object)"Error while getting DataWrapper instance.", (Throwable)e);
            throw new IndexException(e);
        }
    }

    private static DataDefinition createDefinition(GeoIndexType indexTypeObject) {
        DataDefinition df = new DataDefinition("ISO-8859-1");
        df.addField(Long.class);
        df.addField(Long.class);
        df.addField(Long.class);
        df.addField(Long.class);
        df.addField(GeoIndexField.DataType.STRING.getDefaultSize());
        for (GeoIndexField field : indexTypeObject.fields) {
            if (!field.dataType.equals((Object)GeoIndexField.DataType.STRING)) {
                df.addField(field.dataType.getTypeClass());
                continue;
            }
            df.addField(field.size);
        }
        return df;
    }

    public static DataDefinition createDefinition() {
        DataDefinition df = new DataDefinition("ISO-8859-1");
        df.addField(Long.class);
        df.addField(Long.class);
        df.addField(Long.class);
        df.addField(Long.class);
        df.addField(GeoIndexField.DataType.STRING.getDefaultSize());
        df.addField(GeoIndexField.DataType.STRING.getDefaultSize());
        return df;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFromFile(String value, RandomAccessFile rawData) throws Exception {
        int off;
        int separator = value.indexOf(OFFSET_SEPARATOR);
        if (separator == -1) {
            throw new Exception("in all fields we have stored: " + value);
        }
        long offset = Long.parseLong(value.substring(0, separator));
        int length = Integer.parseInt(value.substring(separator + 1));
        byte[] bytes = new byte[length];
        RandomAccessFile randomAccessFile = rawData;
        synchronized (randomAccessFile) {
            rawData.seek(offset);
            int numRead = 0;
            for (off = 0; off < bytes.length && (numRead = rawData.read(bytes, off, bytes.length - off)) >= 0; off += numRead) {
            }
        }
        if (off < bytes.length) {
            throw new Exception("Could not completely read raw data file. Read: " + off + ", Length: " + bytes.length);
        }
        String fieldData = new String(bytes, DEFAULT_CHARSET);
        logger.debug((Object)("Variable field.  Data stored in Rtree: " + value + ", Offset: " + offset + ", Length: " + length + ", fieldData: " + fieldData));
        return fieldData;
    }

    private static HashMap<String, String> parseFieldString(String allFields) throws Exception {
        String currentString = allFields;
        HashMap<String, String> ret = new HashMap<String, String>();
        while (currentString.length() > 0) {
            int separator = currentString.indexOf(OFFSET_SEPARATOR);
            if (separator == -1) {
                throw new Exception("the all fields String we have stored: " + allFields);
            }
            int size = Integer.parseInt(currentString.substring(0, separator));
            String fieldName = currentString.substring(separator + 1, separator + 1 + size);
            if ((separator = (currentString = currentString.substring(separator + 1 + size)).indexOf(OFFSET_SEPARATOR)) == -1) {
                throw new Exception("the all fields String we have stored: " + allFields);
            }
            size = Integer.parseInt(currentString.substring(0, separator));
            String fieldData = currentString.substring(separator + 1, separator + 1 + size);
            String oldContent = ret.get(fieldName);
            if (oldContent != null) {
                ret.put(fieldName, oldContent + fieldData);
            } else {
                ret.put(fieldName, fieldData);
            }
            currentString = currentString.substring(separator + 1 + size);
        }
        return ret;
    }

    public String getColID() {
        return this.colID;
    }

    public String getColLang() {
        return this.colLang;
    }
}

