/*
 * LanguageIdFactory.java
 *
 * $Author: tsakas $
 * $Date: 2007/12/20 14:37:39 $
 * $Id: LanguageIdFactory.java,v 1.1 2007/12/20 14:37:39 tsakas Exp $
 *
 * <pre>
 *             Copyright (c) : 2006 Fast Search & Transfer ASA
 *                             ALL RIGHTS RESERVED
 * </pre>
 */

package org.gcube.indexmanagement.common.linguistics.languageidplugin;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.common.IndexException;

/**
 * This class loads the real implementation of the language id module.
 */
public class LanguageIdFactory {

	/** logger */
	static GCUBELog logger = new GCUBELog(LanguageIdFactory.class);
	
    /**
     * Private constructor. This class can not be instantiated.
     */
    private LanguageIdFactory() {
    }

    /**
     * This method loads the plugin for the language identifier and calls the init.
     * method with the configFile as a parameter.
     * @param pluginName        The name of the plugin to be loaded.
     *                          The plugin must implement the interface LanguageIdPlugin
     * @return                  The langid plugin that was instanciated
     * @throws IndexException   The IndexException is thrown in case the class
     *                          can not be loaded or initialized.
     */
    public static LanguageIdPlugin loadPlugin(String pluginName) throws IndexException  {
        try {
            logger.debug("LanguageIdFactory::loadPlugin loading: " + pluginName);
            LanguageIdPlugin languageIdPlugin = (LanguageIdPlugin)Class.forName(pluginName).newInstance();
            return languageIdPlugin;
        }
        catch(Exception e){
            throw new IndexException("Class load error, pluginName "
                                     + pluginName
                                     + " Exception: "
                                     + e.toString());
        }
    }
}
