/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.common.notifications;

import java.util.LinkedList;
import java.util.List;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.indexmanagement.common.notifications.IsRegisteredCallback;
import org.gcube.indexmanagement.common.notifications.NotifierRequest;
import org.gcube.indexmanagement.common.notifications.NotifierRequestQueue;

public class IsRegisteredNotificationRequest
extends NotifierRequest {
    private List<ISNotifier.TopicData> topicList;
    private IsRegisteredCallback callback;

    public IsRegisteredNotificationRequest(List<ISNotifier.TopicData> topicList, GCUBEServiceContext sctx, GCUBEScope scope, IsRegisteredCallback callback) {
        super(null, sctx, scope);
        this.topicList = new LinkedList<ISNotifier.TopicData>(topicList);
        this.callback = callback;
    }

    @Override
    public void doRequest() {
        ISNotifier notifier = NotifierRequestQueue.getInstance().getNotifier();
        boolean bRetry = true;
        while (bRetry) {
            try {
                boolean[] result = notifier.isTopicRegistered((GCUBESecurityManager)this.sctx, this.scope, this.topicList);
                this.callback.isRegisteredResponse(result);
                bRetry = false;
            }
            catch (Exception e) {
                logger.warn((Object)"Exception while querying for topic registration completion topics. Retrying...", (Throwable)e);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {}
            }
        }
    }
}

