package org.gcube.indexmanagement.featureindexlibrary.commons;

/**
 * Lookup parameters
 * 
 * @author UoA
 */
public class LookupParams {
	/**
	 * The lookup algorithm to use 
	 */
	private FIEnums.AlgoType algo=FIEnums.AlgoType.Default;
	/**
	 * The distance to use
	 */
	private FIEnums.DistanceTypes dist=FIEnums.DistanceTypes.Eukledian;
	/**
	 * use weights
	 */
	private boolean weighted=true;
	
	/**
	 * Creates a new instance
	 * 
	 * @param algo The lookup algorithm to use
	 * @param dist The distance to use
	 * @param weighted use weights
	 */
	public LookupParams(FIEnums.AlgoType algo,FIEnums.DistanceTypes dist,boolean weighted){
		this.algo=algo;
		this.dist=dist;
	}

	/**
	 * Retreves the algorithm
	 * 
	 * @return The algorithm
	 */
	public FIEnums.AlgoType getAlgo() {
		return algo;
	}

	/**
	 * Sets teh algorithm
	 * 
	 * @param algo The algorithm
	 */
	public void setAlgo(FIEnums.AlgoType algo) {
		this.algo = algo;
	}

	/**
	 * Retrieves teh distance measure
	 * 
	 * @return The distnace measure
	 */
	public FIEnums.DistanceTypes getDist() {
		return dist;
	}

	/**
	 * Sets the distance measure
	 * 
	 * @param dist The distance measure
	 */
	public void setDist(FIEnums.DistanceTypes dist) {
		this.dist = dist;
	}

	/**
	 * Checks if weights are used
	 * 
	 * @return <code>true</code> if weights are used, <code>false</code> otherwise
	 */
	public boolean isWeighted() {
		return weighted;
	}

	/**
	 * Sets if weights should be used
	 * 
	 * @param weighted <code>true</code>, or <code>false</code>
	 */
	public void setWeighted(boolean weighted) {
		this.weighted = weighted;
	}
}
