/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.geo.shape;

import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.geo.shape.Point;
import org.gcube.indexmanagement.geo.shape.Polygon;

public class PolygonProcessing {
    static GCUBELog logger = new GCUBELog(PolygonProcessing.class);

    public static Polygon intersection(Polygon a, Polygon b) {
        Area areaA = new Area(PolygonProcessing.transformPolygon2Polygon(a));
        Area areaB = new Area(PolygonProcessing.transformPolygon2Polygon(b));
        areaA.intersect(areaB);
        return PolygonProcessing.constructPolygonFromArea(areaA);
    }

    public static Polygon union(Polygon a, Polygon b) {
        Area areaA = new Area(PolygonProcessing.transformPolygon2Polygon(a));
        Area areaB = new Area(PolygonProcessing.transformPolygon2Polygon(b));
        areaA.add(areaB);
        return PolygonProcessing.constructPolygonFromArea(areaA);
    }

    public static boolean isContained(Polygon internal, Polygon external) {
        Area areaExt = new Area(PolygonProcessing.transformPolygon2Polygon(external));
        Area areaInt = new Area(PolygonProcessing.transformPolygon2Polygon(internal));
        return PolygonProcessing.isContained(areaInt, areaExt);
    }

    public static boolean overlaps(Polygon a, Polygon b) {
        return PolygonProcessing.intersection(a, b).getVertices().size() != 0;
    }

    private static java.awt.Polygon transformPolygon2Polygon(Polygon poly) {
        Point[] vertices = poly.getVertexArray();
        int npoints = vertices.length;
        int[] xpoints = new int[npoints];
        int[] ypoints = new int[npoints];
        for (int i = 0; i < npoints; ++i) {
            long x = vertices[i].getX();
            if (x > Integer.MAX_VALUE) {
                logger.error((Object)("coordinate: " + x + ", is larger than the max int value.."));
            }
            xpoints[i] = (int)x;
            long y = vertices[i].getY();
            if (y > Integer.MAX_VALUE) {
                logger.error((Object)("coordinate: " + y + ", is larger than the max int value.."));
            }
            ypoints[i] = (int)y;
        }
        return new java.awt.Polygon(xpoints, ypoints, npoints);
    }

    private static Polygon constructPolygonFromArea(Area a) {
        PathIterator iter = a.getPathIterator(new AffineTransform());
        ArrayList<Point> vertices = new ArrayList<Point>();
        while (!iter.isDone()) {
            float[] coords = new float[6];
            Point p = null;
            switch (iter.currentSegment(coords)) {
                case 0: {
                    p = new Point((long)coords[0], (long)coords[1]);
                    break;
                }
                case 1: {
                    p = new Point((long)coords[0], (long)coords[1]);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    logger.error((Object)"This case is not predicted here! This means that we have a bug!");
                }
            }
            if (p != null) {
                vertices.add(p);
            }
            iter.next();
        }
        if (vertices.size() == 0) {
            return null;
        }
        return new Polygon(vertices);
    }

    public static void main(String[] args) {
        Point[] verticesA = new Point[]{new Point(2L, 2L), new Point(5L, 4L), new Point(6L, 4L), new Point(10L, 2L), new Point(6L, 1L), new Point(5L, 1L)};
        Point[] verticesB = new Point[]{new Point(5L, 5L), new Point(6L, 5L), new Point(6L, 2L), new Point(5L, 2L)};
        Point[] verticesC = new Point[]{new Point(5L, 5L), new Point(6L, 5L), new Point(6L, 7L), new Point(5L, 7L)};
        Polygon polyA = new Polygon(verticesA);
        Polygon polyB = new Polygon(verticesB);
        Polygon polyC = new Polygon(verticesC);
        Polygon result = PolygonProcessing.intersection(polyA, polyB);
        System.out.println("intersection: " + result.toString());
        result = PolygonProcessing.union(polyA, polyB);
        System.out.println("union: " + result.toString());
        if (PolygonProcessing.isContained(polyB, polyA)) {
            System.out.println("Is contained");
        } else {
            System.out.println("Is NOT contained");
        }
        if (PolygonProcessing.isContained(polyA, polyB)) {
            System.out.println("Is contained");
        } else {
            System.out.println("Is NOT contained");
        }
        if (PolygonProcessing.overlaps(polyA, polyB)) {
            System.out.println("Overlaps True");
        } else {
            System.out.println("Overlaps False");
        }
        if (PolygonProcessing.overlaps(polyA, polyC)) {
            System.out.println("Overlaps True");
        } else {
            System.out.println("Overlaps False");
        }
        if (PolygonProcessing.overlaps(polyB, polyC)) {
            System.out.println("Overlaps True");
        } else {
            System.out.println("Overlaps False");
        }
    }

    private static boolean isContained(Area internal, Area external) {
        external.intersect(internal);
        return internal.equals(external);
    }
}

