package org.gcube.indexmanagement.featureindexlibrary.vafile.elements;

/**
 * Entry used in vector file
 * 
 * @author UoA
 */
public class VectorFileEntry {
	/**
	 * The id
	 */
	private String id=null;
	/**
	 * The vector
	 */
	private float []vector=null;
	/**
	 * The record is active
	 */
	private boolean active=true;
	
	/**
	 * Creates a new instance
	 * 
	 * @param id The id
	 * @param vector The vector
	 * @param active wether the record is active or not
	 */
	public VectorFileEntry(String id,float []vector,boolean active){
		this.id=id;
		this.vector=vector;
		this.active=active;
	}

	/**
	 * Creates a new instance
	 * 
	 * @param id The id
	 * @param vector The vector
	 */
	public VectorFileEntry(String id,float []vector){
		this.id=id;
		this.vector=vector;
		this.active=true;
	}

	/**
	 * Property getter
	 * 
	 * @return The property
	 */
	public boolean isActive() {
		return active;
	}

	/**
	 * Property setter
	 * 
	 * @param active The property value
	 */
	public void setActive(boolean active) {
		this.active = active;
	}

	/**
	 * Property getter
	 * 
	 * @return The property
	 */
	public String getId() {
		return id;
	}

	/**
	 * Property setter
	 * 
	 * @param id The property value
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * Property getter
	 * 
	 * @return The property
	 */
	public float[] getVector() {
		return vector;
	}

	/**
	 * Property setter
	 * 
	 * @param vector The property value
	 */
	public void setVector(float[] vector) {
		this.vector = vector;
	}
}
