package org.gcube.indexmanagement.featureindexlibrary.commons;

import org.apache.log4j.Logger;
//import org.diligentproject.keeperservice.hnm.impl.NAL;

/**
 * Statistics container
 * 
 * @author UoA
 */
public class FeatureFactoryStatsContainer extends Thread {
	/**
	 * Logger used by the class
	 */
	private static Logger log = Logger.getLogger(FeatureIndexStatsContainer.class);
	/**
	 * Used for synchronization
	 */
	private Object lockMe=new Object();
	/**
	 * The service class
	 */
//	private String ServiceClass=null;
	/**
	 * The service name
	 */
//	private String ServiceName=null;
	/**
	 * Number of created indexes
	 */
	private long NumberOfIndexesCreated=0;
	/**
	 * Number of VAFile indexes
	 */
	private long NumberofVAFIles=0; 
	/**
	 * Number of Full Scans
	 */
	private long NumberOfFullScans=0;
	/**
	 * Number of merge
	 */
	private long NumberOfMerge=0;
	/**
	 * Mean merge time
	 */
	private long MeanMergeTime=0;
	/**
	 * Max merge time
	 */
	private long MaxMergeTime=0;
	/**
	 * Min merge time
	 */
	private long MinMergeTime=Long.MAX_VALUE;
	/**
	 * Mean merge results
	 */
	private long MeanMergeResults=0;
	/**
	 * Max Merge results
	 */
	private long MaxMergeResults=0;
	/**
	 * Min Merge Results
	 */
	private long MinMergeResults=Long.MAX_VALUE;

	/**
	 * Constructor
	 * 
	 * @param ServiceClass the Service class
	 * @param ServiceName the service name
	 */
	public FeatureFactoryStatsContainer(String ServiceClass, String ServiceName){
//		this.ServiceClass=ServiceClass;
//		this.ServiceName=ServiceName;
	}
	
	/**
	 * New Full Scann index
	 */
	public void newFullScan(){
		synchronized(lockMe){
			this.NumberOfIndexesCreated+=1;
			this.NumberOfFullScans+=1;
		}
	}
	
	/**
	 * New VAFile index
	 */
	public void newVAFile(){
		synchronized(lockMe){
			this.NumberOfIndexesCreated+=1;
			this.NumberofVAFIles+=1;
		}
	}
	
	/**
	 * New merge request
	 */
	public void newMerge(){
		synchronized(lockMe){
			this.NumberOfMerge+=1;
		}
	}
	
	/**
	 * merge time
	 * 
	 * @param time the time
	 */
	public void mergeTime(long time){
		synchronized(lockMe){
			if(this.MinMergeTime>time) this.MinMergeTime=time;
			if(this.MaxMergeTime<time) this.MaxMergeTime=time;
			if(this.NumberOfMerge!=0) this.MeanMergeTime=((this.MeanMergeTime*(this.NumberOfMerge-1)+time)/this.NumberOfMerge);
		}
	}

	/**
	 * merge results
	 * 
	 * @param results the results
	 */
	public void mergeResults(long results){
		synchronized(lockMe){
			if(this.MinMergeResults>results) this.MinMergeResults=results;
			if(this.MaxMergeResults<results) this.MaxMergeResults=results;
			if(this.NumberOfMerge!=0) this.MeanMergeResults=((this.MeanMergeResults*(this.NumberOfMerge-1)+results)/this.NumberOfMerge);
		}
	}

	/**
	 * Writes the statistics to the RI profile
	 * @throws Exception the ri could not be updated
	 */
	public void writeToRI() throws Exception{
		//NAL nal=new NAL();
		//nal.setSpecificData(this.ServiceClass,this.ServiceName,this.toXML());
		//nal.setSpecificData(this.ServiceName,this.ServiceClass,this.toXML());
		log.info("specific data : "+this.toXML());
	}
	
	/**
	 * @see java.lang.Runnable#run()
	 */
	public void run(){
		while(true){
			try{
				Thread.sleep(1200000); //20 minutes
			}catch(Exception e){}
			try{
				this.writeToRI();
			}catch(Exception e){
				log.error("could not update RI profile.continuing",e);
			}
		}
	}
	/**
	 * generates an xml serialization of the statistics
	 * 
	 * @return the xml serialization
	 */
	public String toXML(){
		StringBuilder buf=new StringBuilder();
		buf.append("<Statistics>");
		buf.append("<text>");
		buf.append("this section summarizes some statisitc information for the service since the last restart");
		buf.append("</text>");
		buf.append("<NumberOfIndexesCreated>");
		buf.append("<value>");
		buf.append(NumberOfIndexesCreated);
		buf.append("</value>");
		buf.append("<description>");
		buf.append("the total number of indexes created");
		buf.append("</description>");
		buf.append("</NumberOfIndexesCreated>");
		buf.append("<NumberofVAFIles>");
		buf.append("<value>");
		buf.append(NumberofVAFIles);
		buf.append("</value>");
		buf.append("<description>");
		buf.append("the total number of VAFile indexes created");
		buf.append("</description>");
		buf.append("</NumberofVAFIles>");
		buf.append("<NumberOfFullScans>");
		buf.append("<value>");
		buf.append(NumberOfFullScans);
		buf.append("</value>");
		buf.append("<description>");
		buf.append("the total number of FullScan indexes created");
		buf.append("</description>");
		buf.append("</NumberOfFullScans>");
		buf.append("<NumberOfMerge>");
		buf.append("<value>");
		buf.append(NumberOfMerge);
		buf.append("</value>");
		buf.append("<description>");
		buf.append("the total number of merge requests");
		buf.append("</description>");
		buf.append("</NumberOfMerge>");
		buf.append("<MeanMergeTime>");
		buf.append("<value>");
		buf.append(MeanMergeTime);
		buf.append("</value>");
		buf.append("<description>");
		buf.append("the mean time of merge requests");
		buf.append("</description>");
		buf.append("</MeanMergeTime>");
		buf.append("<MaxMergeTime>");
		buf.append("<value>");
		buf.append(MaxMergeTime);
		buf.append("</value>");
		buf.append("<description>");
		buf.append("the max time of merge requests");
		buf.append("</description>");
		buf.append("</MaxMergeTime>");
		buf.append("<MinMergeTime>");
		buf.append("<value>");
		buf.append(MinMergeTime);
		buf.append("</value>");
		buf.append("<description>");
		buf.append("the min time of merge requests");
		buf.append("</description>");
		buf.append("</MinMergeTime>");
		buf.append("<MeanMergeResults>");
		buf.append("<value>");
		buf.append(MeanMergeResults);
		buf.append("</value>");
		buf.append("<description>");
		buf.append("the mean results of merge requests");
		buf.append("</description>");
		buf.append("</MeanMergeResults>");
		buf.append("<MaxMergeResults>");
		buf.append("<value>");
		buf.append(MaxMergeResults);
		buf.append("</value>");
		buf.append("<description>");
		buf.append("the max results of merge requests");
		buf.append("</description>");
		buf.append("</MaxMergeResults>");
		buf.append("<MinMergeResults>");
		buf.append("<value>");
		buf.append(MinMergeResults);
		buf.append("</value>");
		buf.append("<description>");
		buf.append("the min results of merge requests");
		buf.append("</description>");
		buf.append("</MinMergeResults>");
		buf.append("</Statistics>");
		return buf.toString();
	}
}
