/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.lucenewrapper;

import java.util.HashSet;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.gcube.indexmanagement.lucenewrapper.QueryTerm;

public final class QueryTermFilter {
    public static final QueryTerm[] getTerms(Query query) {
        HashSet terms = new HashSet();
        QueryTermFilter.getTerms(query, terms);
        return terms.toArray(new QueryTerm[0]);
    }

    private static final void getTerms(Query query, HashSet terms) {
        if (query instanceof BooleanQuery) {
            BooleanQuery bq = (BooleanQuery)query;
            BooleanClause[] queryClauses = bq.getClauses();
            for (int i = 0; i < queryClauses.length; ++i) {
                if (queryClauses[i].getOccur() == BooleanClause.Occur.MUST_NOT) continue;
                QueryTermFilter.getTerms(queryClauses[i].getQuery(), terms);
            }
        } else if (query instanceof PhraseQuery) {
            PhraseQuery pq = (PhraseQuery)query;
            Term[] queryTerms = pq.getTerms();
            for (int i = 0; i < queryTerms.length; ++i) {
                terms.add(new QueryTerm(queryTerms[i].field(), queryTerms[i].text()));
            }
        } else if (query instanceof TermQuery) {
            TermQuery tq = (TermQuery)query;
            terms.add(new QueryTerm(tq.getTerm().field(), tq.getTerm().text()));
        } else if (query instanceof WildcardQuery) {
            WildcardQuery wq = (WildcardQuery)query;
            terms.add(new QueryTerm(wq.getTerm().field(), wq.getTerm().text()));
        } else if (query instanceof PrefixQuery) {
            PrefixQuery pq = (PrefixQuery)query;
            terms.add(new QueryTerm(pq.getPrefix().field(), pq.getPrefix().text()));
        } else if (query instanceof FuzzyQuery) {
            FuzzyQuery fq = (FuzzyQuery)query;
            terms.add(new QueryTerm(fq.getTerm().field(), fq.getTerm().text()));
        } else if (query instanceof RangeQuery) {
            RangeQuery rq = (RangeQuery)query;
            terms.add(new QueryTerm(rq.getLowerTerm().field(), rq.getLowerTerm().text()));
            terms.add(new QueryTerm(rq.getUpperTerm().field(), rq.getUpperTerm().text()));
        }
    }
}

