/**
 * 
 */
package org.gcube.indexmanagement.jdbmwrapper;

import java.text.DateFormat;
import java.util.Date;

/**
 * This class represents a date whose serialization is formed according to a custom
 * date format.
 * 
 * @author Spyros Boutsis, NKUA
 */
public class CustomDate extends Date implements java.io.Serializable {
	
	/** The custom formatter */
	private DateFormat format;
	
	/**
	 * Class constructor
	 * @param date the date represented by this object
	 * @param format the custom date format
	 */
	CustomDate(String sDate, DateFormat format) throws Exception {
		super(format.parse(sDate).getTime());
		this.format = format;
	}
	
	/*
	 * (non-Javadoc)
	 * @see java.util.Date#toString()
	 */
	public String toString() {
		return format.format(this);
	}
}
