package org.gcube.indexmanagement.geo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map.Entry;

import org.gcube.indexmanagement.gcqlwrapper.GcqlQueryContainer;

public class GeoGcqlQueryContainer extends GcqlQueryContainer{
	
	public HashMap<String, HashMap<String, ArrayList<GeoGcqlCollectionQuery>>> queries = new HashMap<String, HashMap<String,ArrayList<GeoGcqlCollectionQuery>>>();
	
	public GeoGcqlQueryContainer(LinkedHashMap<String, String> projectedFields) {
		super(projectedFields);
	}
	
	public QueriesContainer getArrayOfQueries() {
		
		ArrayList<String> colIDs =  new ArrayList<String>();
		ArrayList<String> langs = new ArrayList<String>();
		ArrayList<GeoGcqlCollectionQuery> colQueries = new ArrayList<GeoGcqlCollectionQuery>();
		
		Iterator<Entry<String,HashMap<String, ArrayList<GeoGcqlCollectionQuery>>>> outerIter
			= queries.entrySet().iterator();
		//for all the collection IDs
		while(outerIter.hasNext())
		{
			Entry<String,HashMap<String, ArrayList<GeoGcqlCollectionQuery>>> outerCurrent
				= outerIter.next();
			String colID = outerCurrent.getKey();
			HashMap<String, ArrayList<GeoGcqlCollectionQuery>> outerMap = outerCurrent.getValue();
			if(outerMap == null)
				continue;
			Iterator<Entry<String, ArrayList<GeoGcqlCollectionQuery>>> innerIter
				= outerMap.entrySet().iterator();
			//for all the languages
			while(innerIter.hasNext())
			{
				Entry<String, ArrayList<GeoGcqlCollectionQuery>> innerCurrent
					= innerIter.next();
				String lang = innerCurrent.getKey();
				ArrayList<GeoGcqlCollectionQuery> list = innerCurrent.getValue();
				if(list == null)
					continue;
				
				//for all the queries
				for(GeoGcqlCollectionQuery query : list) {
					colIDs.add(colID);
					langs.add(lang);
					colQueries.add(query);
				}
			}
		}
		
		return new QueriesContainer(colIDs, langs, colQueries);
	}
	
	/**
	 * Container class for queries. 3 array lists store in each position the colID, language 
	 * and query
	 * @author bill
	 *
	 */
	public static class QueriesContainer {
		private ArrayList<String> colIDs;
		private ArrayList<String> langs;
		private ArrayList<GeoGcqlCollectionQuery> queries;
		
		public QueriesContainer(ArrayList<String> colIDs, ArrayList<String> langs, 
				ArrayList<GeoGcqlCollectionQuery> queries) {
			this.colIDs = colIDs;
			this.langs = langs;
			this.queries = queries;
		}
		
		public ArrayList<String> getColIDs() {
			return colIDs;
		}
		
		public ArrayList<String> getLangs() {
			return langs;
		}
		
		public ArrayList<GeoGcqlCollectionQuery> getQueries() {
			return queries;
		}
	}

}
