package org.gcube.indexmanagement.featureindexlibrary.merger;

import java.util.Set;

/**
 * Element holding info on merged elements
 * 
 * @author UoA
 */
public class MergedResultElement {
	/**
	 * The id
	 */
	private String oid=null;
	/**
	 * The rank
	 */
	private float rank=0;
	/**
	 * The index names
	 */
	private Set<String> indexNames=null;
	
	/**
	 * Creates a new instance
	 * 
	 * @param oid the id
	 * @param rank The rank
	 * @param indexNames The index names
	 */
	public MergedResultElement(String oid,float rank,Set<String> indexNames){
		this.oid=oid;
		this.rank=rank;
		this.indexNames=indexNames;
	}

	/**
	 * Creates a new instance
	 * 
	 * @param oid the id
	 */
	public MergedResultElement(String oid){
		this.oid=oid;
		this.rank=0;
		this.indexNames=null;
	}

	/**
	 * Retrieves the index names
	 * 
	 * @return Te index names
	 */
	public Set<String> getIndexNames() {
		return indexNames;
	}

	/**
	 * Sets the index names
	 * 
	 * @param indexNames The index names
	 */
	public void setIndexNames(Set<String> indexNames) {
		this.indexNames = indexNames;
	}

	/**
	 * Retrieves the id
	 * 
	 * @return The id
	 */
	public String getId() {
		return oid;
	}

	/**
	 * Sets the id
	 * 
	 * @param oid The id
	 */
	public void setId(String oid) {
		this.oid = oid;
	}

	/**
	 * Retrieves the rank
	 * 
	 * @return The rank
	 */
	public float getRank() {
		return rank;
	}

	/**
	 * Sets the rank
	 * 
	 * @param rank The rank
	 */
	public void setRank(float rank) {
		this.rank = rank;
	}
}
