package org.gcube.indexmanagement.bdbwrapper;

import java.util.ArrayList;
import java.util.LinkedHashMap;

import org.gcube.indexmanagement.gcqlwrapper.GcqlQueryContainer;

public class BDBGcqlQueryContainer extends GcqlQueryContainer{
	
	private ArrayList<ArrayList<SingleTerm>> bdbQueries =  new ArrayList<ArrayList<SingleTerm>>();
	private boolean distinct = false;
	
	public BDBGcqlQueryContainer(ArrayList<ArrayList<SingleTerm>> queries, LinkedHashMap<String, String> projectedFields, boolean distinct) {
		super(projectedFields);
		this.setBdbQueries(queries);
		this.distinct = distinct;
	}

	public void setBdbQueries(ArrayList<ArrayList<SingleTerm>> bdbQueries) {
		this.bdbQueries = bdbQueries;
	}

	public ArrayList<ArrayList<SingleTerm>> getBdbQueries() {
		return bdbQueries;
	}
	
	static class SingleTerm {
		
		private String field;
		private String relation;
		private String value;
		
		
		public SingleTerm(String field, String relation, String value) {
			super();
			this.field = field;
			this.relation = relation;
			this.value = value;
		}
		
		public String getField() {
			return field;
		}

		public void setField(String field) {
			this.field = field;
		}
		
		public String getRelation() {
			return relation;
		}

		public void setRelation(String relation) {
			this.relation = relation;
		}
		
		public String getValue() {
			return value;
		}

		public void setValue(String value) {
			this.value = value;
		}
		
	}

	public boolean getDistinct() {
		return distinct ;
	}

}
